/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.light;

import com.intellij.psi.OriginInfoAwareElement;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassInitializer;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiReferenceList;
import com.intellij.psi.impl.PsiClassImplUtil;
import com.intellij.psi.impl.light.LightMethodBuilder;
import com.intellij.psi.impl.light.LightModifierList;
import com.intellij.psi.impl.light.LightPsiClassBase;
import com.intellij.psi.impl.light.LightReferenceListBuilder;
import com.intellij.psi.impl.light.LightTypeParameterListBuilder;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LightPsiClassBuilder
extends LightPsiClassBase
implements OriginInfoAwareElement {
    private final LightModifierList myModifierList;
    private final LightReferenceListBuilder myImplementsList;
    private final LightReferenceListBuilder myExtendsList;
    private final LightTypeParameterListBuilder myTypeParametersList;
    private final Collection<PsiMethod> myMethods;
    private PsiElement myScope;
    private PsiClass myContainingClass;
    private String myOriginInfo;

    public LightPsiClassBuilder(@NotNull PsiElement context, @NotNull String name) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/psi/impl/light/LightPsiClassBuilder", "<init>"));
        }
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/psi/impl/light/LightPsiClassBuilder", "<init>"));
        }
        super(context, name);
        this.myModifierList = new LightModifierList(this.getManager());
        this.myImplementsList = new LightReferenceListBuilder(this.getManager(), PsiReferenceList.Role.IMPLEMENTS_LIST);
        this.myExtendsList = new LightReferenceListBuilder(this.getManager(), PsiReferenceList.Role.EXTENDS_LIST);
        this.myTypeParametersList = new LightTypeParameterListBuilder(this.getManager(), this.getLanguage());
        this.myMethods = ContainerUtil.newArrayList();
    }

    @Nullable
    public String getOriginInfo() {
        return this.myOriginInfo;
    }

    @Override
    @NotNull
    public LightModifierList getModifierList() {
        LightModifierList lightModifierList = this.myModifierList;
        if (lightModifierList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/light/LightPsiClassBuilder", "getModifierList"));
        }
        return lightModifierList;
    }

    @NotNull
    public LightReferenceListBuilder getExtendsList() {
        LightReferenceListBuilder lightReferenceListBuilder = this.myExtendsList;
        if (lightReferenceListBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/light/LightPsiClassBuilder", "getExtendsList"));
        }
        return lightReferenceListBuilder;
    }

    @NotNull
    public LightReferenceListBuilder getImplementsList() {
        LightReferenceListBuilder lightReferenceListBuilder = this.myImplementsList;
        if (lightReferenceListBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/light/LightPsiClassBuilder", "getImplementsList"));
        }
        return lightReferenceListBuilder;
    }

    @NotNull
    public PsiField[] getFields() {
        if (PsiField.EMPTY_ARRAY == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/light/LightPsiClassBuilder", "getFields"));
        }
        return PsiField.EMPTY_ARRAY;
    }

    @NotNull
    public PsiMethod[] getMethods() {
        PsiMethod[] psiMethodArray = this.myMethods.toArray(new PsiMethod[this.myMethods.size()]);
        if (psiMethodArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/light/LightPsiClassBuilder", "getMethods"));
        }
        return psiMethodArray;
    }

    @NotNull
    public PsiClass[] getInnerClasses() {
        if (PsiClass.EMPTY_ARRAY == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/light/LightPsiClassBuilder", "getInnerClasses"));
        }
        return PsiClass.EMPTY_ARRAY;
    }

    @NotNull
    public PsiClassInitializer[] getInitializers() {
        if (PsiClassInitializer.EMPTY_ARRAY == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/light/LightPsiClassBuilder", "getInitializers"));
        }
        return PsiClassInitializer.EMPTY_ARRAY;
    }

    public PsiElement getScope() {
        return this.myScope;
    }

    @Nullable
    public PsiClass getContainingClass() {
        return this.myContainingClass;
    }

    @NotNull
    public LightTypeParameterListBuilder getTypeParameterList() {
        LightTypeParameterListBuilder lightTypeParameterListBuilder = this.myTypeParametersList;
        if (lightTypeParameterListBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/light/LightPsiClassBuilder", "getTypeParameterList"));
        }
        return lightTypeParameterListBuilder;
    }

    @Override
    public boolean isEquivalentTo(PsiElement another) {
        return PsiClassImplUtil.isClassEquivalentTo(this, another);
    }

    public LightPsiClassBuilder setOriginInfo(String originInfo) {
        this.myOriginInfo = originInfo;
        return this;
    }

    public LightPsiClassBuilder setScope(PsiElement scope) {
        this.myScope = scope;
        return this;
    }

    public LightPsiClassBuilder setContainingClass(PsiClass containingClass) {
        this.myContainingClass = containingClass;
        return this;
    }

    public LightPsiClassBuilder addMethod(PsiMethod method) {
        if (method instanceof LightMethodBuilder) {
            ((LightMethodBuilder)method).setContainingClass(this);
        }
        this.myMethods.add(method);
        return this;
    }
}

