/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.filters.getters;

import com.intellij.codeInsight.completion.CompletionContext;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.filters.ContextGetter;
import com.intellij.psi.impl.source.xml.XmlTokenImpl;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlElement;
import com.intellij.psi.xml.XmlTokenType;
import com.intellij.util.ArrayUtil;
import com.intellij.xml.XmlAttributeDescriptor;
import com.intellij.xml.impl.BasicXmlAttributeDescriptor;
import com.intellij.xml.impl.XmlEnumerationDescriptor;
import org.jetbrains.annotations.Nullable;

public class XmlAttributeValueGetter
implements ContextGetter {
    @Override
    public Object[] get(PsiElement context, CompletionContext completionContext) {
        return this.getApplicableAttributeVariants(context);
    }

    @Nullable
    public static String[] getEnumeratedValues(XmlAttribute attribute) {
        XmlAttributeDescriptor descriptor = attribute.getDescriptor();
        if (descriptor == null) {
            return ArrayUtil.EMPTY_STRING_ARRAY;
        }
        String[] result = descriptor instanceof BasicXmlAttributeDescriptor ? ((BasicXmlAttributeDescriptor)descriptor).getEnumeratedValues((XmlElement)attribute) : (descriptor instanceof XmlEnumerationDescriptor ? ((XmlEnumerationDescriptor)descriptor).getValuesForCompletion() : descriptor.getEnumeratedValues());
        return result != null ? StringUtil.filterEmptyStrings((String[])result) : null;
    }

    private Object[] getApplicableAttributeVariants(PsiElement _context) {
        XmlAttributeDescriptor descriptor;
        XmlAttribute attr;
        if (_context instanceof XmlTokenImpl && ((XmlTokenImpl)_context).getTokenType() == XmlTokenType.XML_ATTRIBUTE_VALUE_TOKEN && (attr = (XmlAttribute)PsiTreeUtil.getParentOfType((PsiElement)_context, XmlAttribute.class)) != null && (descriptor = attr.getDescriptor()) != null) {
            if (descriptor.isFixed()) {
                Object[] objectArray;
                String defaultValue = descriptor.getDefaultValue();
                if (defaultValue == null) {
                    objectArray = ArrayUtil.EMPTY_OBJECT_ARRAY;
                } else {
                    Object[] objectArray2 = new Object[1];
                    objectArray = objectArray2;
                    objectArray2[0] = defaultValue;
                }
                return objectArray;
            }
            String[] values = XmlAttributeValueGetter.getEnumeratedValues(attr);
            String[] strings = this.addSpecificCompletions(attr);
            if (values == null || values.length == 0) {
                values = strings;
            } else if (strings != null) {
                values = ArrayUtil.mergeArrays((String[])values, (String[])strings);
            }
            return values == null ? ArrayUtil.EMPTY_OBJECT_ARRAY : values;
        }
        return ArrayUtil.EMPTY_OBJECT_ARRAY;
    }

    @Nullable
    protected String[] addSpecificCompletions(XmlAttribute context) {
        return null;
    }
}

