/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.actions;

import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.VcsDataKeys;
import com.intellij.openapi.vcs.changes.ChangeList;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.changes.LocalChangeList;
import com.intellij.openapi.vcs.changes.actions.ChangeListRemoveConfirmation;
import java.util.Arrays;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

public class RemoveChangeListAction
extends AnAction
implements DumbAware {
    public void update(AnActionEvent e) {
        Project project2 = (Project)e.getData(CommonDataKeys.PROJECT);
        ChangeList[] lists = (ChangeList[])e.getData(VcsDataKeys.CHANGE_LISTS);
        boolean visible = RemoveChangeListAction.canRemoveChangeLists(project2, lists);
        if (e.getPlace().equals("ChangesViewPopup")) {
            e.getPresentation().setVisible(visible);
        } else {
            e.getPresentation().setEnabled(visible);
        }
    }

    private static boolean canRemoveChangeLists(Project project2, ChangeList[] lists) {
        if (project2 == null || lists == null || lists.length == 0) {
            return false;
        }
        for (ChangeList changeList : lists) {
            if (!(changeList instanceof LocalChangeList)) {
                return false;
            }
            LocalChangeList localChangeList = (LocalChangeList)changeList;
            if (localChangeList.isReadOnly()) {
                return false;
            }
            if (!localChangeList.isDefault() || ChangeListManager.getInstance((Project)project2).getChangeListsCopy().size() > lists.length) continue;
            return false;
        }
        return true;
    }

    public void actionPerformed(AnActionEvent e) {
        final Project project2 = (Project)e.getData(CommonDataKeys.PROJECT);
        ChangeList[] lists = (ChangeList[])e.getData(VcsDataKeys.CHANGE_LISTS);
        assert (lists != null);
        if (!RemoveChangeListAction.canRemoveChangeLists(project2, lists)) {
            return;
        }
        ChangeListRemoveConfirmation.processLists(project2, true, Arrays.asList(lists), new ChangeListRemoveConfirmation(){

            @Override
            public boolean askIfShouldRemoveChangeLists(@NotNull List<? extends LocalChangeList> lists1) {
                if (lists1 == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "lists1", "com/intellij/openapi/vcs/changes/actions/RemoveChangeListAction$1", "askIfShouldRemoveChangeLists"));
                }
                return RemoveChangeListAction.askIfShouldRemoveChangeLists(lists1, project2);
            }
        });
    }

    private static boolean askIfShouldRemoveChangeLists(@NotNull List<? extends LocalChangeList> lists, Project project2) {
        int rc;
        if (lists == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "lists", "com/intellij/openapi/vcs/changes/actions/RemoveChangeListAction", "askIfShouldRemoveChangeLists"));
        }
        for (LocalChangeList localChangeList : lists) {
            if (!localChangeList.isDefault()) continue;
            return RemoveChangeListAction.confirmActiveChangeListRemoval(project2, lists, localChangeList.getChanges().isEmpty());
        }
        if (lists.size() == 1) {
            LocalChangeList localChangeList = lists.get(0);
            rc = localChangeList.getChanges().size() == 0 ? 0 : Messages.showYesNoDialog((Project)project2, (String)VcsBundle.message((String)"changes.removechangelist.warning.text", (Object[])new Object[]{localChangeList.getName()}), (String)VcsBundle.message((String)"changes.removechangelist.warning.title", (Object[])new Object[0]), (Icon)Messages.getQuestionIcon());
        } else {
            int n;
            boolean bl = false;
            for (ChangeList changeList : lists) {
                n |= changeList.getChanges().size() > 0 ? 1 : 0;
            }
            rc = n == 0 ? 0 : Messages.showYesNoDialog((Project)project2, (String)VcsBundle.message((String)"changes.removechangelist.multiple.warning.text", (Object[])new Object[]{lists.size()}), (String)VcsBundle.message((String)"changes.removechangelist.warning.title", (Object[])new Object[0]), (Icon)Messages.getQuestionIcon());
        }
        return rc == 0;
    }

    static boolean confirmActiveChangeListRemoval(Project project2, List<? extends LocalChangeList> lists, boolean empty) {
        List remainingLists = ChangeListManager.getInstance((Project)project2).getChangeListsCopy();
        remainingLists.removeAll(lists);
        String[] names = new String[remainingLists.size()];
        for (int i = 0; i < remainingLists.size(); ++i) {
            names[i] = ((LocalChangeList)remainingLists.get(i)).getName();
        }
        int nameIndex = Messages.showChooseDialog((Project)project2, (String)(empty ? VcsBundle.message((String)"changes.remove.active.empty.prompt", (Object[])new Object[0]) : VcsBundle.message((String)"changes.remove.active.prompt", (Object[])new Object[0])), (String)VcsBundle.message((String)"changes.remove.active.title", (Object[])new Object[0]), (Icon)Messages.getQuestionIcon(), (String[])names, (String)names[0]);
        if (nameIndex < 0) {
            return false;
        }
        ChangeListManager.getInstance((Project)project2).setDefaultChangeList((LocalChangeList)remainingLists.get(nameIndex));
        return true;
    }
}

