/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diff.DiffContent;
import com.intellij.openapi.diff.SimpleContent;
import com.intellij.openapi.diff.impl.DiffHighlighterFactory;
import com.intellij.openapi.diff.impl.DiffHighlighterFactoryImpl;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.highlighter.EditorHighlighter;
import com.intellij.openapi.editor.highlighter.FragmentedEditorHighlighter;
import com.intellij.openapi.editor.highlighter.HighlighterClient;
import com.intellij.openapi.editor.highlighter.HighlighterIterator;
import com.intellij.openapi.editor.highlighter.LightHighlighterClient;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Getter;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsConfiguration;
import com.intellij.openapi.vcs.changes.ChangeOutdatedException;
import com.intellij.openapi.vcs.changes.FragmentedContent;
import com.intellij.openapi.vcs.changes.LineNumberConvertor;
import com.intellij.openapi.vcs.changes.TodoForBaseRevision;
import com.intellij.openapi.vcs.changes.TodoForExistingFile;
import com.intellij.openapi.vcs.history.VcsRevisionNumber;
import com.intellij.openapi.vcs.impl.ContentRevisionCache;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.BeforeAfter;
import com.intellij.util.Consumer;
import com.intellij.util.continuation.ModalityIgnorantBackgroundableTask;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.ListIterator;

public class PreparedFragmentedContent {
    private LineNumberConvertor oldConvertor;
    private LineNumberConvertor newConvertor;
    private StringBuilder sbOld;
    private StringBuilder sbNew;
    private List<TextRange> myBeforeFragments;
    private List<TextRange> myAfterFragments;
    private List<BeforeAfter<Integer>> myLineRanges;
    private boolean myOneSide;
    private boolean myIsAddition;
    private FragmentedEditorHighlighter myBeforeHighlighter;
    private FragmentedEditorHighlighter myAfterHighlighter;
    private List<Pair<TextRange, TextAttributes>> myBeforeTodoRanges;
    private List<Pair<TextRange, TextAttributes>> myAfterTodoRanges;
    private final Project myProject;
    private final FragmentedContent myFragmentedContent;
    private final String myFileName;
    private final FileType myFileType;
    private final VcsRevisionNumber myBeforeNumber;
    private final VcsRevisionNumber myAfterNumber;
    private VirtualFile myFile;
    private FilePath myFilePath;

    public PreparedFragmentedContent(Project project2, FragmentedContent fragmentedContent, String fileName, FileType fileType, VcsRevisionNumber beforeNumber, VcsRevisionNumber afterNumber, FilePath path, VirtualFile file2) {
        this.myFile = file2;
        this.myProject = project2;
        this.myFragmentedContent = fragmentedContent;
        this.myFileName = fileName;
        this.myFileType = fileType;
        this.myBeforeNumber = beforeNumber;
        this.myAfterNumber = afterNumber;
        this.myFilePath = path;
        this.oldConvertor = new LineNumberConvertor();
        this.newConvertor = new LineNumberConvertor();
        this.sbOld = new StringBuilder();
        this.sbNew = new StringBuilder();
        this.myBeforeFragments = new ArrayList<TextRange>(fragmentedContent.getSize());
        this.myAfterFragments = new ArrayList<TextRange>(fragmentedContent.getSize());
        this.myLineRanges = new ArrayList<BeforeAfter<Integer>>();
        this.fromFragmentedContent(fragmentedContent);
    }

    public void recalculate() {
        this.oldConvertor = new LineNumberConvertor();
        this.newConvertor = new LineNumberConvertor();
        this.sbOld = new StringBuilder();
        this.sbNew = new StringBuilder();
        this.myBeforeFragments = new ArrayList<TextRange>(this.myFragmentedContent.getSize());
        this.myAfterFragments = new ArrayList<TextRange>(this.myFragmentedContent.getSize());
        this.myLineRanges = new ArrayList<BeforeAfter<Integer>>();
        this.checkFileOutdated();
        this.fromFragmentedContent(this.myFragmentedContent);
    }

    private void checkFileOutdated() {
        if (this.myOneSide ? this.myIsAddition && (this.myFile == null || !this.myFile.isValid()) : this.myFile == null || !this.myFile.isValid()) {
            throw new ChangeOutdatedException();
        }
    }

    private void fromFragmentedContent(final FragmentedContent fragmentedContent) {
        ApplicationManager.getApplication().runReadAction(new Runnable(){

            @Override
            public void run() {
                if (DumbService.isDumb((Project)PreparedFragmentedContent.this.myProject)) {
                    throw new ModalityIgnorantBackgroundableTask.ToBeRepeatedException();
                }
                PreparedFragmentedContent.this.myOneSide = fragmentedContent.isOneSide();
                PreparedFragmentedContent.this.myIsAddition = fragmentedContent.isAddition();
                List<BeforeAfter<TextRange>> expandedRanges = PreparedFragmentedContent.expand(fragmentedContent.getRanges(), VcsConfiguration.getInstance((Project)((PreparedFragmentedContent)PreparedFragmentedContent.this).myProject).SHORT_DIFF_EXTRA_LINES, fragmentedContent.getBefore(), fragmentedContent.getAfter());
                Document document = fragmentedContent.getBefore();
                Document document1 = fragmentedContent.getAfter();
                BeforeAfter lines = new BeforeAfter((Object)0, (Object)0);
                for (BeforeAfter<TextRange> lineNumbers : expandedRanges) {
                    if ((Integer)lines.getBefore() > 0 || (Integer)lines.getAfter() > 0) {
                        PreparedFragmentedContent.this.oldConvertor.emptyLine((Integer)lines.getBefore());
                        PreparedFragmentedContent.this.newConvertor.emptyLine((Integer)lines.getAfter());
                        lines = new BeforeAfter((Object)((Integer)lines.getBefore() + 1), (Object)((Integer)lines.getAfter() + 1));
                        PreparedFragmentedContent.this.sbOld.append('\n');
                        PreparedFragmentedContent.this.sbNew.append('\n');
                    }
                    PreparedFragmentedContent.this.myLineRanges.add(lines);
                    PreparedFragmentedContent.this.oldConvertor.put((Integer)lines.getBefore(), ((TextRange)lineNumbers.getBefore()).getStartOffset());
                    PreparedFragmentedContent.this.newConvertor.put((Integer)lines.getAfter(), ((TextRange)lineNumbers.getAfter()).getStartOffset());
                    if (PreparedFragmentedContent.this.sbOld.length() > 0) {
                        PreparedFragmentedContent.this.sbOld.append('\n');
                    }
                    TextRange beforeRange = new TextRange(document.getLineStartOffset(((TextRange)lineNumbers.getBefore()).getStartOffset()), document.getLineEndOffset(((TextRange)lineNumbers.getBefore()).getEndOffset()));
                    PreparedFragmentedContent.this.myBeforeFragments.add(beforeRange);
                    PreparedFragmentedContent.this.sbOld.append(document.getText(beforeRange));
                    if (PreparedFragmentedContent.this.sbNew.length() > 0) {
                        PreparedFragmentedContent.this.sbNew.append('\n');
                    }
                    TextRange afterRange = new TextRange(document1.getLineStartOffset(((TextRange)lineNumbers.getAfter()).getStartOffset()), document1.getLineEndOffset(((TextRange)lineNumbers.getAfter()).getEndOffset()));
                    PreparedFragmentedContent.this.myAfterFragments.add(afterRange);
                    PreparedFragmentedContent.this.sbNew.append(document1.getText(afterRange));
                    int before = (Integer)lines.getBefore() + ((TextRange)lineNumbers.getBefore()).getEndOffset() - ((TextRange)lineNumbers.getBefore()).getStartOffset() + 1;
                    int after2 = (Integer)lines.getAfter() + ((TextRange)lineNumbers.getAfter()).getEndOffset() - ((TextRange)lineNumbers.getAfter()).getStartOffset() + 1;
                    lines = new BeforeAfter((Object)before, (Object)after2);
                }
                PreparedFragmentedContent.this.myLineRanges.add(new BeforeAfter((Object)((Integer)lines.getBefore() == 0 ? 0 : (Integer)lines.getBefore() - 1), (Object)((Integer)lines.getAfter() == 0 ? 0 : (Integer)lines.getAfter() - 1)));
                if (!expandedRanges.isEmpty()) {
                    BeforeAfter<TextRange> last = expandedRanges.get(expandedRanges.size() - 1);
                    if (PreparedFragmentedContent.this.sbOld.length() > 0 && document.getLineEndOffset(((TextRange)last.getBefore()).getEndOffset()) != document.getTextLength()) {
                        PreparedFragmentedContent.this.sbOld.append('\n');
                        PreparedFragmentedContent.this.oldConvertor.emptyLine((Integer)lines.getBefore());
                    }
                    if (PreparedFragmentedContent.this.sbNew.length() > 0 && document1.getLineEndOffset(((TextRange)last.getAfter()).getEndOffset()) != document1.getTextLength()) {
                        PreparedFragmentedContent.this.sbNew.append('\n');
                        PreparedFragmentedContent.this.newConvertor.emptyLine((Integer)lines.getAfter());
                    }
                }
                PreparedFragmentedContent.this.setHighlighters(fragmentedContent.getBefore(), fragmentedContent.getAfter(), expandedRanges, fragmentedContent);
                PreparedFragmentedContent.this.setTodoHighlighting(fragmentedContent.getBefore(), fragmentedContent.getAfter());
            }
        });
    }

    public LineNumberConvertor getOldConvertor() {
        return this.oldConvertor;
    }

    public LineNumberConvertor getNewConvertor() {
        return this.newConvertor;
    }

    public DiffContent createBeforeContent() {
        if (this.isAddition()) {
            return SimpleContent.createEmpty();
        }
        return new SimpleContent(this.getSbOld().toString());
    }

    public DiffContent createAfterContent() {
        if (this.isDeletion()) {
            return SimpleContent.createEmpty();
        }
        return new SimpleContent(this.getSbNew().toString());
    }

    public StringBuilder getSbOld() {
        return this.sbOld;
    }

    public StringBuilder getSbNew() {
        return this.sbNew;
    }

    public List<TextRange> getBeforeFragments() {
        return this.myBeforeFragments;
    }

    public List<TextRange> getAfterFragments() {
        return this.myAfterFragments;
    }

    public List<BeforeAfter<Integer>> getLineRanges() {
        return this.myLineRanges;
    }

    public boolean isOneSide() {
        return this.myOneSide;
    }

    public boolean isAddition() {
        return this.myOneSide && this.myIsAddition;
    }

    public boolean isDeletion() {
        return this.myOneSide && !this.myIsAddition;
    }

    public FragmentedEditorHighlighter getBeforeHighlighter() {
        return this.myBeforeHighlighter;
    }

    public void setBeforeHighlighter(FragmentedEditorHighlighter beforeHighlighter) {
        this.myBeforeHighlighter = beforeHighlighter;
    }

    public FragmentedEditorHighlighter getAfterHighlighter() {
        return this.myAfterHighlighter;
    }

    public void setAfterHighlighter(FragmentedEditorHighlighter afterHighlighter) {
        this.myAfterHighlighter = afterHighlighter;
    }

    public boolean isEmpty() {
        return this.myLineRanges.isEmpty();
    }

    public void setAfterTodoRanges(List<Pair<TextRange, TextAttributes>> afterTodoRanges) {
        this.myAfterTodoRanges = afterTodoRanges;
    }

    public List<Pair<TextRange, TextAttributes>> getBeforeTodoRanges() {
        return this.myBeforeTodoRanges;
    }

    public List<Pair<TextRange, TextAttributes>> getAfterTodoRanges() {
        return this.myAfterTodoRanges;
    }

    public void setBeforeTodoRanges(List<Pair<TextRange, TextAttributes>> beforeTodoRanges) {
        this.myBeforeTodoRanges = beforeTodoRanges;
    }

    public static List<BeforeAfter<TextRange>> expand(List<BeforeAfter<TextRange>> myRanges, int lines, Document oldDocument, Document document) {
        if (myRanges == null || myRanges.isEmpty()) {
            return Collections.emptyList();
        }
        if (lines == -1) {
            ArrayList<BeforeAfter<TextRange>> shiftedRanges = new ArrayList<BeforeAfter<TextRange>>(1);
            shiftedRanges.add(new BeforeAfter((Object)new TextRange(0, oldDocument.getLineCount() == 0 ? 0 : oldDocument.getLineCount() - 1), (Object)new TextRange(0, document.getLineCount() == 0 ? 0 : document.getLineCount() - 1)));
            return shiftedRanges;
        }
        ArrayList<BeforeAfter> shiftedRanges = new ArrayList<BeforeAfter>(myRanges.size());
        int oldLineCount = oldDocument.getLineCount();
        int lineCount = document.getLineCount();
        for (BeforeAfter<TextRange> range : myRanges) {
            TextRange newBefore = PreparedFragmentedContent.expandRange((TextRange)range.getBefore(), lines, oldLineCount);
            TextRange newAfter = PreparedFragmentedContent.expandRange((TextRange)range.getAfter(), lines, lineCount);
            shiftedRanges.add(new BeforeAfter((Object)newBefore, (Object)newAfter));
        }
        ArrayList<BeforeAfter<TextRange>> zippedRanges = new ArrayList<BeforeAfter<TextRange>>(myRanges.size());
        ListIterator iterator = shiftedRanges.listIterator();
        BeforeAfter previous = (BeforeAfter)iterator.next();
        while (iterator.hasNext()) {
            BeforeAfter current = (BeforeAfter)iterator.next();
            if (PreparedFragmentedContent.neighbourOrIntersect((TextRange)previous.getBefore(), (TextRange)current.getBefore()) || PreparedFragmentedContent.neighbourOrIntersect((TextRange)previous.getAfter(), (TextRange)current.getAfter())) {
                previous = new BeforeAfter((Object)((TextRange)previous.getBefore()).union((TextRange)current.getBefore()), (Object)((TextRange)previous.getAfter()).union((TextRange)current.getAfter()));
                continue;
            }
            zippedRanges.add((BeforeAfter<TextRange>)previous);
            previous = current;
        }
        zippedRanges.add(previous);
        return zippedRanges;
    }

    private static boolean neighbourOrIntersect(TextRange a, TextRange b) {
        return a.getEndOffset() + 1 == b.getStartOffset() || a.intersects(b);
    }

    private static TextRange expandRange(TextRange range, int shift, int size) {
        return new TextRange(Math.max(0, range.getStartOffset() - shift), Math.max(0, Math.min(size - 1, range.getEndOffset() + shift)));
    }

    private void setHighlighters(Document oldDocument, Document document, List<BeforeAfter<TextRange>> ranges, FragmentedContent fragmentedContent) {
        EditorHighlighter highlighter = this.createHighlighter(fragmentedContent.getFileTypeBefore(), fragmentedContent.getFileBefore(), fragmentedContent.getFileAfter(), this.myProject).createHighlighter();
        highlighter.setEditor((HighlighterClient)new LightHighlighterClient(oldDocument, this.myProject));
        highlighter.setText((CharSequence)oldDocument.getText());
        HighlighterIterator iterator = highlighter.createIterator(((TextRange)ranges.get(0).getBefore()).getStartOffset());
        FragmentedEditorHighlighter beforeHighlighter = new FragmentedEditorHighlighter(iterator, this.getBeforeFragments(), 1, true);
        this.setBeforeHighlighter(beforeHighlighter);
        EditorHighlighter highlighter1 = this.createHighlighter(fragmentedContent.getFileTypeAfter(), fragmentedContent.getFileAfter(), fragmentedContent.getFileBefore(), this.myProject).createHighlighter();
        highlighter1.setEditor((HighlighterClient)new LightHighlighterClient(document, this.myProject));
        highlighter1.setText((CharSequence)document.getText());
        HighlighterIterator iterator1 = highlighter1.createIterator(((TextRange)ranges.get(0).getAfter()).getStartOffset());
        FragmentedEditorHighlighter afterHighlighter = new FragmentedEditorHighlighter(iterator1, this.getAfterFragments(), 1, true);
        this.setAfterHighlighter(afterHighlighter);
    }

    private DiffHighlighterFactory createHighlighter(FileType contentType, VirtualFile file2, VirtualFile otherFile, Project project2) {
        VirtualFile baseFile = file2;
        if (baseFile == null) {
            baseFile = otherFile;
        }
        if (contentType == null) {
            contentType = this.myFileType;
        }
        return new DiffHighlighterFactoryImpl(contentType, baseFile, project2);
    }

    private void setTodoHighlighting(Document oldDocument, Document document) {
        final ContentRevisionCache cache = ProjectLevelVcsManager.getInstance((Project)this.myProject).getContentRevisionCache();
        List<Pair<TextRange, TextAttributes>> beforeTodoRanges = this.myBeforeNumber == null ? Collections.emptyList() : new TodoForBaseRevision(this.myProject, this.getBeforeFragments(), 1, this.myFileName, oldDocument.getText(), true, this.myFileType, new Getter<Object>(){

            public Object get() {
                return cache.getCustom(PreparedFragmentedContent.this.myFilePath, PreparedFragmentedContent.this.myBeforeNumber);
            }
        }, new Consumer<Object>(){

            public void consume(Object items) {
                cache.putCustom(PreparedFragmentedContent.this.myFilePath, PreparedFragmentedContent.this.myBeforeNumber, items);
            }
        }).execute();
        List<Pair<TextRange, TextAttributes>> afterTodoRanges = new TodoForExistingFile(this.myProject, this.getAfterFragments(), 1, this.myFileName, document.getText(), false, this.myFileType, this.myFile).execute();
        this.setBeforeTodoRanges(beforeTodoRanges);
        this.setAfterTodoRanges(afterTodoRanges);
    }

    public VirtualFile getFile() {
        return this.myFile;
    }

    public FileType getFileType() {
        return this.myFileType;
    }
}

