/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.fileEditor.impl;

import com.intellij.icons.AllIcons;
import com.intellij.ide.GeneralSettings;
import com.intellij.ide.IdeEventQueue;
import com.intellij.ide.actions.CloseAction;
import com.intellij.ide.actions.ShowFilePathAction;
import com.intellij.ide.ui.UISettings;
import com.intellij.ide.ui.UISettingsListener;
import com.intellij.ide.ui.customization.CustomActionsSchema;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.ex.FileEditorManagerEx;
import com.intellij.openapi.fileEditor.ex.IdeDocumentHistory;
import com.intellij.openapi.fileEditor.impl.DockableEditorTabbedContainer;
import com.intellij.openapi.fileEditor.impl.EditorTabColorProvider;
import com.intellij.openapi.fileEditor.impl.EditorTabTitleProvider;
import com.intellij.openapi.fileEditor.impl.EditorWindow;
import com.intellij.openapi.fileEditor.impl.FileEditorManagerImpl;
import com.intellij.openapi.fileEditor.impl.IdeDocumentHistoryImpl;
import com.intellij.openapi.fileEditor.impl.text.FileDropHandler;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Queryable;
import com.intellij.openapi.ui.ShadowAction;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.openapi.util.ActiveRunnable;
import com.intellij.openapi.util.AsyncResult;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Getter;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowAnchor;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.openapi.wm.ToolWindowType;
import com.intellij.openapi.wm.ex.ToolWindowManagerAdapter;
import com.intellij.openapi.wm.ex.ToolWindowManagerEx;
import com.intellij.ui.InplaceButton;
import com.intellij.ui.docking.DockContainer;
import com.intellij.ui.docking.DockManager;
import com.intellij.ui.docking.DockableContent;
import com.intellij.ui.docking.DragSession;
import com.intellij.ui.switcher.SwitchProvider;
import com.intellij.ui.switcher.SwitchTarget;
import com.intellij.ui.tabs.JBTabs;
import com.intellij.ui.tabs.JBTabsPosition;
import com.intellij.ui.tabs.TabInfo;
import com.intellij.ui.tabs.TabsListener;
import com.intellij.ui.tabs.UiDecorator;
import com.intellij.ui.tabs.impl.JBEditorTabs;
import com.intellij.ui.tabs.impl.JBTabsImpl;
import com.intellij.util.Consumer;
import com.intellij.util.ui.AwtVisitor;
import com.intellij.util.ui.TimedDeadzone;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.event.InputEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.TransferHandler;
import javax.swing.border.Border;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class EditorTabbedContainer
implements Disposable,
CloseAction.CloseTarget {
    private final EditorWindow myWindow;
    private final Project myProject;
    private final JBEditorTabs myTabs;
    @NonNls
    public static final String HELP_ID = "ideaInterface.editor";
    private TabInfo.DragOutDelegate myDragOutDelegate = new MyDragOutDelegate();

    EditorTabbedContainer(EditorWindow window, Project project2, int tabPlacement) {
        this.myWindow = window;
        this.myProject = project2;
        ActionManager actionManager = ActionManager.getInstance();
        this.myTabs = new JBEditorTabs(project2, actionManager, IdeFocusManager.getInstance((Project)project2), (Disposable)this);
        this.myTabs.setBorder((Border)new MyShadowBorder(this.myTabs));
        this.myTabs.setTransferHandler((TransferHandler)new MyTransferHandler());
        this.myTabs.setDataProvider((DataProvider)new MyDataProvider()).setPopupGroup((Getter)new Getter<ActionGroup>(){

            public ActionGroup get() {
                return (ActionGroup)CustomActionsSchema.getInstance().getCorrectedAction("EditorTabPopupMenu");
            }
        }, "EditorTabPopup", false).setNavigationActionsEnabled(false).addTabMouseListener((MouseListener)new TabMouseListener()).getPresentation().setTabDraggingEnabled(true).setUiDecorator(new UiDecorator(){

            @NotNull
            public UiDecorator.UiDecoration getDecoration() {
                UiDecorator.UiDecoration uiDecoration = new UiDecorator.UiDecoration(null, new Insets(2, 8, 2, 8));
                if (uiDecoration == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/fileEditor/impl/EditorTabbedContainer$3", "getDecoration"));
                }
                return uiDecoration;
            }
        }).setTabLabelActionsMouseDeadzone(TimedDeadzone.NULL).setGhostsAlwaysVisible(true).setTabLabelActionsAutoHide(false).setActiveTabFillIn(EditorColorsManager.getInstance().getGlobalScheme().getDefaultBackground()).setPaintFocus(false).getJBTabs().addListener((TabsListener)new TabsListener.Adapter(){

            public void selectionChanged(TabInfo oldSelection, TabInfo newSelection) {
                VirtualFile newFile;
                FileEditor newEditor;
                FileEditor oldEditor;
                FileEditorManager editorManager = FileEditorManager.getInstance((Project)EditorTabbedContainer.this.myProject);
                FileEditor fileEditor = oldEditor = oldSelection != null ? editorManager.getSelectedEditor((VirtualFile)oldSelection.getObject()) : null;
                if (oldEditor != null) {
                    oldEditor.deselectNotify();
                }
                if ((newEditor = editorManager.getSelectedEditor(newFile = (VirtualFile)newSelection.getObject())) != null) {
                    newEditor.selectNotify();
                }
                if (GeneralSettings.getInstance().isSyncOnFrameActivation()) {
                    newFile.refresh(true, false);
                }
            }
        }).setAdditionalSwitchProviderWhenOriginal((SwitchProvider)new MySwitchProvider()).setSelectionChangeHandler(new JBTabs.SelectionChangeHandler(){

            @NotNull
            public ActionCallback execute(TabInfo info, boolean requestFocus, final @NotNull ActiveRunnable doChangeSelection) {
                if (doChangeSelection == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "doChangeSelection", "com/intellij/openapi/fileEditor/impl/EditorTabbedContainer$1", "execute"));
                }
                final ActionCallback result = new ActionCallback();
                CommandProcessor.getInstance().executeCommand(EditorTabbedContainer.this.myProject, new Runnable(){

                    @Override
                    public void run() {
                        ((IdeDocumentHistoryImpl)IdeDocumentHistory.getInstance(EditorTabbedContainer.this.myProject)).onSelectionChanged();
                        result.notify(doChangeSelection.run());
                    }
                }, "EditorChange", null);
                ActionCallback actionCallback = result;
                if (actionCallback == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/fileEditor/impl/EditorTabbedContainer$1", "execute"));
                }
                return actionCallback;
            }
        }).getPresentation().setRequestFocusOnLastFocusedComponent(true);
        this.myTabs.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (EditorTabbedContainer.this.myTabs.findInfo(e) != null || EditorTabbedContainer.this.isFloating()) {
                    return;
                }
                if (!e.isPopupTrigger() && SwingUtilities.isLeftMouseButton(e) && e.getClickCount() == 2) {
                    ActionManager mgr = ActionManager.getInstance();
                    mgr.tryToExecute(mgr.getAction("HideAllWindows"), (InputEvent)e, null, "unknown", true);
                }
            }
        });
        this.setTabPlacement(UISettings.getInstance().EDITOR_TAB_PLACEMENT);
        this.updateTabBorder();
        ((ToolWindowManagerEx)ToolWindowManager.getInstance((Project)this.myProject)).addToolWindowManagerListener(new ToolWindowManagerAdapter(){

            @Override
            public void stateChanged() {
                EditorTabbedContainer.this.updateTabBorder();
            }

            @Override
            public void toolWindowRegistered(@NotNull String id) {
                if (id == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "id", "com/intellij/openapi/fileEditor/impl/EditorTabbedContainer$6", "toolWindowRegistered"));
                }
                EditorTabbedContainer.this.updateTabBorder();
            }
        });
        UISettings.getInstance().addUISettingsListener(new UISettingsListener(){

            public void uiSettingsChanged(UISettings source) {
                EditorTabbedContainer.this.updateTabBorder();
            }
        }, (Disposable)this);
        Disposer.register((Disposable)project2, (Disposable)this);
    }

    public int getTabCount() {
        return this.myTabs.getTabCount();
    }

    public ActionCallback setSelectedIndex(int indexToSelect) {
        return this.setSelectedIndex(indexToSelect, true);
    }

    public ActionCallback setSelectedIndex(int indexToSelect, boolean focusEditor) {
        if (indexToSelect >= this.myTabs.getTabCount()) {
            return ActionCallback.REJECTED;
        }
        return this.myTabs.select(this.myTabs.getTabAt(indexToSelect), focusEditor);
    }

    public static DockableEditor createDockableEditor(Project project2, Image image, VirtualFile file2, Presentation presentation, EditorWindow window) {
        return new DockableEditor(project2, image, file2, presentation, window.getSize(), window.isFilePinned(file2));
    }

    private void updateTabBorder() {
        if (!this.myProject.isOpen()) {
            return;
        }
        ToolWindowManagerEx mgr = (ToolWindowManagerEx)ToolWindowManager.getInstance((Project)this.myProject);
        String[] ids = mgr.getToolWindowIds();
        Insets border = new Insets(0, 0, 0, 0);
        UISettings uiSettings = UISettings.getInstance();
        List<String> topIds = mgr.getIdsOn(ToolWindowAnchor.TOP);
        List<String> bottom = mgr.getIdsOn(ToolWindowAnchor.BOTTOM);
        List<String> rightIds = mgr.getIdsOn(ToolWindowAnchor.RIGHT);
        List<String> leftIds = mgr.getIdsOn(ToolWindowAnchor.LEFT);
        if (!uiSettings.HIDE_TOOL_STRIPES && !uiSettings.PRESENTATION_MODE) {
            border.top = topIds.size() > 0 ? 1 : 0;
            border.bottom = bottom.size() > 0 ? 1 : 0;
            border.left = leftIds.size() > 0 ? 1 : 0;
            border.right = rightIds.size() > 0 ? 1 : 0;
        }
        for (String each : ids) {
            ToolWindow eachWnd = mgr.getToolWindow(each);
            if (eachWnd == null || !eachWnd.isAvailable() || !eachWnd.isVisible() || eachWnd.getType() != ToolWindowType.DOCKED) continue;
            ToolWindowAnchor eachAnchor = eachWnd.getAnchor();
            if (eachAnchor == ToolWindowAnchor.TOP) {
                border.top = 0;
                continue;
            }
            if (eachAnchor == ToolWindowAnchor.BOTTOM) {
                border.bottom = 0;
                continue;
            }
            if (eachAnchor == ToolWindowAnchor.LEFT) {
                border.left = 0;
                continue;
            }
            if (eachAnchor != ToolWindowAnchor.RIGHT) continue;
            border.right = 0;
        }
        this.myTabs.getPresentation().setPaintBorder(border.top, border.left, border.right, border.bottom).setTabSidePaintBorder(5);
    }

    @NotNull
    public JComponent getComponent() {
        JComponent jComponent = this.myTabs.getComponent();
        if (jComponent == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/fileEditor/impl/EditorTabbedContainer", "getComponent"));
        }
        return jComponent;
    }

    public ActionCallback removeTabAt(int componentIndex, int indexToSelect, boolean transferFocus) {
        TabInfo toSelect = indexToSelect >= 0 && indexToSelect < this.myTabs.getTabCount() ? this.myTabs.getTabAt(indexToSelect) : null;
        TabInfo info = this.myTabs.getTabAt(componentIndex);
        if (info.isHidden()) {
            toSelect = null;
        }
        ActionCallback callback = this.myTabs.removeTab(info, toSelect, transferFocus);
        return this.myProject.isOpen() ? callback : ActionCallback.DONE;
    }

    public ActionCallback removeTabAt(int componentIndex, int indexToSelect) {
        return this.removeTabAt(componentIndex, indexToSelect, true);
    }

    public int getSelectedIndex() {
        return this.myTabs.getIndexOf(this.myTabs.getSelectedInfo());
    }

    public void setForegroundAt(int index, Color color) {
        this.myTabs.getTabAt(index).setDefaultForeground(color);
    }

    public void setWaveColor(int index, @Nullable Color color) {
        TabInfo tab = this.myTabs.getTabAt(index);
        tab.setDefaultStyle(color == null ? 0 : 8);
        tab.setDefaultWaveColor(color);
    }

    public void setIconAt(int index, Icon icon) {
        this.myTabs.getTabAt(index).setIcon(icon);
    }

    public void setTitleAt(int index, String text) {
        this.myTabs.getTabAt(index).setText(text);
    }

    public void setToolTipTextAt(int index, String text) {
        this.myTabs.getTabAt(index).setTooltipText(text);
    }

    public void setBackgroundColorAt(int index, Color color) {
        this.myTabs.getTabAt(index).setTabColor(color);
    }

    public void setTabLayoutPolicy(int policy) {
        switch (policy) {
            case 1: {
                this.myTabs.getPresentation().setSingleRow(true);
                break;
            }
            case 0: {
                this.myTabs.getPresentation().setSingleRow(false);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported tab layout policy: " + policy);
            }
        }
    }

    public void setTabPlacement(int tabPlacement) {
        switch (tabPlacement) {
            case 1: {
                this.myTabs.getPresentation().setTabsPosition(JBTabsPosition.top);
                break;
            }
            case 3: {
                this.myTabs.getPresentation().setTabsPosition(JBTabsPosition.bottom);
                break;
            }
            case 2: {
                this.myTabs.getPresentation().setTabsPosition(JBTabsPosition.left);
                break;
            }
            case 4: {
                this.myTabs.getPresentation().setTabsPosition(JBTabsPosition.right);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown tab placement code=" + tabPlacement);
            }
        }
    }

    @Nullable
    public Object getSelectedComponent() {
        TabInfo info = this.myTabs.getTargetInfo();
        return info != null ? info.getComponent() : null;
    }

    public void insertTab(VirtualFile file2, Icon icon, JComponent comp, String tooltip, int indexToInsert) {
        TabInfo tab = this.myTabs.findInfo((Object)file2);
        if (tab != null) {
            return;
        }
        tab = new TabInfo(comp).setText(EditorTabbedContainer.calcTabTitle(this.myProject, file2)).setIcon(icon).setTooltipText(tooltip).setObject((Object)file2).setTabColor(EditorTabbedContainer.calcTabColor(this.myProject, file2)).setDragOutDelegate(this.myDragOutDelegate);
        tab.setTestableUi((Queryable)new MyQueryable(tab));
        DefaultActionGroup tabActions = new DefaultActionGroup();
        tabActions.add((AnAction)new CloseTab(comp, tab));
        tab.setTabLabelActions((ActionGroup)tabActions, "EditorTab");
        this.myTabs.addTabSilently(tab, indexToInsert);
    }

    public boolean isEmptyVisible() {
        return this.myTabs.isEmptyVisible();
    }

    public JBTabs getTabs() {
        return this.myTabs;
    }

    public void requestFocus(boolean forced) {
        if (this.myTabs != null) {
            IdeFocusManager.getInstance((Project)this.myProject).requestFocus((Component)this.myTabs.getComponent(), forced);
        }
    }

    public void setPaintBlocked(boolean blocked) {
        this.myTabs.setPaintBlocked(blocked, true);
    }

    public static String calcTabTitle(Project project2, VirtualFile file2) {
        for (EditorTabTitleProvider provider : (EditorTabTitleProvider[])Extensions.getExtensions(EditorTabTitleProvider.EP_NAME)) {
            String result = provider.getEditorTabTitle(project2, file2);
            if (result == null) continue;
            return result;
        }
        return file2.getPresentableName();
    }

    @Nullable
    public static Color calcTabColor(@NotNull Project project2, @NotNull VirtualFile file2) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/fileEditor/impl/EditorTabbedContainer", "calcTabColor"));
        }
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/fileEditor/impl/EditorTabbedContainer", "calcTabColor"));
        }
        for (EditorTabColorProvider provider : (EditorTabColorProvider[])Extensions.getExtensions(EditorTabColorProvider.EP_NAME)) {
            Color result = provider.getEditorTabColor(project2, file2);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    public Component getComponentAt(int i) {
        TabInfo tab = this.myTabs.getTabAt(i);
        return tab.getComponent();
    }

    public void dispose() {
    }

    @Override
    public void close() {
        TabInfo selected = this.myTabs.getTargetInfo();
        if (selected == null) {
            return;
        }
        final VirtualFile file2 = (VirtualFile)selected.getObject();
        final FileEditorManagerEx mgr = FileEditorManagerEx.getInstanceEx(this.myProject);
        AsyncResult<EditorWindow> window = mgr.getActiveWindow();
        window.doWhenDone((Consumer)new Consumer<EditorWindow>(){

            public void consume(EditorWindow wnd) {
                if (wnd != null && wnd.findFileComposite(file2) != null) {
                    mgr.closeFile(file2, wnd);
                }
            }
        });
    }

    private boolean isFloating() {
        return this.myWindow.getOwner().isFloating();
    }

    private static class MyShadowBorder
    implements Border {
        private final JBEditorTabs myTabs;

        public MyShadowBorder(JBEditorTabs tabs) {
            this.myTabs = tabs;
        }

        @Override
        public void paintBorder(Component component, Graphics g, int x, int y, int w, int h) {
            Rectangle selectedBounds = this.myTabs.getSelectedBounds();
            if (selectedBounds != null && selectedBounds.y > 0) {
                selectedBounds = null;
            }
            Rectangle bounds = new Rectangle(x, y, w, h);
            g.setColor(UIUtil.CONTRAST_BORDER_COLOR);
            MyShadowBorder.drawLine(bounds, selectedBounds, g, 0);
            if (!UIUtil.isUnderDarcula()) {
                // empty if block
            }
        }

        private static void drawLine(Rectangle bounds, @Nullable Rectangle selectedBounds, Graphics g, int yShift) {
            if (selectedBounds != null) {
                if (selectedBounds.x > 0) {
                    g.drawLine(bounds.x, bounds.y + yShift, selectedBounds.x - 2, bounds.y + yShift);
                }
                g.drawLine(selectedBounds.x + selectedBounds.width + 1, bounds.y + yShift, bounds.x + bounds.width, bounds.y + yShift);
            } else {
                g.drawLine(bounds.x, bounds.y + yShift, bounds.x + bounds.width, bounds.y + yShift);
            }
        }

        @Override
        public Insets getBorderInsets(Component component) {
            return new Insets(0, 0, 0, 0);
        }

        @Override
        public boolean isBorderOpaque() {
            return false;
        }
    }

    private final class MyTransferHandler
    extends TransferHandler {
        private final FileDropHandler myFileDropHandler = new FileDropHandler(null);

        private MyTransferHandler() {
        }

        @Override
        public boolean importData(JComponent comp, Transferable t) {
            if (this.myFileDropHandler.canHandleDrop(t.getTransferDataFlavors())) {
                this.myFileDropHandler.handleDrop(t, EditorTabbedContainer.this.myProject, EditorTabbedContainer.this.myWindow);
                return true;
            }
            return false;
        }

        @Override
        public boolean canImport(JComponent comp, DataFlavor[] transferFlavors) {
            return this.myFileDropHandler.canHandleDrop(transferFlavors);
        }
    }

    public static class DockableEditor
    implements DockableContent<VirtualFile> {
        final Image myImg;
        private DockableEditorTabbedContainer myContainer;
        private Presentation myPresentation;
        private Dimension myPreferredSize;
        private boolean myPinned;
        private VirtualFile myFile;

        public DockableEditor(Project project2, Image img, VirtualFile file2, Presentation presentation, Dimension preferredSize, boolean isFilePinned) {
            this.myImg = img;
            this.myFile = file2;
            this.myPresentation = presentation;
            this.myContainer = new DockableEditorTabbedContainer(project2);
            this.myPreferredSize = preferredSize;
            this.myPinned = isFilePinned;
        }

        @NotNull
        public VirtualFile getKey() {
            VirtualFile virtualFile = this.myFile;
            if (virtualFile == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/fileEditor/impl/EditorTabbedContainer$DockableEditor", "getKey"));
            }
            return virtualFile;
        }

        public Image getPreviewImage() {
            return this.myImg;
        }

        public Dimension getPreferredSize() {
            return this.myPreferredSize;
        }

        public String getDockContainerType() {
            return "file-editors";
        }

        public Presentation getPresentation() {
            return this.myPresentation;
        }

        public void close() {
            this.myContainer.close(this.myFile);
        }

        public VirtualFile getFile() {
            return this.myFile;
        }

        public boolean isPinned() {
            return this.myPinned;
        }
    }

    class MyDragOutDelegate
    implements TabInfo.DragOutDelegate {
        private VirtualFile myFile;
        private DragSession mySession;

        MyDragOutDelegate() {
        }

        public void dragOutStarted(MouseEvent mouseEvent, TabInfo info) {
            TabInfo previousSelection = info.getPreviousSelection();
            Image img = JBTabsImpl.getComponentImage((TabInfo)info);
            info.setHidden(true);
            if (previousSelection != null) {
                EditorTabbedContainer.this.myTabs.select(previousSelection, true);
            }
            this.myFile = (VirtualFile)info.getObject();
            Presentation presentation = new Presentation(info.getText());
            presentation.setIcon(info.getIcon());
            this.mySession = this.getDockManager().createDragSession(mouseEvent, (DockableContent)EditorTabbedContainer.createDockableEditor(EditorTabbedContainer.this.myProject, img, this.myFile, presentation, EditorTabbedContainer.this.myWindow));
        }

        private DockManager getDockManager() {
            return DockManager.getInstance((Project)EditorTabbedContainer.this.myProject);
        }

        public void processDragOut(MouseEvent event, TabInfo source) {
            this.mySession.process(event);
        }

        public void dragOutFinished(MouseEvent event, TabInfo source) {
            boolean copy;
            boolean bl = copy = UIUtil.isControlKeyDown((MouseEvent)event) || this.mySession.getResponse(event) == DockContainer.ContentResponse.ACCEPT_COPY;
            if (!copy) {
                this.myFile.putUserData(FileEditorManagerImpl.CLOSING_TO_REOPEN, (Object)Boolean.TRUE);
                FileEditorManagerEx.getInstanceEx(EditorTabbedContainer.this.myProject).closeFile(this.myFile, EditorTabbedContainer.this.myWindow);
            } else {
                source.setHidden(false);
            }
            this.mySession.process(event);
            if (!copy) {
                this.myFile.putUserData(FileEditorManagerImpl.CLOSING_TO_REOPEN, null);
            }
            this.myFile = null;
            this.mySession = null;
        }

        public void dragOutCancelled(TabInfo source) {
            source.setHidden(false);
            if (this.mySession != null) {
                this.mySession.cancel();
            }
            this.myFile = null;
            this.mySession = null;
        }
    }

    private class MySwitchProvider
    implements SwitchProvider {
        private MySwitchProvider() {
        }

        public List<SwitchTarget> getTargets(final boolean onlyVisible, boolean originalProvider) {
            final ArrayList<SwitchTarget> result = new ArrayList<SwitchTarget>();
            TabInfo selected = EditorTabbedContainer.this.myTabs.getSelectedInfo();
            new AwtVisitor(selected.getComponent()){

                public boolean visit(Component component) {
                    JBTabs tabs;
                    if (component instanceof JBTabs && (tabs = (JBTabs)component) != EditorTabbedContainer.this.myTabs) {
                        result.addAll(tabs.getTargets(onlyVisible, false));
                        return true;
                    }
                    return false;
                }
            };
            return result;
        }

        public SwitchTarget getCurrentTarget() {
            TabInfo selected = EditorTabbedContainer.this.myTabs.getSelectedInfo();
            final Ref targetRef = new Ref();
            new AwtVisitor(selected.getComponent()){

                public boolean visit(Component component) {
                    JBTabs tabs;
                    if (component instanceof JBTabs && (tabs = (JBTabs)component) != EditorTabbedContainer.this.myTabs) {
                        targetRef.set((Object)tabs.getCurrentTarget());
                        return true;
                    }
                    return false;
                }
            };
            return (SwitchTarget)targetRef.get();
        }

        public JComponent getComponent() {
            return null;
        }

        public boolean isCycleRoot() {
            return false;
        }
    }

    private class TabMouseListener
    extends MouseAdapter {
        private int myActionClickCount;

        private TabMouseListener() {
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            TabInfo info;
            if (UIUtil.isCloseClick((MouseEvent)e, (int)502) && (info = EditorTabbedContainer.this.myTabs.findInfo(e)) != null) {
                IdeEventQueue.getInstance().blockNextEvents(e);
                FileEditorManagerEx.getInstanceEx(EditorTabbedContainer.this.myProject).closeFile((VirtualFile)info.getObject(), EditorTabbedContainer.this.myWindow);
            }
        }

        @Override
        public void mousePressed(MouseEvent e) {
            if (UIUtil.isActionClick((MouseEvent)e)) {
                Component deepestComponent;
                if (e.getClickCount() == 1) {
                    this.myActionClickCount = 0;
                }
                if (!((deepestComponent = SwingUtilities.getDeepestComponentAt(e.getComponent(), e.getX(), e.getY())) instanceof InplaceButton)) {
                    ++this.myActionClickCount;
                }
                if (this.myActionClickCount > 1 && !EditorTabbedContainer.this.isFloating()) {
                    ActionManager mgr = ActionManager.getInstance();
                    mgr.tryToExecute(mgr.getAction("HideAllWindows"), (InputEvent)e, null, "unknown", true);
                }
            }
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            TabInfo info;
            if (UIUtil.isActionClick((MouseEvent)e, (int)500) && (e.isMetaDown() || !SystemInfo.isMac && e.isControlDown()) && (info = EditorTabbedContainer.this.myTabs.findInfo(e)) != null && info.getObject() != null) {
                VirtualFile vFile = (VirtualFile)info.getObject();
                ShowFilePathAction.show(vFile, e);
            }
        }
    }

    private class MyDataProvider
    implements DataProvider {
        private MyDataProvider() {
        }

        public Object getData(@NonNls String dataId) {
            TabInfo selected;
            if (CommonDataKeys.PROJECT.is(dataId)) {
                return EditorTabbedContainer.this.myProject;
            }
            if (CommonDataKeys.VIRTUAL_FILE.is(dataId)) {
                VirtualFile selectedFile = EditorTabbedContainer.this.myWindow.getSelectedFile();
                return selectedFile != null && selectedFile.isValid() ? selectedFile : null;
            }
            if (EditorWindow.DATA_KEY.is(dataId)) {
                return EditorTabbedContainer.this.myWindow;
            }
            if (PlatformDataKeys.HELP_ID.is(dataId)) {
                return EditorTabbedContainer.HELP_ID;
            }
            if (CloseAction.CloseTarget.KEY.is(dataId) && (selected = EditorTabbedContainer.this.myTabs.getSelectedInfo()) != null) {
                return EditorTabbedContainer.this;
            }
            if (EditorWindow.DATA_KEY.is(dataId)) {
                return EditorTabbedContainer.this.myWindow;
            }
            return null;
        }
    }

    private class CloseTab
    extends AnAction
    implements DumbAware {
        ShadowAction myShadow;
        private final TabInfo myTabInfo;

        public CloseTab(JComponent c, TabInfo info) {
            this.myTabInfo = info;
            this.myShadow = new ShadowAction((AnAction)this, ActionManager.getInstance().getAction("CloseContent"), c);
        }

        public void update(AnActionEvent e) {
            e.getPresentation().setIcon(AllIcons.Actions.Close);
            e.getPresentation().setHoveredIcon(AllIcons.Actions.CloseHovered);
            e.getPresentation().setVisible(UISettings.getInstance().SHOW_CLOSE_BUTTON);
            e.getPresentation().setText("Close. Alt-click to close others.");
        }

        public void actionPerformed(AnActionEvent e) {
            FileEditorManagerEx mgr = FileEditorManagerEx.getInstanceEx(EditorTabbedContainer.this.myProject);
            VirtualFile file2 = (VirtualFile)this.myTabInfo.getObject();
            EditorWindow window = "EditorTab".equals(e.getPlace()) ? EditorTabbedContainer.this.myWindow : mgr.getCurrentWindow();
            if (window != null) {
                if ((e.getModifiers() & 8) != 0) {
                    window.closeAllExcept(file2);
                } else if (window.findFileComposite(file2) != null) {
                    mgr.closeFile(file2, window);
                }
            }
        }
    }

    private static class MyQueryable
    implements Queryable {
        private final TabInfo myTab;

        public MyQueryable(TabInfo tab) {
            this.myTab = tab;
        }

        public void putInfo(@NotNull Map<String, String> info) {
            if (info == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "info", "com/intellij/openapi/fileEditor/impl/EditorTabbedContainer$MyQueryable", "putInfo"));
            }
            info.put("editorTab", this.myTab.getText());
        }
    }
}

