/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.fileChooser.actions;

import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.fileChooser.FileSystemTree;
import com.intellij.openapi.fileChooser.actions.FileChooserAction;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.vfs.VirtualFile;
import org.jetbrains.annotations.Nullable;

public final class GotoModuleDirectory
extends FileChooserAction {
    @Override
    protected void actionPerformed(final FileSystemTree fileSystemTree, AnActionEvent e) {
        final VirtualFile moduleDir = GotoModuleDirectory.getModuleDir(e);
        if (moduleDir != null) {
            fileSystemTree.select(moduleDir, new Runnable(){

                @Override
                public void run() {
                    fileSystemTree.expand(moduleDir, null);
                }
            });
        }
    }

    @Override
    protected void update(FileSystemTree fileSystemTree, AnActionEvent e) {
        Presentation presentation = e.getPresentation();
        VirtualFile moduleDir = GotoModuleDirectory.getModuleDir(e);
        presentation.setEnabled(moduleDir != null && fileSystemTree.isUnderRoots(moduleDir));
    }

    @Nullable
    private static VirtualFile getModuleDir(AnActionEvent e) {
        VirtualFile moduleDir;
        VirtualFile moduleFile;
        Module module2 = (Module)e.getData(LangDataKeys.MODULE_CONTEXT);
        if (module2 == null) {
            module2 = (Module)e.getData(LangDataKeys.MODULE);
        }
        if (module2 != null && !module2.isDisposed() && (moduleFile = module2.getModuleFile()) != null && moduleFile.isValid() && (moduleDir = moduleFile.getParent()) != null && moduleDir.isValid()) {
            return moduleDir;
        }
        return null;
    }
}

