/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.util;

import com.intellij.execution.ExecutionAdapter;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.ExecutionManager;
import com.intellij.execution.Executor;
import com.intellij.execution.ExecutorRegistry;
import com.intellij.execution.RunManager;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.RunnerRegistry;
import com.intellij.execution.configurations.ConfigurationType;
import com.intellij.execution.executors.DefaultDebugExecutor;
import com.intellij.execution.executors.DefaultRunExecutor;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.rmi.RemoteUtil;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.runners.ProgramRunner;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.ex.ApplicationEx;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.externalSystem.ExternalSystemManager;
import com.intellij.openapi.externalSystem.importing.ImportSpec;
import com.intellij.openapi.externalSystem.importing.ImportSpecBuilder;
import com.intellij.openapi.externalSystem.model.DataNode;
import com.intellij.openapi.externalSystem.model.ExternalProjectInfo;
import com.intellij.openapi.externalSystem.model.ExternalSystemException;
import com.intellij.openapi.externalSystem.model.Key;
import com.intellij.openapi.externalSystem.model.ProjectKeys;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.model.execution.ExternalSystemTaskExecutionSettings;
import com.intellij.openapi.externalSystem.model.project.ModuleData;
import com.intellij.openapi.externalSystem.model.project.ProjectData;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskNotificationListener;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskType;
import com.intellij.openapi.externalSystem.service.ImportCanceledException;
import com.intellij.openapi.externalSystem.service.execution.AbstractExternalSystemTaskConfigurationType;
import com.intellij.openapi.externalSystem.service.execution.ExternalSystemRunConfiguration;
import com.intellij.openapi.externalSystem.service.execution.ProgressExecutionMode;
import com.intellij.openapi.externalSystem.service.internal.ExternalSystemProcessingManager;
import com.intellij.openapi.externalSystem.service.internal.ExternalSystemResolveProjectTask;
import com.intellij.openapi.externalSystem.service.notification.ExternalSystemNotificationManager;
import com.intellij.openapi.externalSystem.service.notification.NotificationSource;
import com.intellij.openapi.externalSystem.service.project.ExternalProjectRefreshCallback;
import com.intellij.openapi.externalSystem.service.project.manage.ExternalProjectsManager;
import com.intellij.openapi.externalSystem.service.project.manage.ExternalSystemTaskActivator;
import com.intellij.openapi.externalSystem.service.project.manage.ProjectDataManager;
import com.intellij.openapi.externalSystem.service.settings.ExternalSystemConfigLocator;
import com.intellij.openapi.externalSystem.settings.AbstractExternalSystemLocalSettings;
import com.intellij.openapi.externalSystem.settings.AbstractExternalSystemSettings;
import com.intellij.openapi.externalSystem.settings.ExternalProjectSettings;
import com.intellij.openapi.externalSystem.task.TaskCallback;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.externalSystem.util.ExternalSystemBundle;
import com.intellij.openapi.externalSystem.view.ExternalProjectsView;
import com.intellij.openapi.externalSystem.view.ExternalProjectsViewImpl;
import com.intellij.openapi.progress.PerformInBackgroundOption;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.progress.util.AbstractProgressIndicatorExBase;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.StandardFileSystems;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowEP;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.openapi.wm.ex.ProgressIndicatorEx;
import com.intellij.openapi.wm.ex.ToolWindowManagerEx;
import com.intellij.openapi.wm.impl.ToolWindowImpl;
import com.intellij.util.Consumer;
import com.intellij.util.DisposeAwareRunnable;
import com.intellij.util.concurrency.Semaphore;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.ContainerUtilRt;
import com.intellij.util.ui.UIUtil;
import gnu.trove.TObjectHashingStrategy;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ExternalSystemUtil {
    private static final Logger LOG = Logger.getInstance((String)("#" + ExternalSystemUtil.class.getName()));
    @NotNull
    private static final Map<String, String> RUNNER_IDS = ContainerUtilRt.newHashMap();
    public static final TObjectHashingStrategy<Pair<ProjectSystemId, File>> HASHING_STRATEGY = new TObjectHashingStrategy<Pair<ProjectSystemId, File>>(){

        public int computeHashCode(Pair<ProjectSystemId, File> object) {
            return ((ProjectSystemId)object.first).hashCode() + ExternalSystemUtil.fileHashCode((File)object.second);
        }

        public boolean equals(Pair<ProjectSystemId, File> o1, Pair<ProjectSystemId, File> o2) {
            return ((ProjectSystemId)o1.first).equals(o2.first) && ExternalSystemUtil.filesEqual((File)o1.second, (File)o2.second);
        }
    };

    private ExternalSystemUtil() {
    }

    public static int fileHashCode(@Nullable File file2) {
        int hash;
        try {
            hash = FileUtil.pathHashCode((String)(file2 == null ? null : file2.getCanonicalPath()));
        }
        catch (IOException e) {
            LOG.warn("unable to get canonical file path", (Throwable)e);
            hash = FileUtil.fileHashCode((File)file2);
        }
        return hash;
    }

    public static boolean filesEqual(@Nullable File file1, @Nullable File file2) {
        try {
            return FileUtil.pathsEqual((String)(file1 == null ? null : file1.getCanonicalPath()), (String)(file2 == null ? null : file2.getCanonicalPath()));
        }
        catch (IOException e) {
            LOG.warn("unable to get canonical file path", (Throwable)e);
            return FileUtil.filesEqual((File)file1, (File)file2);
        }
    }

    public static void ensureToolWindowInitialized(@NotNull Project project2, @NotNull ProjectSystemId externalSystemId) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/externalSystem/util/ExternalSystemUtil", "ensureToolWindowInitialized"));
        }
        if (externalSystemId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "externalSystemId", "com/intellij/openapi/externalSystem/util/ExternalSystemUtil", "ensureToolWindowInitialized"));
        }
        try {
            ToolWindowEP[] beans;
            ToolWindowManager manager = ToolWindowManager.getInstance((Project)project2);
            if (!(manager instanceof ToolWindowManagerEx)) {
                return;
            }
            ToolWindowManagerEx managerEx = (ToolWindowManagerEx)manager;
            String id = externalSystemId.getReadableName();
            ToolWindow window = manager.getToolWindow(id);
            if (window != null) {
                return;
            }
            for (ToolWindowEP bean : beans = (ToolWindowEP[])Extensions.getExtensions((ExtensionPointName)ToolWindowEP.EP_NAME)) {
                if (!id.equals(bean.id)) continue;
                managerEx.initToolWindow(bean);
            }
        }
        catch (Exception e) {
            LOG.error(String.format("Unable to initialize %s tool window", externalSystemId.getReadableName()), (Throwable)e);
        }
    }

    @Nullable
    public static ToolWindow ensureToolWindowContentInitialized(@NotNull Project project2, @NotNull ProjectSystemId externalSystemId) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/externalSystem/util/ExternalSystemUtil", "ensureToolWindowContentInitialized"));
        }
        if (externalSystemId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "externalSystemId", "com/intellij/openapi/externalSystem/util/ExternalSystemUtil", "ensureToolWindowContentInitialized"));
        }
        ToolWindowManager toolWindowManager = ToolWindowManager.getInstance((Project)project2);
        if (toolWindowManager == null) {
            return null;
        }
        ToolWindow toolWindow = toolWindowManager.getToolWindow(externalSystemId.getReadableName());
        if (toolWindow == null) {
            return null;
        }
        if (toolWindow instanceof ToolWindowImpl) {
            ((ToolWindowImpl)toolWindow).ensureContentInitialized();
        }
        return toolWindow;
    }

    @Deprecated
    public static void refreshProjects(@NotNull Project project2, @NotNull ProjectSystemId externalSystemId, boolean force) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/externalSystem/util/ExternalSystemUtil", "refreshProjects"));
        }
        if (externalSystemId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "externalSystemId", "com/intellij/openapi/externalSystem/util/ExternalSystemUtil", "refreshProjects"));
        }
        ExternalSystemUtil.refreshProjects(project2, externalSystemId, force, ProgressExecutionMode.IN_BACKGROUND_ASYNC);
    }

    @Deprecated
    public static void refreshProjects(@NotNull Project project2, @NotNull ProjectSystemId externalSystemId, boolean force, @NotNull ProgressExecutionMode progressExecutionMode) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/externalSystem/util/ExternalSystemUtil", "refreshProjects"));
        }
        if (externalSystemId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "externalSystemId", "com/intellij/openapi/externalSystem/util/ExternalSystemUtil", "refreshProjects"));
        }
        if (progressExecutionMode == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "progressExecutionMode", "com/intellij/openapi/externalSystem/util/ExternalSystemUtil", "refreshProjects"));
        }
        ExternalSystemUtil.refreshProjects(new ImportSpecBuilder(project2, externalSystemId).forceWhenUptodate(force).use(progressExecutionMode));
    }

    public static void refreshProjects(@NotNull ImportSpecBuilder specBuilder) {
        if (specBuilder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "specBuilder", "com/intellij/openapi/externalSystem/util/ExternalSystemUtil", "refreshProjects"));
        }
        ImportSpec spec = specBuilder.build();
        ExternalSystemManager manager = ExternalSystemApiUtil.getManager((ProjectSystemId)spec.getExternalSystemId());
        if (manager == null) {
            return;
        }
        AbstractExternalSystemSettings settings = (AbstractExternalSystemSettings)manager.getSettingsProvider().fun((Object)spec.getProject());
        Collection projectsSettings = settings.getLinkedProjectsSettings();
        if (projectsSettings.isEmpty()) {
            return;
        }
        ProjectDataManager projectDataManager = (ProjectDataManager)ServiceManager.getService(ProjectDataManager.class);
        ExternalProjectRefreshCallback callback = spec.getCallback() == null ? new MyMultiExternalProjectRefreshCallback(spec.getProject(), projectDataManager, spec.getExternalSystemId()) : spec.getCallback();
        Map modificationStamps = ((AbstractExternalSystemLocalSettings)manager.getLocalSettingsProvider().fun((Object)spec.getProject())).getExternalConfigModificationStamps();
        HashSet toRefresh = ContainerUtilRt.newHashSet();
        for (ExternalProjectSettings setting : projectsSettings) {
            if (!setting.isUseAutoImport() && spec.isWhenAutoImportEnabled()) continue;
            if (spec.isForceWhenUptodate()) {
                toRefresh.add(setting.getExternalProjectPath());
                continue;
            }
            Long oldModificationStamp = (Long)modificationStamps.get(setting.getExternalProjectPath());
            long currentModificationStamp = ExternalSystemUtil.getTimeStamp(setting, spec.getExternalSystemId());
            if (oldModificationStamp != null && oldModificationStamp >= currentModificationStamp) continue;
            toRefresh.add(setting.getExternalProjectPath());
        }
        if (!toRefresh.isEmpty()) {
            ExternalSystemNotificationManager.getInstance(spec.getProject()).clearNotifications(null, NotificationSource.PROJECT_SYNC, spec.getExternalSystemId());
            for (String path : toRefresh) {
                ExternalSystemUtil.refreshProject(spec.getProject(), spec.getExternalSystemId(), path, callback, false, spec.getProgressExecutionMode());
            }
        }
    }

    private static long getTimeStamp(@NotNull ExternalProjectSettings externalProjectSettings, @NotNull ProjectSystemId externalSystemId) {
        if (externalProjectSettings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "externalProjectSettings", "com/intellij/openapi/externalSystem/util/ExternalSystemUtil", "getTimeStamp"));
        }
        if (externalSystemId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "externalSystemId", "com/intellij/openapi/externalSystem/util/ExternalSystemUtil", "getTimeStamp"));
        }
        long timeStamp = 0L;
        for (ExternalSystemConfigLocator locator : (ExternalSystemConfigLocator[])ExternalSystemConfigLocator.EP_NAME.getExtensions()) {
            if (!externalSystemId.equals((Object)locator.getTargetExternalSystemId())) continue;
            for (VirtualFile virtualFile : locator.findAll(externalProjectSettings)) {
                timeStamp += virtualFile.getTimeStamp();
            }
        }
        return timeStamp;
    }

    @Nullable
    private static String extractDetails(@NotNull Throwable e) {
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/openapi/externalSystem/util/ExternalSystemUtil", "extractDetails"));
        }
        Throwable unwrapped = RemoteUtil.unwrap((Throwable)e);
        if (unwrapped instanceof ExternalSystemException) {
            return ((ExternalSystemException)unwrapped).getOriginalReason();
        }
        return null;
    }

    public static void refreshProject(final @NotNull Project project2, @NotNull ProjectSystemId externalSystemId, @NotNull String externalProjectPath, boolean isPreviewMode, final @NotNull ProgressExecutionMode progressExecutionMode) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/externalSystem/util/ExternalSystemUtil", "refreshProject"));
        }
        if (externalSystemId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "externalSystemId", "com/intellij/openapi/externalSystem/util/ExternalSystemUtil", "refreshProject"));
        }
        if (externalProjectPath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "externalProjectPath", "com/intellij/openapi/externalSystem/util/ExternalSystemUtil", "refreshProject"));
        }
        if (progressExecutionMode == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "progressExecutionMode", "com/intellij/openapi/externalSystem/util/ExternalSystemUtil", "refreshProject"));
        }
        ExternalSystemUtil.refreshProject(project2, externalSystemId, externalProjectPath, new ExternalProjectRefreshCallback(){

            @Override
            public void onSuccess(@Nullable DataNode<ProjectData> externalProject) {
                if (externalProject == null) {
                    return;
                }
                boolean synchronous = progressExecutionMode == ProgressExecutionMode.MODAL_SYNC;
                ((ProjectDataManager)ServiceManager.getService(ProjectDataManager.class)).importData(externalProject, project2, synchronous);
            }

            @Override
            public void onFailure(@NotNull String errorMessage, @Nullable String errorDetails) {
                if (errorMessage == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "errorMessage", "com/intellij/openapi/externalSystem/util/ExternalSystemUtil$2", "onFailure"));
                }
            }
        }, isPreviewMode, progressExecutionMode, true);
    }

    public static void refreshProject(@NotNull Project project2, @NotNull ProjectSystemId externalSystemId, @NotNull String externalProjectPath, @NotNull ExternalProjectRefreshCallback callback, boolean isPreviewMode, @NotNull ProgressExecutionMode progressExecutionMode) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/externalSystem/util/ExternalSystemUtil", "refreshProject"));
        }
        if (externalSystemId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "externalSystemId", "com/intellij/openapi/externalSystem/util/ExternalSystemUtil", "refreshProject"));
        }
        if (externalProjectPath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "externalProjectPath", "com/intellij/openapi/externalSystem/util/ExternalSystemUtil", "refreshProject"));
        }
        if (callback == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callback", "com/intellij/openapi/externalSystem/util/ExternalSystemUtil", "refreshProject"));
        }
        if (progressExecutionMode == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "progressExecutionMode", "com/intellij/openapi/externalSystem/util/ExternalSystemUtil", "refreshProject"));
        }
        ExternalSystemUtil.refreshProject(project2, externalSystemId, externalProjectPath, callback, isPreviewMode, progressExecutionMode, true);
    }

    public static void refreshProject(final @NotNull Project project2, final @NotNull ProjectSystemId externalSystemId, final @NotNull String externalProjectPath, final @NotNull ExternalProjectRefreshCallback callback, final boolean isPreviewMode, final @NotNull ProgressExecutionMode progressExecutionMode, final boolean reportRefreshError) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/externalSystem/util/ExternalSystemUtil", "refreshProject"));
        }
        if (externalSystemId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "externalSystemId", "com/intellij/openapi/externalSystem/util/ExternalSystemUtil", "refreshProject"));
        }
        if (externalProjectPath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "externalProjectPath", "com/intellij/openapi/externalSystem/util/ExternalSystemUtil", "refreshProject"));
        }
        if (callback == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callback", "com/intellij/openapi/externalSystem/util/ExternalSystemUtil", "refreshProject"));
        }
        if (progressExecutionMode == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "progressExecutionMode", "com/intellij/openapi/externalSystem/util/ExternalSystemUtil", "refreshProject"));
        }
        File projectFile = new File(externalProjectPath);
        final String projectName = projectFile.isFile() ? projectFile.getParentFile().getName() : projectFile.getName();
        final TaskUnderProgress refreshProjectStructureTask = new TaskUnderProgress(){
            private final ExternalSystemResolveProjectTask myTask;
            {
                this.myTask = new ExternalSystemResolveProjectTask(externalSystemId, project2, externalProjectPath, isPreviewMode);
            }

            @Override
            public void execute(@NotNull ProgressIndicator indicator) {
                ExternalSystemProcessingManager processingManager;
                if (indicator == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/openapi/externalSystem/util/ExternalSystemUtil$3", "execute"));
                }
                if (project2.isDisposed()) {
                    return;
                }
                if (indicator instanceof ProgressIndicatorEx) {
                    ((ProgressIndicatorEx)indicator).addStateDelegate(new AbstractProgressIndicatorExBase(){

                        @Override
                        public void cancel() {
                            super.cancel();
                            ApplicationManager.getApplication().executeOnPooledThread(new Runnable(){

                                @Override
                                public void run() {
                                    myTask.cancel((ExternalSystemTaskNotificationListener[])ExternalSystemTaskNotificationListener.EP_NAME.getExtensions());
                                }
                            });
                        }
                    });
                }
                if ((processingManager = (ExternalSystemProcessingManager)ServiceManager.getService(ExternalSystemProcessingManager.class)).findTask(ExternalSystemTaskType.RESOLVE_PROJECT, externalSystemId, externalProjectPath) != null) {
                    callback.onFailure(ExternalSystemBundle.message((String)"error.resolve.already.running", (Object[])new Object[]{externalProjectPath}), null);
                    return;
                }
                if (!(callback instanceof MyMultiExternalProjectRefreshCallback)) {
                    ExternalSystemNotificationManager.getInstance(project2).clearNotifications(null, NotificationSource.PROJECT_SYNC, externalSystemId);
                }
                ExternalSystemTaskActivator externalSystemTaskActivator = ExternalProjectsManager.getInstance(project2).getTaskActivator();
                if (!isPreviewMode && !externalSystemTaskActivator.runTasks(externalProjectPath, ExternalSystemTaskActivator.Phase.BEFORE_SYNC)) {
                    return;
                }
                this.myTask.execute(indicator, (ExternalSystemTaskNotificationListener[])ExternalSystemTaskNotificationListener.EP_NAME.getExtensions());
                if (project2.isDisposed()) {
                    return;
                }
                Throwable error = this.myTask.getError();
                if (error == null) {
                    ExternalSystemManager manager = ExternalSystemApiUtil.getManager((ProjectSystemId)externalSystemId);
                    assert (manager != null);
                    DataNode<ProjectData> externalProject = this.myTask.getExternalProject();
                    if (externalProject != null) {
                        HashSet externalModulePaths = ContainerUtil.newHashSet();
                        Collection moduleNodes = ExternalSystemApiUtil.findAll(externalProject, (Key)ProjectKeys.MODULE);
                        for (DataNode node : moduleNodes) {
                            externalModulePaths.add(((ModuleData)node.getData()).getLinkedExternalProjectPath());
                        }
                        String projectPath = ((ProjectData)externalProject.getData()).getLinkedExternalProjectPath();
                        ExternalProjectSettings linkedProjectSettings = ((AbstractExternalSystemSettings)manager.getSettingsProvider().fun((Object)project2)).getLinkedProjectSettings(projectPath);
                        if (linkedProjectSettings != null) {
                            linkedProjectSettings.setModules((Set)externalModulePaths);
                            long stamp = ExternalSystemUtil.getTimeStamp(linkedProjectSettings, externalSystemId);
                            if (stamp > 0L) {
                                ((AbstractExternalSystemLocalSettings)manager.getLocalSettingsProvider().fun((Object)project2)).getExternalConfigModificationStamps().put(externalProjectPath, stamp);
                            }
                        }
                    }
                    callback.onSuccess(externalProject);
                    if (!isPreviewMode) {
                        externalSystemTaskActivator.runTasks(externalProjectPath, ExternalSystemTaskActivator.Phase.AFTER_SYNC);
                    }
                    return;
                }
                if (error instanceof ImportCanceledException) {
                    return;
                }
                String message = ExternalSystemApiUtil.buildErrorMessage((Throwable)error);
                if (StringUtil.isEmpty((String)message)) {
                    message = String.format("Can't resolve %s project at '%s'. Reason: %s", externalSystemId.getReadableName(), externalProjectPath, message);
                }
                callback.onFailure(message, ExternalSystemUtil.extractDetails(error));
                ExternalSystemManager manager = ExternalSystemApiUtil.getManager((ProjectSystemId)externalSystemId);
                if (manager == null) {
                    return;
                }
                AbstractExternalSystemSettings settings = (AbstractExternalSystemSettings)manager.getSettingsProvider().fun((Object)project2);
                ExternalProjectSettings projectSettings = settings.getLinkedProjectSettings(externalProjectPath);
                if (projectSettings == null || !reportRefreshError) {
                    return;
                }
                ExternalSystemNotificationManager.getInstance(project2).processExternalProjectRefreshError(error, projectName, externalSystemId);
            }
        };
        ExternalSystemApiUtil.executeOnEdt((boolean)true, (Runnable)new Runnable(){

            @Override
            public void run() {
                switch (progressExecutionMode) {
                    case MODAL_SYNC: {
                        String title = ExternalSystemBundle.message((String)"progress.import.text", (Object[])new Object[]{projectName, externalSystemId.getReadableName()});
                        new Task.Modal(project2, title, true){

                            public void run(@NotNull ProgressIndicator indicator) {
                                if (indicator == null) {
                                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/openapi/externalSystem/util/ExternalSystemUtil$4$1", "run"));
                                }
                                refreshProjectStructureTask.execute(indicator);
                            }
                        }.queue();
                        break;
                    }
                    case IN_BACKGROUND_ASYNC: {
                        String title = ExternalSystemBundle.message((String)"progress.refresh.text", (Object[])new Object[]{projectName, externalSystemId.getReadableName()});
                        new Task.Backgroundable(project2, title){

                            public void run(@NotNull ProgressIndicator indicator) {
                                if (indicator == null) {
                                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/openapi/externalSystem/util/ExternalSystemUtil$4$2", "run"));
                                }
                                refreshProjectStructureTask.execute(indicator);
                            }
                        }.queue();
                        break;
                    }
                    case START_IN_FOREGROUND_ASYNC: {
                        String title = ExternalSystemBundle.message((String)"progress.refresh.text", (Object[])new Object[]{projectName, externalSystemId.getReadableName()});
                        new Task.Backgroundable(project2, title, true, PerformInBackgroundOption.DEAF){

                            public void run(@NotNull ProgressIndicator indicator) {
                                if (indicator == null) {
                                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/openapi/externalSystem/util/ExternalSystemUtil$4$3", "run"));
                                }
                                refreshProjectStructureTask.execute(indicator);
                            }
                        }.queue();
                    }
                }
            }
        });
    }

    public static void runTask(@NotNull ExternalSystemTaskExecutionSettings taskSettings, @NotNull String executorId, @NotNull Project project2, @NotNull ProjectSystemId externalSystemId) {
        if (taskSettings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "taskSettings", "com/intellij/openapi/externalSystem/util/ExternalSystemUtil", "runTask"));
        }
        if (executorId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "executorId", "com/intellij/openapi/externalSystem/util/ExternalSystemUtil", "runTask"));
        }
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/externalSystem/util/ExternalSystemUtil", "runTask"));
        }
        if (externalSystemId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "externalSystemId", "com/intellij/openapi/externalSystem/util/ExternalSystemUtil", "runTask"));
        }
        ExternalSystemUtil.runTask(taskSettings, executorId, project2, externalSystemId, null, ProgressExecutionMode.IN_BACKGROUND_ASYNC);
    }

    public static void runTask(final @NotNull ExternalSystemTaskExecutionSettings taskSettings, final @NotNull String executorId, final @NotNull Project project2, @NotNull ProjectSystemId externalSystemId, final @Nullable TaskCallback callback, final @NotNull ProgressExecutionMode progressExecutionMode) {
        if (taskSettings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "taskSettings", "com/intellij/openapi/externalSystem/util/ExternalSystemUtil", "runTask"));
        }
        if (executorId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "executorId", "com/intellij/openapi/externalSystem/util/ExternalSystemUtil", "runTask"));
        }
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/externalSystem/util/ExternalSystemUtil", "runTask"));
        }
        if (externalSystemId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "externalSystemId", "com/intellij/openapi/externalSystem/util/ExternalSystemUtil", "runTask"));
        }
        if (progressExecutionMode == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "progressExecutionMode", "com/intellij/openapi/externalSystem/util/ExternalSystemUtil", "runTask"));
        }
        Pair<ProgramRunner, ExecutionEnvironment> pair = ExternalSystemUtil.createRunner(taskSettings, executorId, project2, externalSystemId);
        if (pair == null) {
            return;
        }
        final ProgramRunner runner = (ProgramRunner)pair.first;
        final ExecutionEnvironment environment = (ExecutionEnvironment)pair.second;
        final TaskUnderProgress task = new TaskUnderProgress(){

            @Override
            public void execute(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/openapi/externalSystem/util/ExternalSystemUtil$5", "execute"));
                }
                final Semaphore targetDone = new Semaphore();
                final Ref result = new Ref((Object)false);
                Disposable disposable = Disposer.newDisposable();
                project2.getMessageBus().connect(disposable).subscribe(ExecutionManager.EXECUTION_TOPIC, (Object)new ExecutionAdapter(){

                    public void processStartScheduled(String executorIdLocal, ExecutionEnvironment environmentLocal) {
                        if (executorId.equals(executorIdLocal) && environment.equals(environmentLocal)) {
                            targetDone.down();
                        }
                    }

                    public void processNotStarted(String executorIdLocal, @NotNull ExecutionEnvironment environmentLocal) {
                        if (environmentLocal == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "environmentLocal", "com/intellij/openapi/externalSystem/util/ExternalSystemUtil$5$1", "processNotStarted"));
                        }
                        if (executorId.equals(executorIdLocal) && environment.equals(environmentLocal)) {
                            targetDone.up();
                        }
                    }

                    public void processStarted(String executorIdLocal, @NotNull ExecutionEnvironment environmentLocal, @NotNull ProcessHandler handler2) {
                        if (environmentLocal == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "environmentLocal", "com/intellij/openapi/externalSystem/util/ExternalSystemUtil$5$1", "processStarted"));
                        }
                        if (handler2 == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "handler", "com/intellij/openapi/externalSystem/util/ExternalSystemUtil$5$1", "processStarted"));
                        }
                        if (executorId.equals(executorIdLocal) && environment.equals(environmentLocal)) {
                            handler2.addProcessListener((ProcessListener)new ProcessAdapter(){

                                public void processTerminated(ProcessEvent event) {
                                    result.set((Object)(event.getExitCode() == 0 ? 1 : 0));
                                    targetDone.up();
                                }
                            });
                        }
                    }
                });
                try {
                    ApplicationManager.getApplication().invokeAndWait(new Runnable(){

                        @Override
                        public void run() {
                            try {
                                runner.execute(environment);
                            }
                            catch (ExecutionException e) {
                                targetDone.up();
                                LOG.error((Throwable)e);
                            }
                        }
                    }, ModalityState.NON_MODAL);
                }
                catch (Exception e) {
                    LOG.error((Throwable)e);
                    Disposer.dispose((Disposable)disposable);
                    return;
                }
                targetDone.waitFor();
                Disposer.dispose((Disposable)disposable);
                if (callback != null) {
                    if (((Boolean)result.get()).booleanValue()) {
                        callback.onSuccess();
                    } else {
                        callback.onFailure();
                    }
                }
            }
        };
        UIUtil.invokeAndWaitIfNeeded((Runnable)new Runnable(){

            @Override
            public void run() {
                String title = AbstractExternalSystemTaskConfigurationType.generateName(project2, taskSettings);
                switch (progressExecutionMode) {
                    case MODAL_SYNC: {
                        new Task.Modal(project2, title, true){

                            public void run(@NotNull ProgressIndicator indicator) {
                                if (indicator == null) {
                                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/openapi/externalSystem/util/ExternalSystemUtil$6$1", "run"));
                                }
                                task.execute(indicator);
                            }
                        }.queue();
                        break;
                    }
                    case IN_BACKGROUND_ASYNC: {
                        new Task.Backgroundable(project2, title){

                            public void run(@NotNull ProgressIndicator indicator) {
                                if (indicator == null) {
                                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/openapi/externalSystem/util/ExternalSystemUtil$6$2", "run"));
                                }
                                task.execute(indicator);
                            }
                        }.queue();
                        break;
                    }
                    case START_IN_FOREGROUND_ASYNC: {
                        new Task.Backgroundable(project2, title, true, PerformInBackgroundOption.DEAF){

                            public void run(@NotNull ProgressIndicator indicator) {
                                if (indicator == null) {
                                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/openapi/externalSystem/util/ExternalSystemUtil$6$3", "run"));
                                }
                                task.execute(indicator);
                            }
                        }.queue();
                    }
                }
            }
        });
    }

    @Nullable
    public static Pair<ProgramRunner, ExecutionEnvironment> createRunner(@NotNull ExternalSystemTaskExecutionSettings taskSettings, @NotNull String executorId, @NotNull Project project2, @NotNull ProjectSystemId externalSystemId) {
        if (taskSettings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "taskSettings", "com/intellij/openapi/externalSystem/util/ExternalSystemUtil", "createRunner"));
        }
        if (executorId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "executorId", "com/intellij/openapi/externalSystem/util/ExternalSystemUtil", "createRunner"));
        }
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/externalSystem/util/ExternalSystemUtil", "createRunner"));
        }
        if (externalSystemId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "externalSystemId", "com/intellij/openapi/externalSystem/util/ExternalSystemUtil", "createRunner"));
        }
        Executor executor = ExecutorRegistry.getInstance().getExecutorById(executorId);
        if (executor == null) {
            return null;
        }
        String runnerId = ExternalSystemUtil.getRunnerId(executorId);
        if (runnerId == null) {
            return null;
        }
        ProgramRunner runner = RunnerRegistry.getInstance().findRunnerById(runnerId);
        if (runner == null) {
            return null;
        }
        RunnerAndConfigurationSettings settings = ExternalSystemUtil.createExternalSystemRunnerAndConfigurationSettings(taskSettings, project2, externalSystemId);
        if (settings == null) {
            return null;
        }
        return Pair.create((Object)runner, (Object)new ExecutionEnvironment(executor, runner, settings, project2));
    }

    @Nullable
    public static RunnerAndConfigurationSettings createExternalSystemRunnerAndConfigurationSettings(@NotNull ExternalSystemTaskExecutionSettings taskSettings, @NotNull Project project2, @NotNull ProjectSystemId externalSystemId) {
        if (taskSettings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "taskSettings", "com/intellij/openapi/externalSystem/util/ExternalSystemUtil", "createExternalSystemRunnerAndConfigurationSettings"));
        }
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/externalSystem/util/ExternalSystemUtil", "createExternalSystemRunnerAndConfigurationSettings"));
        }
        if (externalSystemId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "externalSystemId", "com/intellij/openapi/externalSystem/util/ExternalSystemUtil", "createExternalSystemRunnerAndConfigurationSettings"));
        }
        AbstractExternalSystemTaskConfigurationType configurationType = ExternalSystemUtil.findConfigurationType(externalSystemId);
        if (configurationType == null) {
            return null;
        }
        String name = AbstractExternalSystemTaskConfigurationType.generateName(project2, taskSettings);
        RunnerAndConfigurationSettings settings = RunManager.getInstance((Project)project2).createRunConfiguration(name, configurationType.getFactory());
        ExternalSystemRunConfiguration runConfiguration = (ExternalSystemRunConfiguration)settings.getConfiguration();
        runConfiguration.getSettings().setExternalProjectPath(taskSettings.getExternalProjectPath());
        runConfiguration.getSettings().setTaskNames((List)ContainerUtil.newArrayList((Iterable)taskSettings.getTaskNames()));
        runConfiguration.getSettings().setTaskDescriptions((List)ContainerUtil.newArrayList((Iterable)taskSettings.getTaskDescriptions()));
        runConfiguration.getSettings().setVmOptions(taskSettings.getVmOptions());
        runConfiguration.getSettings().setScriptParameters(taskSettings.getScriptParameters());
        runConfiguration.getSettings().setExecutionName(taskSettings.getExecutionName());
        return settings;
    }

    @Nullable
    public static AbstractExternalSystemTaskConfigurationType findConfigurationType(@NotNull ProjectSystemId externalSystemId) {
        if (externalSystemId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "externalSystemId", "com/intellij/openapi/externalSystem/util/ExternalSystemUtil", "findConfigurationType"));
        }
        for (ConfigurationType type : (ConfigurationType[])Extensions.getExtensions((ExtensionPointName)ConfigurationType.CONFIGURATION_TYPE_EP)) {
            AbstractExternalSystemTaskConfigurationType candidate;
            if (!(type instanceof AbstractExternalSystemTaskConfigurationType) || !externalSystemId.equals((Object)(candidate = (AbstractExternalSystemTaskConfigurationType)type).getExternalSystemId())) continue;
            return candidate;
        }
        return null;
    }

    @Nullable
    public static String getRunnerId(@NotNull String executorId) {
        if (executorId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "executorId", "com/intellij/openapi/externalSystem/util/ExternalSystemUtil", "getRunnerId"));
        }
        return RUNNER_IDS.get(executorId);
    }

    public static void linkExternalProject(final @NotNull ProjectSystemId externalSystemId, final @NotNull ExternalProjectSettings projectSettings, final @NotNull Project project2, final @Nullable Consumer<Boolean> executionResultCallback, boolean isPreviewMode, @NotNull ProgressExecutionMode progressExecutionMode) {
        if (externalSystemId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "externalSystemId", "com/intellij/openapi/externalSystem/util/ExternalSystemUtil", "linkExternalProject"));
        }
        if (projectSettings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "projectSettings", "com/intellij/openapi/externalSystem/util/ExternalSystemUtil", "linkExternalProject"));
        }
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/externalSystem/util/ExternalSystemUtil", "linkExternalProject"));
        }
        if (progressExecutionMode == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "progressExecutionMode", "com/intellij/openapi/externalSystem/util/ExternalSystemUtil", "linkExternalProject"));
        }
        ExternalProjectRefreshCallback callback = new ExternalProjectRefreshCallback(){

            @Override
            public void onSuccess(@Nullable DataNode<ProjectData> externalProject) {
                if (externalProject == null) {
                    if (executionResultCallback != null) {
                        executionResultCallback.consume((Object)false);
                    }
                    return;
                }
                AbstractExternalSystemSettings systemSettings = ExternalSystemApiUtil.getSettings((Project)project2, (ProjectSystemId)externalSystemId);
                HashSet projects = ContainerUtilRt.newHashSet((Iterable)systemSettings.getLinkedProjectsSettings());
                projects.add(projectSettings);
                systemSettings.setLinkedProjectsSettings((Collection)projects);
                ExternalSystemUtil.ensureToolWindowInitialized(project2, externalSystemId);
                ((ProjectDataManager)ServiceManager.getService(ProjectDataManager.class)).importData(externalProject, project2, true);
                if (executionResultCallback != null) {
                    executionResultCallback.consume((Object)true);
                }
            }

            @Override
            public void onFailure(@NotNull String errorMessage, @Nullable String errorDetails) {
                if (errorMessage == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "errorMessage", "com/intellij/openapi/externalSystem/util/ExternalSystemUtil$7", "onFailure"));
                }
                if (executionResultCallback != null) {
                    executionResultCallback.consume((Object)false);
                }
            }
        };
        ExternalSystemUtil.refreshProject(project2, externalSystemId, projectSettings.getExternalProjectPath(), callback, isPreviewMode, progressExecutionMode);
    }

    @Nullable
    public static VirtualFile refreshAndFindFileByIoFile(@NotNull File file2) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/externalSystem/util/ExternalSystemUtil", "refreshAndFindFileByIoFile"));
        }
        Application app = ApplicationManager.getApplication();
        if (app.isDispatchThread()) {
            return LocalFileSystem.getInstance().refreshAndFindFileByIoFile(file2);
        }
        assert (!((ApplicationEx)app).holdsReadLock());
        return LocalFileSystem.getInstance().refreshAndFindFileByIoFile(file2);
    }

    @Nullable
    public static VirtualFile findLocalFileByPath(String path) {
        VirtualFile result = StandardFileSystems.local().findFileByPath(path);
        if (result != null) {
            return result;
        }
        return !ApplicationManager.getApplication().isReadAccessAllowed() ? ExternalSystemUtil.findLocalFileByPathUnderWriteAction(path) : ExternalSystemUtil.findLocalFileByPathUnderReadAction(path);
    }

    @Nullable
    private static VirtualFile findLocalFileByPathUnderWriteAction(final String path) {
        return (VirtualFile)ExternalSystemApiUtil.doWriteAction((Computable)new Computable<VirtualFile>(){

            public VirtualFile compute() {
                return StandardFileSystems.local().refreshAndFindFileByPath(path);
            }
        });
    }

    @Nullable
    private static VirtualFile findLocalFileByPathUnderReadAction(final String path) {
        return (VirtualFile)ApplicationManager.getApplication().runReadAction((Computable)new Computable<VirtualFile>(){

            public VirtualFile compute() {
                return StandardFileSystems.local().findFileByPath(path);
            }
        });
    }

    public static void scheduleExternalViewStructureUpdate(@NotNull Project project2, @NotNull ProjectSystemId systemId) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/externalSystem/util/ExternalSystemUtil", "scheduleExternalViewStructureUpdate"));
        }
        if (systemId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "systemId", "com/intellij/openapi/externalSystem/util/ExternalSystemUtil", "scheduleExternalViewStructureUpdate"));
        }
        ExternalProjectsView externalProjectsView = ExternalProjectsManager.getInstance(project2).getExternalProjectsView(systemId);
        if (externalProjectsView instanceof ExternalProjectsViewImpl) {
            ((ExternalProjectsViewImpl)externalProjectsView).scheduleStructureUpdate();
        }
    }

    @Nullable
    public static ExternalProjectInfo getExternalProjectInfo(@NotNull Project project2, @NotNull ProjectSystemId projectSystemId, @NotNull String externalProjectPath) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/externalSystem/util/ExternalSystemUtil", "getExternalProjectInfo"));
        }
        if (projectSystemId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "projectSystemId", "com/intellij/openapi/externalSystem/util/ExternalSystemUtil", "getExternalProjectInfo"));
        }
        if (externalProjectPath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "externalProjectPath", "com/intellij/openapi/externalSystem/util/ExternalSystemUtil", "getExternalProjectInfo"));
        }
        ExternalProjectSettings linkedProjectSettings = ExternalSystemApiUtil.getSettings((Project)project2, (ProjectSystemId)projectSystemId).getLinkedProjectSettings(externalProjectPath);
        if (linkedProjectSettings == null) {
            return null;
        }
        return ProjectDataManager.getInstance().getExternalProjectData(project2, projectSystemId, linkedProjectSettings.getExternalProjectPath());
    }

    public static void invokeLater(Project p, Runnable r) {
        ExternalSystemUtil.invokeLater(p, ModalityState.defaultModalityState(), r);
    }

    public static void invokeLater(Project p, ModalityState state, Runnable r) {
        if (ExternalSystemUtil.isNoBackgroundMode()) {
            r.run();
        } else {
            ApplicationManager.getApplication().invokeLater(DisposeAwareRunnable.create((Runnable)r, (Project)p), state);
        }
    }

    public static boolean isNoBackgroundMode() {
        return ApplicationManager.getApplication().isUnitTestMode() || ApplicationManager.getApplication().isHeadlessEnvironment();
    }

    static {
        RUNNER_IDS.put(DefaultRunExecutor.EXECUTOR_ID, "ExternalSystemTaskRunner");
        RUNNER_IDS.put(DefaultDebugExecutor.EXECUTOR_ID, "ExternalSystemTaskDebugRunner");
    }

    private static class MyMultiExternalProjectRefreshCallback
    implements ExternalProjectRefreshCallback {
        @NotNull
        private final Set<String> myExternalModulePaths;
        private final Project myProject;
        private final ProjectDataManager myProjectDataManager;
        private final ProjectSystemId myExternalSystemId;

        public MyMultiExternalProjectRefreshCallback(Project project2, ProjectDataManager projectDataManager, ProjectSystemId externalSystemId) {
            this.myProject = project2;
            this.myProjectDataManager = projectDataManager;
            this.myExternalSystemId = externalSystemId;
            this.myExternalModulePaths = ContainerUtilRt.newHashSet();
        }

        @Override
        public void onSuccess(@Nullable DataNode<ProjectData> externalProject) {
            if (externalProject == null) {
                return;
            }
            Collection moduleNodes = ExternalSystemApiUtil.findAllRecursively(externalProject, (Key)ProjectKeys.MODULE);
            for (DataNode node : moduleNodes) {
                this.myExternalModulePaths.add(((ModuleData)node.getData()).getLinkedExternalProjectPath());
            }
            this.myProjectDataManager.importData(externalProject, this.myProject, true);
        }

        @Override
        public void onFailure(@NotNull String errorMessage, @Nullable String errorDetails) {
            if (errorMessage == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "errorMessage", "com/intellij/openapi/externalSystem/util/ExternalSystemUtil$MyMultiExternalProjectRefreshCallback", "onFailure"));
            }
        }
    }

    private static interface TaskUnderProgress {
        public void execute(@NotNull ProgressIndicator var1);
    }
}

