/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.service.project;

import com.intellij.facet.Facet;
import com.intellij.facet.FacetModel;
import com.intellij.facet.FacetTypeId;
import com.intellij.facet.ModifiableFacetModel;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.externalSystem.model.project.LibraryData;
import com.intellij.openapi.externalSystem.service.project.ArtifactExternalDependenciesImporter;
import com.intellij.openapi.externalSystem.service.project.ArtifactExternalDependenciesImporterImpl;
import com.intellij.openapi.externalSystem.service.project.IdeModelsProviderImpl;
import com.intellij.openapi.externalSystem.service.project.IdeModifiableModelsProvider;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.module.ModifiableModuleModel;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleWithNameAlreadyExists;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.ModuleRootModel;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.roots.TestModuleProperties;
import com.intellij.openapi.roots.ex.ProjectRootManagerEx;
import com.intellij.openapi.roots.impl.ModifiableModelCommitter;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.libraries.LibraryTable;
import com.intellij.openapi.roots.libraries.LibraryTablesRegistrar;
import com.intellij.openapi.roots.ui.configuration.FacetsProvider;
import com.intellij.openapi.roots.ui.configuration.ModulesProvider;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.packaging.artifacts.ArtifactModel;
import com.intellij.packaging.artifacts.ModifiableArtifactModel;
import com.intellij.packaging.elements.ManifestFileProvider;
import com.intellij.packaging.elements.PackagingElementResolvingContext;
import com.intellij.packaging.impl.artifacts.DefaultManifestFileProvider;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.graph.CachingSemiGraph;
import com.intellij.util.graph.Graph;
import com.intellij.util.graph.GraphGenerator;
import gnu.trove.THashMap;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractIdeModifiableModelsProvider
extends IdeModelsProviderImpl
implements IdeModifiableModelsProvider {
    private static final Logger LOG = Logger.getInstance(AbstractIdeModifiableModelsProvider.class);
    private ModifiableModuleModel myModifiableModuleModel;
    private Map<Module, ModifiableRootModel> myModifiableRootModels;
    private Map<Module, ModifiableFacetModel> myModifiableFacetModels;
    private Map<Module, String> myProductionModulesForTestModules;
    private Map<Library, Library.ModifiableModel> myModifiableLibraryModels;
    private ModifiableArtifactModel myModifiableArtifactModel;
    private MyPackagingElementResolvingContext myPackagingElementResolvingContext;
    private final ArtifactExternalDependenciesImporter myArtifactExternalDependenciesImporter;

    public AbstractIdeModifiableModelsProvider(@NotNull Project project2) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/externalSystem/service/project/AbstractIdeModifiableModelsProvider", "<init>"));
        }
        super(project2);
        this.myModifiableRootModels = new THashMap();
        this.myModifiableFacetModels = new THashMap();
        this.myProductionModulesForTestModules = new THashMap();
        this.myModifiableLibraryModels = new IdentityHashMap<Library, Library.ModifiableModel>();
        this.myArtifactExternalDependenciesImporter = new ArtifactExternalDependenciesImporterImpl();
    }

    protected abstract ModifiableArtifactModel doGetModifiableArtifactModel();

    protected abstract ModifiableModuleModel doGetModifiableModuleModel();

    protected abstract ModifiableRootModel doGetModifiableRootModel(Module var1);

    protected abstract ModifiableFacetModel doGetModifiableFacetModel(Module var1);

    protected abstract Library.ModifiableModel doGetModifiableLibraryModel(Library var1);

    @NotNull
    public abstract LibraryTable.ModifiableModel getModifiableProjectLibrariesModel();

    @NotNull
    public Module[] getModules() {
        Module[] moduleArray = this.getModifiableModuleModel().getModules();
        if (moduleArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/externalSystem/service/project/AbstractIdeModifiableModelsProvider", "getModules"));
        }
        return moduleArray;
    }

    protected void processExternalArtifactDependencies() {
        this.myArtifactExternalDependenciesImporter.applyChanges(this.getModifiableArtifactModel(), this.getPackagingElementResolvingContext());
    }

    public PackagingElementResolvingContext getPackagingElementResolvingContext() {
        if (this.myPackagingElementResolvingContext == null) {
            this.myPackagingElementResolvingContext = new MyPackagingElementResolvingContext();
        }
        return this.myPackagingElementResolvingContext;
    }

    @NotNull
    public OrderEntry[] getOrderEntries(@NotNull Module module2) {
        if (module2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/openapi/externalSystem/service/project/AbstractIdeModifiableModelsProvider", "getOrderEntries"));
        }
        OrderEntry[] orderEntryArray = this.getRootModel(module2).getOrderEntries();
        if (orderEntryArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/externalSystem/service/project/AbstractIdeModifiableModelsProvider", "getOrderEntries"));
        }
        return orderEntryArray;
    }

    @NotNull
    public Module newModule(@NotNull String filePath, String moduleTypeId) {
        if (filePath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filePath", "com/intellij/openapi/externalSystem/service/project/AbstractIdeModifiableModelsProvider", "newModule"));
        }
        Module module2 = this.getModifiableModuleModel().newModule(filePath, moduleTypeId);
        String moduleName = FileUtil.getNameWithoutExtension((File)new File(filePath));
        if (!module2.getName().equals(moduleName)) {
            try {
                this.getModifiableModuleModel().renameModule(module2, moduleName);
            }
            catch (ModuleWithNameAlreadyExists exists) {
                LOG.warn((Throwable)exists);
            }
        }
        module2.setOption("type", moduleTypeId);
        Module module3 = module2;
        if (module3 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/externalSystem/service/project/AbstractIdeModifiableModelsProvider", "newModule"));
        }
        return module3;
    }

    @Nullable
    public Module findIdeModule(@NotNull String ideModuleName) {
        if (ideModuleName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ideModuleName", "com/intellij/openapi/externalSystem/service/project/AbstractIdeModifiableModelsProvider", "findIdeModule"));
        }
        Module module2 = this.getModifiableModuleModel().findModuleByName(ideModuleName);
        return module2 == null ? this.getModifiableModuleModel().getModuleToBeRenamed(ideModuleName) : module2;
    }

    @Nullable
    public Library findIdeLibrary(@NotNull LibraryData libraryData) {
        if (libraryData == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "libraryData", "com/intellij/openapi/externalSystem/service/project/AbstractIdeModifiableModelsProvider", "findIdeLibrary"));
        }
        LibraryTable.ModifiableModel libraryTable = this.getModifiableProjectLibrariesModel();
        for (Library ideLibrary : libraryTable.getLibraries()) {
            if (!ExternalSystemApiUtil.isRelated((Library)ideLibrary, (LibraryData)libraryData)) continue;
            return ideLibrary;
        }
        return null;
    }

    @NotNull
    public VirtualFile[] getContentRoots(Module module2) {
        VirtualFile[] virtualFileArray = this.getRootModel(module2).getContentRoots();
        if (virtualFileArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/externalSystem/service/project/AbstractIdeModifiableModelsProvider", "getContentRoots"));
        }
        return virtualFileArray;
    }

    @NotNull
    public VirtualFile[] getSourceRoots(Module module2) {
        VirtualFile[] virtualFileArray = this.getRootModel(module2).getSourceRoots();
        if (virtualFileArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/externalSystem/service/project/AbstractIdeModifiableModelsProvider", "getSourceRoots"));
        }
        return virtualFileArray;
    }

    @NotNull
    public VirtualFile[] getSourceRoots(Module module2, boolean includingTests) {
        VirtualFile[] virtualFileArray = this.getRootModel(module2).getSourceRoots(includingTests);
        if (virtualFileArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/externalSystem/service/project/AbstractIdeModifiableModelsProvider", "getSourceRoots"));
        }
        return virtualFileArray;
    }

    @NotNull
    public ModifiableModuleModel getModifiableModuleModel() {
        if (this.myModifiableModuleModel == null) {
            this.myModifiableModuleModel = this.doGetModifiableModuleModel();
        }
        ModifiableModuleModel modifiableModuleModel = this.myModifiableModuleModel;
        if (modifiableModuleModel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/externalSystem/service/project/AbstractIdeModifiableModelsProvider", "getModifiableModuleModel"));
        }
        return modifiableModuleModel;
    }

    @NotNull
    public ModifiableRootModel getModifiableRootModel(Module module2) {
        ModifiableRootModel modifiableRootModel = (ModifiableRootModel)this.getRootModel(module2);
        if (modifiableRootModel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/externalSystem/service/project/AbstractIdeModifiableModelsProvider", "getModifiableRootModel"));
        }
        return modifiableRootModel;
    }

    @NotNull
    private ModuleRootModel getRootModel(Module module2) {
        ModifiableRootModel result = this.myModifiableRootModels.get(module2);
        if (result == null) {
            result = this.doGetModifiableRootModel(module2);
            this.myModifiableRootModels.put(module2, result);
        }
        ModifiableRootModel modifiableRootModel = result;
        if (modifiableRootModel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/externalSystem/service/project/AbstractIdeModifiableModelsProvider", "getRootModel"));
        }
        return modifiableRootModel;
    }

    @NotNull
    public ModifiableFacetModel getModifiableFacetModel(Module module2) {
        ModifiableFacetModel result = this.myModifiableFacetModels.get(module2);
        if (result == null) {
            result = this.doGetModifiableFacetModel(module2);
            this.myModifiableFacetModels.put(module2, result);
        }
        ModifiableFacetModel modifiableFacetModel = result;
        if (modifiableFacetModel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/externalSystem/service/project/AbstractIdeModifiableModelsProvider", "getModifiableFacetModel"));
        }
        return modifiableFacetModel;
    }

    @NotNull
    public ModifiableArtifactModel getModifiableArtifactModel() {
        if (this.myModifiableArtifactModel == null) {
            this.myModifiableArtifactModel = this.doGetModifiableArtifactModel();
        }
        ModifiableArtifactModel modifiableArtifactModel = this.myModifiableArtifactModel;
        if (modifiableArtifactModel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/externalSystem/service/project/AbstractIdeModifiableModelsProvider", "getModifiableArtifactModel"));
        }
        return modifiableArtifactModel;
    }

    @NotNull
    public Library[] getAllLibraries() {
        Library[] libraryArray = this.getModifiableProjectLibrariesModel().getLibraries();
        if (libraryArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/externalSystem/service/project/AbstractIdeModifiableModelsProvider", "getAllLibraries"));
        }
        return libraryArray;
    }

    @Nullable
    public Library getLibraryByName(String name) {
        return this.getModifiableProjectLibrariesModel().getLibraryByName(name);
    }

    public Library createLibrary(String name) {
        return this.getModifiableProjectLibrariesModel().createLibrary(name);
    }

    public void removeLibrary(Library library) {
        this.getModifiableProjectLibrariesModel().removeLibrary(library);
    }

    public Library.ModifiableModel getModifiableLibraryModel(Library library) {
        Library.ModifiableModel result = this.myModifiableLibraryModels.get(library);
        if (result == null) {
            result = this.doGetModifiableLibraryModel(library);
            this.myModifiableLibraryModels.put(library, result);
        }
        return result;
    }

    @NotNull
    public String[] getLibraryUrls(@NotNull Library library, @NotNull OrderRootType type) {
        if (library == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "library", "com/intellij/openapi/externalSystem/service/project/AbstractIdeModifiableModelsProvider", "getLibraryUrls"));
        }
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/openapi/externalSystem/service/project/AbstractIdeModifiableModelsProvider", "getLibraryUrls"));
        }
        Library.ModifiableModel model = this.myModifiableLibraryModels.get(library);
        if (model != null) {
            String[] stringArray = model.getUrls(type);
            if (stringArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/externalSystem/service/project/AbstractIdeModifiableModelsProvider", "getLibraryUrls"));
            }
            return stringArray;
        }
        String[] stringArray = library.getUrls(type);
        if (stringArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/externalSystem/service/project/AbstractIdeModifiableModelsProvider", "getLibraryUrls"));
        }
        return stringArray;
    }

    public ModalityState getModalityStateForQuestionDialogs() {
        return ModalityState.NON_MODAL;
    }

    public ArtifactExternalDependenciesImporter getArtifactExternalDependenciesImporter() {
        return this.myArtifactExternalDependenciesImporter;
    }

    @NotNull
    public List<Module> getAllDependentModules(@NotNull Module module2) {
        if (module2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/openapi/externalSystem/service/project/AbstractIdeModifiableModelsProvider", "getAllDependentModules"));
        }
        ArrayList<Module> list = new ArrayList<Module>();
        Graph<Module> graph = this.getModuleGraph(true);
        Iterator i = graph.getOut((Object)module2);
        while (i.hasNext()) {
            list.add((Module)i.next());
        }
        ArrayList<Module> arrayList = list;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/externalSystem/service/project/AbstractIdeModifiableModelsProvider", "getAllDependentModules"));
        }
        return arrayList;
    }

    private Graph<Module> getModuleGraph(final boolean includeTests) {
        return GraphGenerator.create((GraphGenerator.SemiGraph)CachingSemiGraph.create((GraphGenerator.SemiGraph)new GraphGenerator.SemiGraph<Module>(){

            public Collection<Module> getNodes() {
                return ContainerUtil.list((Object[])AbstractIdeModifiableModelsProvider.this.getModules());
            }

            public Iterator<Module> getIn(Module m) {
                Module[] dependentModules = AbstractIdeModifiableModelsProvider.this.getModifiableRootModel(m).getModuleDependencies(includeTests);
                return Arrays.asList(dependentModules).iterator();
            }
        }));
    }

    public void commit() {
        ((ProjectRootManagerEx)ProjectRootManager.getInstance((Project)this.myProject)).mergeRootsChangesDuring(new Runnable(){

            @Override
            public void run() {
                AbstractIdeModifiableModelsProvider.this.processExternalArtifactDependencies();
                for (Library.ModifiableModel each : AbstractIdeModifiableModelsProvider.this.myModifiableLibraryModels.values()) {
                    each.commit();
                }
                AbstractIdeModifiableModelsProvider.this.getModifiableProjectLibrariesModel().commit();
                Collection rootModels = AbstractIdeModifiableModelsProvider.this.myModifiableRootModels.values();
                ModifiableRootModel[] rootModels1 = rootModels.toArray(new ModifiableRootModel[rootModels.size()]);
                for (ModifiableRootModel model : rootModels1) {
                    assert (!model.isDisposed()) : "Already disposed: " + model;
                }
                if (AbstractIdeModifiableModelsProvider.this.myModifiableModuleModel != null) {
                    ModifiableModelCommitter.multiCommit(rootModels1, AbstractIdeModifiableModelsProvider.this.myModifiableModuleModel);
                } else {
                    for (ModifiableRootModel model : rootModels1) {
                        model.commit();
                    }
                }
                for (Map.Entry entry : AbstractIdeModifiableModelsProvider.this.myProductionModulesForTestModules.entrySet()) {
                    TestModuleProperties.getInstance((Module)entry.getKey()).setProductionModuleName((String)entry.getValue());
                }
                for (Map.Entry entry : AbstractIdeModifiableModelsProvider.this.myModifiableFacetModels.entrySet()) {
                    if (((Module)entry.getKey()).isDisposed()) continue;
                    ((ModifiableFacetModel)entry.getValue()).commit();
                }
                if (AbstractIdeModifiableModelsProvider.this.myModifiableArtifactModel != null) {
                    AbstractIdeModifiableModelsProvider.this.myModifiableArtifactModel.commit();
                }
            }
        });
    }

    public void dispose() {
        for (ModifiableRootModel modifiableRootModel : this.myModifiableRootModels.values()) {
            if (modifiableRootModel.isDisposed()) continue;
            modifiableRootModel.dispose();
        }
        Disposer.dispose((Disposable)this.getModifiableProjectLibrariesModel());
        for (Library.ModifiableModel modifiableModel : this.myModifiableLibraryModels.values()) {
            Disposer.dispose((Disposable)modifiableModel);
        }
        if (this.myModifiableModuleModel != null) {
            this.myModifiableModuleModel.dispose();
        }
        if (this.myModifiableArtifactModel != null) {
            this.myModifiableArtifactModel.dispose();
        }
        this.myModifiableRootModels.clear();
        this.myModifiableFacetModels.clear();
        this.myModifiableLibraryModels.clear();
    }

    public void setTestModuleProperties(Module testModule, String productionModuleName) {
        this.myProductionModulesForTestModules.put(testModule, productionModuleName);
    }

    private class MyFacetsProvider
    implements FacetsProvider {
        private MyFacetsProvider() {
        }

        @NotNull
        public Facet[] getAllFacets(Module module2) {
            Facet[] facetArray = AbstractIdeModifiableModelsProvider.this.getModifiableFacetModel(module2).getAllFacets();
            if (facetArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/externalSystem/service/project/AbstractIdeModifiableModelsProvider$MyFacetsProvider", "getAllFacets"));
            }
            return facetArray;
        }

        @NotNull
        public <F extends Facet> Collection<F> getFacetsByType(Module module2, FacetTypeId<F> type) {
            Collection collection = AbstractIdeModifiableModelsProvider.this.getModifiableFacetModel(module2).getFacetsByType(type);
            if (collection == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/externalSystem/service/project/AbstractIdeModifiableModelsProvider$MyFacetsProvider", "getFacetsByType"));
            }
            return collection;
        }

        public <F extends Facet> F findFacet(Module module2, FacetTypeId<F> type, String name) {
            return (F)AbstractIdeModifiableModelsProvider.this.getModifiableFacetModel(module2).findFacet(type, name);
        }
    }

    private class MyModulesProvider
    implements ModulesProvider {
        private MyModulesProvider() {
        }

        @NotNull
        public Module[] getModules() {
            Module[] moduleArray = AbstractIdeModifiableModelsProvider.this.getModules();
            if (moduleArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/externalSystem/service/project/AbstractIdeModifiableModelsProvider$MyModulesProvider", "getModules"));
            }
            return moduleArray;
        }

        public Module getModule(String name) {
            return AbstractIdeModifiableModelsProvider.this.findIdeModule(name);
        }

        public ModuleRootModel getRootModel(@NotNull Module module2) {
            if (module2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/openapi/externalSystem/service/project/AbstractIdeModifiableModelsProvider$MyModulesProvider", "getRootModel"));
            }
            return AbstractIdeModifiableModelsProvider.this.getModifiableRootModel(module2);
        }

        public FacetModel getFacetModel(@NotNull Module module2) {
            if (module2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/openapi/externalSystem/service/project/AbstractIdeModifiableModelsProvider$MyModulesProvider", "getFacetModel"));
            }
            return AbstractIdeModifiableModelsProvider.this.getModifiableFacetModel(module2);
        }
    }

    private class MyPackagingElementResolvingContext
    implements PackagingElementResolvingContext {
        private final ModulesProvider myModulesProvider;
        private final MyFacetsProvider myFacetsProvider;
        private final ManifestFileProvider myManifestFileProvider;

        private MyPackagingElementResolvingContext() {
            this.myModulesProvider = new MyModulesProvider();
            this.myFacetsProvider = new MyFacetsProvider();
            this.myManifestFileProvider = new DefaultManifestFileProvider(this);
        }

        @NotNull
        public Project getProject() {
            Project project2 = AbstractIdeModifiableModelsProvider.this.myProject;
            if (project2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/externalSystem/service/project/AbstractIdeModifiableModelsProvider$MyPackagingElementResolvingContext", "getProject"));
            }
            return project2;
        }

        @NotNull
        public ArtifactModel getArtifactModel() {
            ModifiableArtifactModel modifiableArtifactModel = AbstractIdeModifiableModelsProvider.this.getModifiableArtifactModel();
            if (modifiableArtifactModel == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/externalSystem/service/project/AbstractIdeModifiableModelsProvider$MyPackagingElementResolvingContext", "getArtifactModel"));
            }
            return modifiableArtifactModel;
        }

        @NotNull
        public ModulesProvider getModulesProvider() {
            ModulesProvider modulesProvider = this.myModulesProvider;
            if (modulesProvider == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/externalSystem/service/project/AbstractIdeModifiableModelsProvider$MyPackagingElementResolvingContext", "getModulesProvider"));
            }
            return modulesProvider;
        }

        @NotNull
        public FacetsProvider getFacetsProvider() {
            MyFacetsProvider myFacetsProvider = this.myFacetsProvider;
            if (myFacetsProvider == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/externalSystem/service/project/AbstractIdeModifiableModelsProvider$MyPackagingElementResolvingContext", "getFacetsProvider"));
            }
            return myFacetsProvider;
        }

        public Library findLibrary(@NotNull String level, @NotNull String libraryName) {
            if (level == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "level", "com/intellij/openapi/externalSystem/service/project/AbstractIdeModifiableModelsProvider$MyPackagingElementResolvingContext", "findLibrary"));
            }
            if (libraryName == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "libraryName", "com/intellij/openapi/externalSystem/service/project/AbstractIdeModifiableModelsProvider$MyPackagingElementResolvingContext", "findLibrary"));
            }
            if (level.equals("project")) {
                return AbstractIdeModifiableModelsProvider.this.getLibraryByName(libraryName);
            }
            LibraryTable table = LibraryTablesRegistrar.getInstance().getLibraryTableByLevel(level, AbstractIdeModifiableModelsProvider.this.myProject);
            return table != null ? table.getLibraryByName(libraryName) : null;
        }

        @NotNull
        public ManifestFileProvider getManifestFileProvider() {
            ManifestFileProvider manifestFileProvider = this.myManifestFileProvider;
            if (manifestFileProvider == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/externalSystem/service/project/AbstractIdeModifiableModelsProvider$MyPackagingElementResolvingContext", "getManifestFileProvider"));
            }
            return manifestFileProvider;
        }
    }
}

