/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.diff.impl.patch;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ContentRevision;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class SelectFilesToAddTextsToPatchPanel {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.diff.impl.patch.SelectFilesToAddTextsToPatchPanel");

    public static Set<Change> getBig(List<Change> changes) {
        HashSet<Change> exclude = new HashSet<Change>();
        for (Change change : changes) {
            ContentRevision beforeRevision = change.getBeforeRevision();
            if (beforeRevision == null) continue;
            try {
                String content = beforeRevision.getContent();
                if (content == null) {
                    FilePath file2 = beforeRevision.getFile();
                    LOG.info("null content for " + file2.getPath() + ", is dir: " + file2.isDirectory());
                    continue;
                }
                if ((long)content.length() <= 500000L) continue;
                exclude.add(change);
            }
            catch (VcsException e) {
                LOG.info((Throwable)e);
            }
        }
        return exclude;
    }
}

