/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.diff.impl.highlighting;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diff.DiffContent;
import com.intellij.openapi.diff.impl.ContentChangeListener;
import com.intellij.openapi.diff.impl.highlighting.SimpleDiffPanelState;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import java.awt.Graphics;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;

public class DiffPanelState
extends SimpleDiffPanelState {
    protected final int myDiffDividerPolygonsOffset;

    public DiffPanelState(ContentChangeListener changeListener, Project project2, int diffDividerPolygonsOffset, @NotNull Disposable parentDisposable) {
        if (parentDisposable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentDisposable", "com/intellij/openapi/diff/impl/highlighting/DiffPanelState", "<init>"));
        }
        super(project2, changeListener, parentDisposable);
        this.myDiffDividerPolygonsOffset = diffDividerPolygonsOffset;
    }

    public void setContents(final DiffContent content1, final DiffContent content2) {
        ApplicationManager.getApplication().runWriteAction(new Runnable(){

            @Override
            public void run() {
                DiffPanelState.this.myAppender1.setContent(content1);
                DiffPanelState.this.myAppender2.setContent(content2);
            }
        });
    }

    public DiffContent getContent1() {
        return this.myAppender1.getContent();
    }

    public DiffContent getContent2() {
        return this.myAppender2.getContent();
    }

    public void removeActions() {
        this.myAppender1.removeActions();
        this.myAppender2.removeActions();
    }

    public void drawOnDivider(Graphics g, JComponent component) {
    }

    public boolean isContentsEqual() {
        return Comparing.equal((String)this.myAppender1.getText(), (String)this.myAppender2.getText());
    }
}

