/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.actionSystem.impl;

import com.intellij.openapi.actionSystem.ActionStub;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.impl.ActionManagerImpl;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectType;
import com.intellij.openapi.project.ProjectTypeService;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ChameleonAction
extends AnAction {
    private final Map<ProjectType, AnAction> myActions;

    public ChameleonAction(@NotNull AnAction first, ProjectType projectType) {
        if (first == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "first", "com/intellij/openapi/actionSystem/impl/ChameleonAction", "<init>"));
        }
        this.myActions = new HashMap<ProjectType, AnAction>();
        this.addAction(first, projectType);
        this.copyFrom(this.myActions.values().iterator().next());
    }

    public AnAction addAction(AnAction action, ProjectType projectType) {
        if (action instanceof ActionStub) {
            String type = ((ActionStub)action).getProjectType();
            action = ActionManagerImpl.convertStub((ActionStub)action);
            projectType = type == null ? null : new ProjectType(type);
        }
        return this.myActions.put(projectType, action);
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/openapi/actionSystem/impl/ChameleonAction", "actionPerformed"));
        }
        AnAction action = this.getAction(e);
        assert (action != null);
        action.actionPerformed(e);
    }

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/openapi/actionSystem/impl/ChameleonAction", "update"));
        }
        AnAction action = this.getAction(e);
        if (action != null) {
            e.getPresentation().setVisible(true);
            action.update(e);
        } else {
            e.getPresentation().setVisible(false);
        }
    }

    @Nullable
    private AnAction getAction(AnActionEvent e) {
        Project project2 = (Project)CommonDataKeys.PROJECT.getData(e.getDataContext());
        ProjectType projectType = ProjectTypeService.getProjectType((Project)project2);
        AnAction action = this.myActions.get(projectType);
        if (action == null) {
            action = this.myActions.get(null);
        }
        return action;
    }

    public Map<ProjectType, AnAction> getActions() {
        return this.myActions;
    }
}

