/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.structureView.impl.java;

import com.intellij.ide.structureView.impl.java.AccessLevelProvider;
import com.intellij.ide.util.treeView.WeighedItem;
import com.intellij.ide.util.treeView.smartTree.Group;
import com.intellij.ide.util.treeView.smartTree.TreeElement;
import com.intellij.navigation.ColoredItemPresentation;
import com.intellij.navigation.ItemPresentation;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.colors.CodeInsightColors;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.IconLoader;
import com.intellij.psi.PsiDocCommentOwner;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiType;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.SmartTypePointer;
import com.intellij.psi.SmartTypePointerManager;
import com.intellij.psi.util.PropertyUtil;
import com.intellij.psi.util.PsiUtil;
import java.util.ArrayList;
import java.util.Collection;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class PropertyGroup
implements Group,
ColoredItemPresentation,
AccessLevelProvider,
WeighedItem {
    private final String myPropertyName;
    private final SmartTypePointer myPropertyType;
    private SmartPsiElementPointer myFieldPointer;
    private SmartPsiElementPointer myGetterPointer;
    private SmartPsiElementPointer mySetterPointer;
    private boolean myIsStatic;
    public static final Icon PROPERTY_READ_ICON = PropertyGroup.loadIcon("/nodes/propertyRead.png");
    public static final Icon PROPERTY_READ_STATIC_ICON = PropertyGroup.loadIcon("/nodes/propertyReadStatic.png");
    public static final Icon PROPERTY_WRITE_ICON = PropertyGroup.loadIcon("/nodes/propertyWrite.png");
    public static final Icon PROPERTY_WRITE_STATIC_ICON = PropertyGroup.loadIcon("/nodes/propertyWriteStatic.png");
    public static final Icon PROPERTY_READ_WRITE_ICON = PropertyGroup.loadIcon("/nodes/propertyReadWrite.png");
    public static final Icon PROPERTY_READ_WRITE_STATIC_ICON = PropertyGroup.loadIcon("/nodes/propertyReadWriteStatic.png");
    private final Project myProject;
    private final Collection<TreeElement> myChildren;

    private PropertyGroup(String propertyName, PsiType propertyType, boolean isStatic, @NotNull Project project2) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/ide/structureView/impl/java/PropertyGroup", "<init>"));
        }
        this.myChildren = new ArrayList<TreeElement>();
        this.myPropertyName = propertyName;
        this.myPropertyType = SmartTypePointerManager.getInstance((Project)project2).createSmartTypePointer(propertyType);
        this.myIsStatic = isStatic;
        this.myProject = project2;
    }

    public static PropertyGroup createOn(PsiElement object, TreeElement treeElement) {
        if (object instanceof PsiField) {
            PsiField field = (PsiField)object;
            PropertyGroup group = new PropertyGroup(PropertyUtil.suggestPropertyName((PsiField)field), field.getType(), field.hasModifierProperty("static"), object.getProject());
            group.setField(field);
            group.myChildren.add(treeElement);
            return group;
        }
        if (object instanceof PsiMethod) {
            PsiMethod method = (PsiMethod)object;
            if (PropertyUtil.isSimplePropertyGetter((PsiMethod)method)) {
                PropertyGroup group = new PropertyGroup(PropertyUtil.getPropertyNameByGetter((PsiMethod)method), method.getReturnType(), method.hasModifierProperty("static"), object.getProject());
                group.setGetter(method);
                group.myChildren.add(treeElement);
                return group;
            }
            if (PropertyUtil.isSimplePropertySetter((PsiMethod)method)) {
                PropertyGroup group = new PropertyGroup(PropertyUtil.getPropertyNameBySetter((PsiMethod)method), method.getParameterList().getParameters()[0].getType(), method.hasModifierProperty("static"), object.getProject());
                group.setSetter(method);
                group.myChildren.add(treeElement);
                return group;
            }
        }
        return null;
    }

    @NotNull
    public Collection<TreeElement> getChildren() {
        Collection<TreeElement> collection = this.myChildren;
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/structureView/impl/java/PropertyGroup", "getChildren"));
        }
        return collection;
    }

    @NotNull
    public ItemPresentation getPresentation() {
        PropertyGroup propertyGroup = this;
        if (propertyGroup == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/structureView/impl/java/PropertyGroup", "getPresentation"));
        }
        return propertyGroup;
    }

    public Icon getIcon(boolean open2) {
        if (this.isStatic()) {
            if (this.getGetter() != null && this.getSetter() != null) {
                return PROPERTY_READ_WRITE_STATIC_ICON;
            }
            if (this.getGetter() != null) {
                return PROPERTY_READ_STATIC_ICON;
            }
            return PROPERTY_WRITE_STATIC_ICON;
        }
        if (this.getGetter() != null && this.getSetter() != null) {
            return PROPERTY_READ_WRITE_ICON;
        }
        if (this.getGetter() != null) {
            return PROPERTY_READ_ICON;
        }
        return PROPERTY_WRITE_ICON;
    }

    private boolean isStatic() {
        return this.myIsStatic;
    }

    public String getLocationString() {
        return null;
    }

    public String getPresentableText() {
        PsiType type = this.getPropertyType();
        return this.myPropertyName + (type != null ? ": " + type.getPresentableText() : "");
    }

    public String toString() {
        return this.myPropertyName;
    }

    public boolean equals(Object o) {
        PsiType otherPropertyType;
        if (this == o) {
            return true;
        }
        if (!(o instanceof PropertyGroup)) {
            return false;
        }
        PropertyGroup propertyGroup = (PropertyGroup)o;
        if (this.myPropertyName != null ? !this.myPropertyName.equals(propertyGroup.myPropertyName) : propertyGroup.myPropertyName != null) {
            return false;
        }
        PsiType propertyType = this.getPropertyType();
        return Comparing.equal((Object)propertyType, (Object)(otherPropertyType = propertyGroup.getPropertyType()));
    }

    public int hashCode() {
        return this.myPropertyName != null ? this.myPropertyName.hashCode() : 0;
    }

    public String getGetterName() {
        return PropertyUtil.suggestGetterName((String)this.myPropertyName, (PsiType)this.getPropertyType());
    }

    private PsiType getPropertyType() {
        if (this.myPropertyType == null) {
            return null;
        }
        return this.myPropertyType.getType();
    }

    @Override
    public int getAccessLevel() {
        int result = 1;
        if (this.getGetter() != null) {
            result = Math.max(result, PsiUtil.getAccessLevel((PsiModifierList)this.getGetter().getModifierList()));
        }
        if (this.getSetter() != null) {
            result = Math.max(result, PsiUtil.getAccessLevel((PsiModifierList)this.getSetter().getModifierList()));
        }
        if (this.getField() != null) {
            result = Math.max(result, PsiUtil.getAccessLevel((PsiModifierList)this.getField().getModifierList()));
        }
        return result;
    }

    @Override
    public int getSubLevel() {
        return 0;
    }

    public void setField(PsiField field) {
        this.myFieldPointer = SmartPointerManager.getInstance((Project)this.myProject).createSmartPsiElementPointer((PsiElement)field);
        this.myIsStatic &= field.hasModifierProperty("static");
    }

    public void setGetter(PsiMethod getter) {
        this.myGetterPointer = SmartPointerManager.getInstance((Project)this.myProject).createSmartPsiElementPointer((PsiElement)getter);
        this.myIsStatic &= getter.hasModifierProperty("static");
    }

    public void setSetter(PsiMethod setter) {
        this.mySetterPointer = SmartPointerManager.getInstance((Project)this.myProject).createSmartPsiElementPointer((PsiElement)setter);
        this.myIsStatic &= setter.hasModifierProperty("static");
    }

    public PsiField getField() {
        return (PsiField)(this.myFieldPointer == null ? null : this.myFieldPointer.getElement());
    }

    public PsiMethod getGetter() {
        return (PsiMethod)(this.myGetterPointer == null ? null : this.myGetterPointer.getElement());
    }

    public PsiMethod getSetter() {
        return (PsiMethod)(this.mySetterPointer == null ? null : this.mySetterPointer.getElement());
    }

    void copyAccessorsFrom(PropertyGroup group) {
        if (group.getGetter() != null) {
            this.setGetter(group.getGetter());
        }
        if (group.getSetter() != null) {
            this.setSetter(group.getSetter());
        }
        if (group.getField() != null) {
            this.setField(group.getField());
        }
        this.myChildren.addAll(group.myChildren);
    }

    private static Icon loadIcon(@NonNls String resourceName) {
        Icon icon = IconLoader.findIcon((String)resourceName);
        Application application = ApplicationManager.getApplication();
        if (icon == null && application != null && application.isUnitTestMode()) {
            return new ImageIcon();
        }
        return icon;
    }

    public TextAttributesKey getTextAttributesKey() {
        return this.isDeprecated() ? CodeInsightColors.DEPRECATED_ATTRIBUTES : null;
    }

    private boolean isDeprecated() {
        return PropertyGroup.isDeprecated((PsiElement)this.getField()) && PropertyGroup.isDeprecated((PsiElement)this.getGetter()) && PropertyGroup.isDeprecated((PsiElement)this.getSetter());
    }

    private static boolean isDeprecated(PsiElement element) {
        if (element == null) {
            return false;
        }
        if (!element.isValid()) {
            return false;
        }
        if (!(element instanceof PsiDocCommentOwner)) {
            return false;
        }
        return ((PsiDocCommentOwner)element).isDeprecated();
    }

    public boolean isComplete() {
        return this.getGetter() != null || this.getSetter() != null;
    }

    public Object getValue() {
        return this;
    }

    public int getWeight() {
        return 60;
    }
}

