/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.favoritesTreeView;

import com.intellij.codeInspection.reference.RefMethodImpl;
import com.intellij.ide.favoritesTreeView.FavoriteNodeProvider;
import com.intellij.ide.favoritesTreeView.smartPointerPsiNodes.MethodSmartPointerNode;
import com.intellij.ide.projectView.ViewSettings;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.presentation.java.ClassPresentationUtil;
import com.intellij.psi.util.PsiFormatUtil;
import java.util.ArrayList;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;

public class PsiMethodFavoriteNodeProvider
extends FavoriteNodeProvider {
    public Collection<AbstractTreeNode> getFavoriteNodes(DataContext context, ViewSettings viewSettings) {
        PsiElement element;
        Project project2 = (Project)CommonDataKeys.PROJECT.getData(context);
        if (project2 == null) {
            return null;
        }
        PsiElement[] elements = (PsiElement[])LangDataKeys.PSI_ELEMENT_ARRAY.getData(context);
        if (elements == null && (element = (PsiElement)CommonDataKeys.PSI_ELEMENT.getData(context)) != null) {
            elements = new PsiElement[]{element};
        }
        if (elements != null) {
            ArrayList<AbstractTreeNode> result = new ArrayList<AbstractTreeNode>();
            for (PsiElement element2 : elements) {
                if (!(element2 instanceof PsiMethod)) continue;
                result.add((AbstractTreeNode)new MethodSmartPointerNode(project2, element2, viewSettings));
            }
            return result.isEmpty() ? null : result;
        }
        return null;
    }

    public AbstractTreeNode createNode(Project project2, Object element, ViewSettings viewSettings) {
        if (element instanceof PsiMethod) {
            return new MethodSmartPointerNode(project2, element, viewSettings);
        }
        return super.createNode(project2, element, viewSettings);
    }

    public boolean elementContainsFile(Object element, VirtualFile vFile) {
        return false;
    }

    public int getElementWeight(Object value, boolean isSortByType) {
        if (value instanceof PsiMethod) {
            return 5;
        }
        return -1;
    }

    public String getElementLocation(Object element) {
        PsiClass parent;
        if (element instanceof PsiMethod && (parent = ((PsiMethod)element).getContainingClass()) != null) {
            return ClassPresentationUtil.getNameForClass(parent, true);
        }
        return null;
    }

    public boolean isInvalidElement(Object element) {
        return element instanceof PsiMethod && !((PsiMethod)element).isValid();
    }

    @NotNull
    public String getFavoriteTypeId() {
        if ("method" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/favoritesTreeView/PsiMethodFavoriteNodeProvider", "getFavoriteTypeId"));
        }
        return "method";
    }

    public String getElementUrl(Object element) {
        if (element instanceof PsiMethod) {
            PsiMethod aMethod = (PsiMethod)element;
            if (DumbService.isDumb((Project)aMethod.getProject())) {
                return null;
            }
            return PsiFormatUtil.getExternalName((PsiModifierListOwner)aMethod);
        }
        return null;
    }

    public String getElementModuleName(Object element) {
        if (element instanceof PsiMethod) {
            PsiMethod aMethod = (PsiMethod)element;
            Module module2 = ModuleUtilCore.findModuleForPsiElement((PsiElement)aMethod);
            return module2 != null ? module2.getName() : null;
        }
        return null;
    }

    public Object[] createPathFromUrl(Project project2, String url, String moduleName) {
        if (DumbService.isDumb((Project)project2)) {
            return null;
        }
        PsiMethod method = RefMethodImpl.findPsiMethod(PsiManager.getInstance((Project)project2), url);
        if (method == null) {
            return null;
        }
        return new Object[]{method};
    }
}

