/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions;

import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.openapi.wm.ex.ToolWindowEx;
import com.intellij.openapi.wm.ex.ToolWindowManagerEx;

public abstract class BaseToolWindowToggleAction
extends ToggleAction
implements DumbAware {
    public final boolean isSelected(AnActionEvent e) {
        Project project2 = (Project)CommonDataKeys.PROJECT.getData(e.getDataContext());
        if (project2 == null || project2.isDisposed()) {
            return false;
        }
        ToolWindowManager mgr = ToolWindowManager.getInstance((Project)project2);
        String id = mgr.getActiveToolWindowId();
        if (id == null) {
            return false;
        }
        return this.isSelected(mgr.getToolWindow(id));
    }

    protected abstract boolean isSelected(ToolWindow var1);

    public final void setSelected(AnActionEvent e, boolean state) {
        Project project2 = (Project)CommonDataKeys.PROJECT.getData(e.getDataContext());
        if (project2 == null) {
            return;
        }
        String id = ToolWindowManager.getInstance((Project)project2).getActiveToolWindowId();
        if (id == null) {
            return;
        }
        ToolWindowManagerEx mgr = ToolWindowManagerEx.getInstanceEx(project2);
        ToolWindowEx toolWindow = (ToolWindowEx)mgr.getToolWindow(id);
        this.setSelected(toolWindow, state);
    }

    protected abstract void setSelected(ToolWindow var1, boolean var2);

    public final void update(AnActionEvent e) {
        super.update(e);
        Presentation presentation = e.getPresentation();
        Project project2 = (Project)CommonDataKeys.PROJECT.getData(e.getDataContext());
        if (project2 == null) {
            presentation.setEnabled(false);
            return;
        }
        ToolWindowManager mgr = ToolWindowManager.getInstance((Project)project2);
        String id = mgr.getActiveToolWindowId();
        if (id == null) {
            presentation.setEnabled(false);
            return;
        }
        ToolWindow window = mgr.getToolWindow(id);
        if (window == null) {
            presentation.setEnabled(false);
            return;
        }
        this.update(window, presentation);
    }

    protected abstract void update(ToolWindow var1, Presentation var2);
}

