/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.html.index;

import com.intellij.lang.Language;
import com.intellij.lang.html.HTMLLanguage;
import com.intellij.lang.xhtml.XHTMLLanguage;
import com.intellij.lexer.HtmlHighlightingLexer;
import com.intellij.lexer.XHtmlHighlightingLexer;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.xml.XmlTokenType;
import com.intellij.util.containers.HashMap;
import com.intellij.util.indexing.DataIndexer;
import com.intellij.util.indexing.DefaultFileTypeSpecificInputFilter;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.indexing.FileContent;
import com.intellij.util.indexing.ID;
import com.intellij.util.indexing.ScalarIndexExtension;
import com.intellij.util.io.EnumeratorStringDescriptor;
import com.intellij.util.io.KeyDescriptor;
import com.intellij.xml.util.HtmlUtil;
import java.util.Collections;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class Html5CustomAttributesIndex
extends ScalarIndexExtension<String> {
    public static final ID<String, Void> INDEX_ID = ID.create((String)"html5.custom.attributes.index");
    private final DataIndexer<String, Void, FileContent> myIndexer = new DataIndexer<String, Void, FileContent>(){

        @NotNull
        public Map<String, Void> map(@NotNull FileContent inputData) {
            if (inputData == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "inputData", "com/intellij/html/index/Html5CustomAttributesIndex$1", "map"));
            }
            CharSequence input = inputData.getContentAsText();
            Language language = ((LanguageFileType)inputData.getFileType()).getLanguage();
            if (language == HTMLLanguage.INSTANCE || language == XHTMLLanguage.INSTANCE) {
                HtmlHighlightingLexer lexer = language == HTMLLanguage.INSTANCE ? new HtmlHighlightingLexer(FileTypeManager.getInstance().getStdFileType("CSS")) : new XHtmlHighlightingLexer();
                lexer.start(input);
                HashMap result = new HashMap();
                IElementType tokenType = lexer.getTokenType();
                while (tokenType != null) {
                    if (tokenType == XmlTokenType.XML_NAME) {
                        String xmlName = input.subSequence(lexer.getTokenStart(), lexer.getTokenEnd()).toString();
                        if (HtmlUtil.isCustomHtml5Attribute(xmlName)) {
                            result.put(xmlName, null);
                        }
                    } else if (tokenType == XmlTokenType.XML_DOCTYPE_PUBLIC || tokenType == XmlTokenType.XML_DOCTYPE_SYSTEM) break;
                    lexer.advance();
                    tokenType = lexer.getTokenType();
                }
                HashMap hashMap = result;
                if (hashMap == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/html/index/Html5CustomAttributesIndex$1", "map"));
                }
                return hashMap;
            }
            Map<String, Void> map = Collections.emptyMap();
            if (map == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/html/index/Html5CustomAttributesIndex$1", "map"));
            }
            return map;
        }
    };

    @NotNull
    public ID<String, Void> getName() {
        ID<String, Void> iD = INDEX_ID;
        if (iD == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/html/index/Html5CustomAttributesIndex", "getName"));
        }
        return iD;
    }

    @NotNull
    public DataIndexer<String, Void, FileContent> getIndexer() {
        DataIndexer<String, Void, FileContent> dataIndexer = this.myIndexer;
        if (dataIndexer == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/html/index/Html5CustomAttributesIndex", "getIndexer"));
        }
        return dataIndexer;
    }

    @NotNull
    public KeyDescriptor<String> getKeyDescriptor() {
        EnumeratorStringDescriptor enumeratorStringDescriptor = new EnumeratorStringDescriptor();
        if (enumeratorStringDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/html/index/Html5CustomAttributesIndex", "getKeyDescriptor"));
        }
        return enumeratorStringDescriptor;
    }

    @NotNull
    public FileBasedIndex.InputFilter getInputFilter() {
        DefaultFileTypeSpecificInputFilter defaultFileTypeSpecificInputFilter = new DefaultFileTypeSpecificInputFilter(new FileType[]{StdFileTypes.HTML, StdFileTypes.XHTML}){

            public boolean acceptInput(@NotNull VirtualFile file2) {
                if (file2 == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/html/index/Html5CustomAttributesIndex$2", "acceptInput"));
                }
                return file2.isInLocalFileSystem();
            }
        };
        if (defaultFileTypeSpecificInputFilter == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/html/index/Html5CustomAttributesIndex", "getInputFilter"));
        }
        return defaultFileTypeSpecificInputFilter;
    }

    public boolean dependsOnFileContent() {
        return true;
    }

    public int getVersion() {
        return 1;
    }
}

