/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.history.integration.patches;

import com.intellij.openapi.diff.impl.patch.FilePatch;
import com.intellij.openapi.diff.impl.patch.IdeaTextPatchBuilder;
import com.intellij.openapi.diff.impl.patch.UnifiedDiffWriter;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.CommitContext;
import com.intellij.psi.codeStyle.CodeStyleSettingsManager;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.List;

public class PatchCreator {
    public static void create(Project p, List<Change> changes, String filePath, boolean isReverse, CommitContext commitContext) throws IOException, VcsException {
        List patches = IdeaTextPatchBuilder.buildPatch((Project)p, changes, (String)p.getBaseDir().getPath(), (boolean)isReverse);
        PatchCreator.writeFilePatches(p, filePath, patches, commitContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeFilePatches(Project p, String filePath, List<FilePatch> patches, CommitContext commitContext) throws IOException {
        try (OutputStreamWriter writer = new OutputStreamWriter(new FileOutputStream(filePath));){
            String lineSeparator = CodeStyleSettingsManager.getInstance((Project)p).getCurrentSettings().getLineSeparator();
            UnifiedDiffWriter.write((Project)p, patches, (Writer)writer, (String)lineSeparator, (CommitContext)commitContext);
        }
    }
}

