/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.testframework.export;

import com.intellij.execution.DefaultExecutionTarget;
import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.ExecutionTarget;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.filters.CompositeFilter;
import com.intellij.execution.filters.ConsoleFilterProvider;
import com.intellij.execution.filters.Filter;
import com.intellij.execution.filters.HyperlinkInfo;
import com.intellij.execution.filters.OpenFileHyperlinkInfo;
import com.intellij.execution.impl.ConsoleBuffer;
import com.intellij.execution.testframework.AbstractTestProxy;
import com.intellij.execution.testframework.Printable;
import com.intellij.execution.testframework.Printer;
import com.intellij.execution.testframework.TestConsoleProperties;
import com.intellij.execution.testframework.TestProxyRoot;
import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.config.AbstractProperty;
import java.text.SimpleDateFormat;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.TreeMap;
import org.jdom.Attribute;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class TestResultsXmlFormatter {
    private static final String ELEM_RUN = "testrun";
    public static final String ELEM_TEST = "test";
    public static final String ELEM_SUITE = "suite";
    public static final String ATTR_NAME = "name";
    public static final String ATTR_DURATION = "duration";
    public static final String ATTR_LOCATION = "locationUrl";
    public static final String ELEM_COUNT = "count";
    public static final String ATTR_VALUE = "value";
    public static final String ELEM_OUTPUT = "output";
    public static final String ATTR_OUTPUT_TYPE = "type";
    public static final String ATTR_STATUS = "status";
    public static final String TOTAL_STATUS = "total";
    private static final String ATTR_FOORTER_TEXT = "footerText";
    public static final String ATTR_CONFIG = "isConfig";
    public static final String STATUS_PASSED = "passed";
    public static final String STATUS_FAILED = "failed";
    public static final String STATUS_ERROR = "error";
    public static final String STATUS_IGNORED = "ignored";
    public static final String STATUS_SKIPPED = "skipped";
    public static final String ROOT_ELEM = "root";
    private final RunConfiguration myRuntimeConfiguration;
    private final ContentHandler myResultHandler;
    private final AbstractTestProxy myTestRoot;
    private final boolean myHidePassedConfig;
    private final ExecutionTarget myExecutionTarget;

    public static void execute(AbstractTestProxy root, RunConfiguration runtimeConfiguration, TestConsoleProperties properties, ContentHandler resultHandler) throws SAXException {
        new TestResultsXmlFormatter(root, runtimeConfiguration, properties, resultHandler).execute();
    }

    private TestResultsXmlFormatter(AbstractTestProxy root, RunConfiguration runtimeConfiguration, TestConsoleProperties properties, ContentHandler resultHandler) {
        this.myRuntimeConfiguration = runtimeConfiguration;
        this.myTestRoot = root;
        this.myResultHandler = resultHandler;
        this.myHidePassedConfig = TestConsoleProperties.HIDE_SUCCESSFUL_CONFIG.value((AbstractProperty.AbstractPropertyContainer)properties);
        this.myExecutionTarget = properties.getExecutionTarget();
    }

    private void execute() throws SAXException {
        String presentation;
        this.myResultHandler.startDocument();
        TreeMap<String, Integer> counts = new TreeMap<String, Integer>(new Comparator<String>(){

            @Override
            public int compare(String o1, String o2) {
                if (TestResultsXmlFormatter.TOTAL_STATUS.equals(o1) && !TestResultsXmlFormatter.TOTAL_STATUS.equals(o2)) {
                    return -1;
                }
                if (TestResultsXmlFormatter.TOTAL_STATUS.equals(o2) && !TestResultsXmlFormatter.TOTAL_STATUS.equals(o1)) {
                    return 1;
                }
                return o1.compareTo(o2);
            }
        });
        for (AbstractTestProxy abstractTestProxy : this.myTestRoot.getAllTests()) {
            if (!abstractTestProxy.isLeaf()) continue;
            String status = TestResultsXmlFormatter.getStatusString(abstractTestProxy);
            TestResultsXmlFormatter.increment(counts, status);
            TestResultsXmlFormatter.increment(counts, TOTAL_STATUS);
        }
        HashMap<String, String> runAttrs = new HashMap<String, String>();
        runAttrs.put(ATTR_NAME, this.myRuntimeConfiguration.getName());
        String string = ExecutionBundle.message((String)"export.test.results.footer", (Object[])new Object[]{ApplicationNamesInfo.getInstance().getFullProductName(), new SimpleDateFormat().format(new Date())});
        runAttrs.put(ATTR_FOORTER_TEXT, string);
        Long duration = this.myTestRoot.getDuration();
        if (duration != null) {
            runAttrs.put(ATTR_DURATION, String.valueOf(duration));
        }
        this.startElement(ELEM_RUN, runAttrs);
        for (Map.Entry<String, Integer> entry : counts.entrySet()) {
            ConsoleFilterProvider[] a = new HashMap();
            a.put(ATTR_NAME, entry.getKey());
            a.put(ATTR_VALUE, String.valueOf(entry.getValue()));
            this.startElement(ELEM_COUNT, (Map<String, String>)a);
            this.endElement(ELEM_COUNT);
        }
        Element config = new Element("config");
        try {
            this.myRuntimeConfiguration.writeExternal(config);
            config.setAttribute("configId", this.myRuntimeConfiguration.getType().getId());
            config.setAttribute(ATTR_NAME, this.myRuntimeConfiguration.getName());
            if (!DefaultExecutionTarget.INSTANCE.equals((Object)this.myExecutionTarget)) {
                config.setAttribute("target", this.myExecutionTarget.getId());
            }
        }
        catch (WriteExternalException entry) {
            // empty catch block
        }
        this.processJDomElement(config);
        CompositeFilter f = new CompositeFilter(this.myRuntimeConfiguration.getProject());
        for (ConsoleFilterProvider eachProvider : (ConsoleFilterProvider[])Extensions.getExtensions((ExtensionPointName)ConsoleFilterProvider.FILTER_PROVIDERS)) {
            Filter[] filters;
            for (Filter filter : filters = eachProvider.getDefaultFilters(this.myRuntimeConfiguration.getProject())) {
                f.addFilter(filter);
            }
        }
        if (this.myTestRoot instanceof TestProxyRoot && (presentation = ((TestProxyRoot)((Object)this.myTestRoot)).getPresentation()) != null) {
            String rootLocation;
            LinkedHashMap<String, String> linkedHashMap = new LinkedHashMap<String, String>();
            linkedHashMap.put(ATTR_NAME, presentation);
            String comment = ((TestProxyRoot)((Object)this.myTestRoot)).getComment();
            if (comment != null) {
                linkedHashMap.put("comment", comment);
            }
            if ((rootLocation = ((TestProxyRoot)((Object)this.myTestRoot)).getRootLocation()) != null) {
                linkedHashMap.put("location", rootLocation);
            }
            this.startElement(ROOT_ELEM, linkedHashMap);
            this.writeOutput(this.myTestRoot, (Filter)f);
            this.endElement(ROOT_ELEM);
        }
        if (this.myTestRoot.shouldSkipRootNodeForExport()) {
            for (AbstractTestProxy abstractTestProxy : this.myTestRoot.getChildren()) {
                this.processNode(abstractTestProxy, (Filter)f);
            }
        } else {
            this.processNode(this.myTestRoot, (Filter)f);
        }
        this.endElement(ELEM_RUN);
        this.myResultHandler.endDocument();
    }

    private void processJDomElement(Element config) throws SAXException {
        String name = config.getName();
        LinkedHashMap<String, String> attributes = new LinkedHashMap<String, String>();
        for (Attribute attribute : config.getAttributes()) {
            attributes.put(attribute.getName(), attribute.getValue());
        }
        this.startElement(name, attributes);
        for (Element child : config.getChildren()) {
            this.processJDomElement(child);
        }
        this.endElement(name);
    }

    private static void increment(Map<String, Integer> counts, String status) {
        Integer count = counts.get(status);
        counts.put(status, count != null ? count + 1 : 1);
    }

    private void processNode(AbstractTestProxy node, Filter filter) throws SAXException {
        String elemName;
        String locationUrl;
        ProgressManager.checkCanceled();
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put(ATTR_NAME, node.getName());
        attrs.put(ATTR_STATUS, TestResultsXmlFormatter.getStatusString(node));
        Long duration = node.getDuration();
        if (duration != null) {
            attrs.put(ATTR_DURATION, String.valueOf(duration));
        }
        if ((locationUrl = node.getLocationUrl()) != null) {
            attrs.put(ATTR_LOCATION, locationUrl);
        }
        if (node.isConfig()) {
            attrs.put(ATTR_CONFIG, "true");
        }
        boolean started = false;
        String string = elemName = node.isLeaf() ? ELEM_TEST : ELEM_SUITE;
        if (node.isLeaf()) {
            started = true;
            this.startElement(elemName, attrs);
            this.writeOutput(node, filter);
        } else {
            for (AbstractTestProxy abstractTestProxy : node.getChildren()) {
                if (this.myHidePassedConfig && abstractTestProxy.isConfig() && abstractTestProxy.isPassed()) continue;
                if (!started) {
                    started = true;
                    this.startElement(elemName, attrs);
                }
                this.processNode(abstractTestProxy, filter);
            }
        }
        if (started) {
            this.endElement(elemName);
        }
    }

    private void writeOutput(AbstractTestProxy node, final Filter filter) throws SAXException {
        final StringBuilder buffer = new StringBuilder();
        final Ref lastType = new Ref();
        final Ref error = new Ref();
        final int bufferSize = ConsoleBuffer.useCycleBuffer() ? ConsoleBuffer.getCycleBufferSize() : -1;
        Printer printer = new Printer(){

            @Override
            public void print(String text, ConsoleViewContentType contentType) {
                ProgressManager.checkCanceled();
                if (contentType != lastType.get()) {
                    if (buffer.length() > 0) {
                        try {
                            TestResultsXmlFormatter.this.writeOutput((ConsoleViewContentType)lastType.get(), buffer, filter);
                        }
                        catch (SAXException e) {
                            error.set((Object)e);
                        }
                    }
                    lastType.set((Object)contentType);
                }
                if (bufferSize < 0 || buffer.length() < bufferSize) {
                    buffer.append(text);
                }
            }

            @Override
            public void onNewAvailable(@NotNull Printable printable) {
                if (printable == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "printable", "com/intellij/execution/testframework/export/TestResultsXmlFormatter$2", "onNewAvailable"));
                }
            }

            @Override
            public void printHyperlink(String text, HyperlinkInfo info) {
            }

            @Override
            public void mark() {
            }
        };
        node.printOwnPrintablesOn(printer);
        if (!error.isNull()) {
            throw (SAXException)error.get();
        }
        if (buffer.length() > 0) {
            this.writeOutput((ConsoleViewContentType)lastType.get(), buffer, filter);
        }
    }

    private void writeOutput(ConsoleViewContentType type, StringBuilder text, Filter filter) throws SAXException {
        StringBuilder output = new StringBuilder();
        StringTokenizer t = new StringTokenizer(text.toString(), "\n");
        while (t.hasMoreTokens()) {
            String line = StringUtil.escapeXml((String)t.nextToken()) + "\n";
            Object result = null;
            if (result != null && result.hyperlinkInfo instanceof OpenFileHyperlinkInfo) {
                output.append(line.substring(0, result.highlightStartOffset));
                OpenFileDescriptor descriptor = ((OpenFileHyperlinkInfo)result.hyperlinkInfo).getDescriptor();
                output.append("<a href=\"javascript://\" onclick=\"Activator.doOpen('file?file=");
                output.append(descriptor.getFile().getPresentableUrl());
                output.append("&line=");
                output.append(descriptor.getLine());
                output.append("')\">");
                output.append(line.substring(result.highlightStartOffset, result.highlightEndOffset));
                output.append("</a>");
                output.append(line.substring(result.highlightEndOffset));
                continue;
            }
            output.append(line);
        }
        HashMap<String, String> a = new HashMap<String, String>();
        a.put(ATTR_OUTPUT_TYPE, TestResultsXmlFormatter.getTypeString(type));
        this.startElement(ELEM_OUTPUT, a);
        this.writeText(output.toString());
        text.delete(0, text.length());
        this.endElement(ELEM_OUTPUT);
    }

    private static String getTypeString(ConsoleViewContentType type) {
        return type == ConsoleViewContentType.ERROR_OUTPUT ? "stderr" : "stdout";
    }

    private static String getStatusString(AbstractTestProxy node) {
        int magnitude = node.getMagnitude();
        switch (magnitude) {
            case 0: {
                return STATUS_SKIPPED;
            }
            case 2: 
            case 4: {
                return STATUS_SKIPPED;
            }
            case 5: {
                return STATUS_IGNORED;
            }
            case 1: {
                return STATUS_PASSED;
            }
            case 6: {
                return STATUS_FAILED;
            }
            case 8: {
                return STATUS_ERROR;
            }
        }
        return node.isPassed() ? STATUS_PASSED : STATUS_FAILED;
    }

    private void startElement(String name, Map<String, String> attributes) throws SAXException {
        AttributesImpl attrs = new AttributesImpl();
        for (Map.Entry<String, String> entry : attributes.entrySet()) {
            attrs.addAttribute("", entry.getKey(), entry.getKey(), "CDATA", entry.getValue());
        }
        this.myResultHandler.startElement("", name, name, attrs);
    }

    private void endElement(String name) throws SAXException {
        this.myResultHandler.endElement("", name, name);
    }

    private void writeText(String text) throws SAXException {
        char[] chars = text.toCharArray();
        this.myResultHandler.characters(chars, 0, chars.length);
    }
}

