/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.junit2.segments;

import com.intellij.execution.junit.SegmentedInputStreamReader;
import com.intellij.execution.junit2.SegmentedInputStream;
import com.intellij.execution.junit2.segments.DeferredActionsQueue;
import com.intellij.execution.junit2.segments.DispatchListener;
import com.intellij.execution.junit2.segments.OutputPacketProcessor;
import com.intellij.execution.testframework.Printable;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.EmptyRunnable;
import com.intellij.rt.execution.junit.segments.PacketProcessor;
import com.intellij.util.concurrency.SequentialTaskExecutor;
import java.io.InputStream;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Executor;
import java.util.concurrent.LinkedBlockingQueue;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.ide.PooledThreadExecutor;

public class Extractor
implements Disposable {
    private static final int MAX_TASKS_TO_PROCESS_AT_ONCE = 100;
    private DeferredActionsQueue myFulfilledWorkGate;
    private final SegmentedInputStream myStream;
    private OutputPacketProcessor myEventsDispatcher;
    private static final Logger LOG = Logger.getInstance((String)("#" + Extractor.class.getName()));
    private final SequentialTaskExecutor myExecutor;
    private final BlockingQueue<Runnable> myTaskQueue;

    public Extractor(@NotNull InputStream stream, @NotNull Charset charset) {
        if (stream == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stream", "com/intellij/execution/junit2/segments/Extractor", "<init>"));
        }
        if (charset == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "charset", "com/intellij/execution/junit2/segments/Extractor", "<init>"));
        }
        this.myFulfilledWorkGate = null;
        this.myExecutor = new SequentialTaskExecutor((Executor)PooledThreadExecutor.INSTANCE);
        this.myTaskQueue = new LinkedBlockingQueue<Runnable>();
        this.myStream = new SegmentedInputStream(stream, charset);
    }

    public void setDispatchListener(DispatchListener listener2) {
        this.myFulfilledWorkGate.setDispactchListener(listener2);
    }

    public void dispose() {
        try {
            this.myExecutor.submit(EmptyRunnable.getInstance()).get();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setPacketDispatcher(final @NotNull PacketProcessor packetProcessor, final DeferredActionsQueue queue) {
        if (packetProcessor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "packetProcessor", "com/intellij/execution/junit2/segments/Extractor", "setPacketDispatcher"));
        }
        this.myFulfilledWorkGate = new DeferredActionsQueue(){

            @Override
            public void addLast(Runnable runnable2) {
                Extractor.this.scheduleTask(queue, runnable2);
            }

            @Override
            public void setDispactchListener(DispatchListener listener2) {
                queue.setDispactchListener(listener2);
            }
        };
        this.myEventsDispatcher = new OutputPacketProcessor(){

            public void processPacket(final String packet) {
                Extractor.this.myFulfilledWorkGate.addLast(new Runnable(){

                    @Override
                    public void run() {
                        packetProcessor.processPacket(packet);
                    }
                });
            }

            @Override
            public void processOutput(final Printable printable) {
                LOG.assertTrue(packetProcessor instanceof OutputPacketProcessor);
                Extractor.this.myFulfilledWorkGate.addLast(new Runnable(){

                    @Override
                    public void run() {
                        ((OutputPacketProcessor)packetProcessor).processOutput(printable);
                    }
                });
            }
        };
        this.myStream.setEventsDispatcher(this.myEventsDispatcher);
    }

    private void scheduleTask(final DeferredActionsQueue queue, Runnable task) {
        this.myTaskQueue.add(task);
        this.myExecutor.execute(new Runnable(){

            @Override
            public void run() {
                final ArrayList currentTasks = new ArrayList(100);
                if (Extractor.this.myTaskQueue.drainTo(currentTasks, 100) > 0) {
                    try {
                        SwingUtilities.invokeAndWait(new Runnable(){

                            @Override
                            public void run() {
                                for (Runnable task : currentTasks) {
                                    try {
                                        queue.addLast(task);
                                    }
                                    catch (Throwable e) {
                                        LOG.info(e);
                                    }
                                }
                            }
                        });
                    }
                    catch (Throwable e) {
                        LOG.info("Task rejected: " + currentTasks, e);
                    }
                }
            }
        });
    }

    public OutputPacketProcessor getEventsDispatcher() {
        return this.myEventsDispatcher;
    }

    public Reader createReader() {
        return new SegmentedInputStreamReader(this.myStream);
    }

    public void addRequest(Runnable runnable2, DeferredActionsQueue queue) {
        this.scheduleTask(queue, runnable2);
    }
}

