/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.tools.util;

import com.intellij.diff.util.TextDiffType;
import com.intellij.openapi.diff.DiffBundle;
import com.intellij.ui.EditorNotificationPanel;
import java.awt.Color;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DiffNotifications {
    @Deprecated
    @NotNull
    public static final JPanel INSERTED_CONTENT = DiffNotifications.createInsertedContent();
    @Deprecated
    @NotNull
    public static final JPanel REMOVED_CONTENT = DiffNotifications.createRemovedContent();
    @Deprecated
    @NotNull
    public static final JPanel EQUAL_CONTENTS = DiffNotifications.createEqualContents();
    @Deprecated
    @NotNull
    public static final JPanel ERROR = DiffNotifications.createError();
    @Deprecated
    @NotNull
    public static final JPanel OPERATION_CANCELED = DiffNotifications.createOperationCanceled();
    @Deprecated
    @NotNull
    public static final JPanel DIFF_TOO_BIG = DiffNotifications.createDiffTooBig();

    @NotNull
    public static JPanel createInsertedContent() {
        JPanel jPanel = DiffNotifications.createNotification("Content added", TextDiffType.INSERTED.getColor(null));
        if (jPanel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/util/DiffNotifications", "createInsertedContent"));
        }
        return jPanel;
    }

    @NotNull
    public static JPanel createRemovedContent() {
        JPanel jPanel = DiffNotifications.createNotification("Content removed", TextDiffType.DELETED.getColor(null));
        if (jPanel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/util/DiffNotifications", "createRemovedContent"));
        }
        return jPanel;
    }

    @NotNull
    public static JPanel createEqualContents() {
        JPanel jPanel = DiffNotifications.createNotification(DiffBundle.message((String)"diff.contents.are.identical.message.text", (Object[])new Object[0]));
        if (jPanel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/util/DiffNotifications", "createEqualContents"));
        }
        return jPanel;
    }

    @NotNull
    public static JPanel createError() {
        JPanel jPanel = DiffNotifications.createNotification("Can not calculate diff");
        if (jPanel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/util/DiffNotifications", "createError"));
        }
        return jPanel;
    }

    @NotNull
    public static JPanel createOperationCanceled() {
        JPanel jPanel = DiffNotifications.createNotification("Can not calculate diff. Operation canceled.");
        if (jPanel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/util/DiffNotifications", "createOperationCanceled"));
        }
        return jPanel;
    }

    @NotNull
    public static JPanel createDiffTooBig() {
        JPanel jPanel = DiffNotifications.createNotification("Can not calculate diff. File is too big and there are too many changes.");
        if (jPanel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/util/DiffNotifications", "createDiffTooBig"));
        }
        return jPanel;
    }

    @NotNull
    public static JPanel createNotification(@NotNull String text) {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/diff/tools/util/DiffNotifications", "createNotification"));
        }
        JPanel jPanel = DiffNotifications.createNotification(text, null);
        if (jPanel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/util/DiffNotifications", "createNotification"));
        }
        return jPanel;
    }

    @NotNull
    public static JPanel createNotification(@NotNull String text, @Nullable Color background) {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/diff/tools/util/DiffNotifications", "createNotification"));
        }
        JPanel jPanel = DiffNotifications.createNotification(text, background, true);
        if (jPanel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/util/DiffNotifications", "createNotification"));
        }
        return jPanel;
    }

    @NotNull
    public static JPanel createNotification(@NotNull String text, @Nullable Color background, boolean showHideAction) {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/diff/tools/util/DiffNotifications", "createNotification"));
        }
        final MyEditorNotificationPanel panel = new MyEditorNotificationPanel();
        panel.text(text);
        panel.setBackgroundColor(background);
        if (showHideAction) {
            panel.createActionLabel("Hide", new Runnable(){

                @Override
                public void run() {
                    panel.setVisible(false);
                }
            }).setToolTipText("Hide this notification");
        }
        MyEditorNotificationPanel myEditorNotificationPanel = panel;
        if (myEditorNotificationPanel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/util/DiffNotifications", "createNotification"));
        }
        return myEditorNotificationPanel;
    }

    private static class MyEditorNotificationPanel
    extends EditorNotificationPanel {
        @Nullable
        private Color myBackground;

        private MyEditorNotificationPanel() {
        }

        public void setBackgroundColor(@Nullable Color value) {
            this.myBackground = value;
        }

        @Nullable
        public Color getBackground() {
            return this.myBackground != null ? this.myBackground : super.getBackground();
        }
    }
}

