/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.tools.simple;

import com.intellij.diff.comparison.ComparisonManager;
import com.intellij.diff.comparison.ComparisonPolicy;
import com.intellij.diff.fragments.MergeLineFragment;
import com.intellij.diff.util.DiffUtil;
import com.intellij.diff.util.Side;
import com.intellij.diff.util.TextDiffType;
import com.intellij.diff.util.ThreeSide;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public abstract class ThreesideDiffChangeBase {
    @NotNull
    private ConflictType myType;

    public ThreesideDiffChangeBase(@NotNull MergeLineFragment fragment, @NotNull List<? extends EditorEx> editors, @NotNull ComparisonPolicy policy) {
        if (fragment == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fragment", "com/intellij/diff/tools/simple/ThreesideDiffChangeBase", "<init>"));
        }
        if (editors == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editors", "com/intellij/diff/tools/simple/ThreesideDiffChangeBase", "<init>"));
        }
        if (policy == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "policy", "com/intellij/diff/tools/simple/ThreesideDiffChangeBase", "<init>"));
        }
        List documents = ContainerUtil.map(editors, (Function)new Function<EditorEx, Document>(){

            public Document fun(EditorEx editorEx) {
                return editorEx.getDocument();
            }
        });
        this.myType = ThreesideDiffChangeBase.calcType(fragment, documents, policy);
    }

    public abstract int getStartLine(@NotNull ThreeSide var1);

    public abstract int getEndLine(@NotNull ThreeSide var1);

    @NotNull
    public TextDiffType getDiffType() {
        TextDiffType textDiffType = this.myType.getDiffType();
        if (textDiffType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/simple/ThreesideDiffChangeBase", "getDiffType"));
        }
        return textDiffType;
    }

    @NotNull
    public ConflictType getType() {
        ConflictType conflictType = this.myType;
        if (conflictType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/simple/ThreesideDiffChangeBase", "getType"));
        }
        return conflictType;
    }

    public boolean isConflict() {
        return this.getDiffType() == TextDiffType.CONFLICT;
    }

    public boolean isChange(@NotNull Side side) {
        if (side == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "side", "com/intellij/diff/tools/simple/ThreesideDiffChangeBase", "isChange"));
        }
        return this.myType.isChange(side);
    }

    public boolean isChange(@NotNull ThreeSide side) {
        if (side == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "side", "com/intellij/diff/tools/simple/ThreesideDiffChangeBase", "isChange"));
        }
        switch (side) {
            case LEFT: {
                return this.isChange(Side.LEFT);
            }
            case BASE: {
                return true;
            }
            case RIGHT: {
                return this.isChange(Side.RIGHT);
            }
        }
        throw new IllegalArgumentException(side.toString());
    }

    @NotNull
    public static ConflictType calcType(@NotNull MergeLineFragment fragment, @NotNull List<? extends Document> documents, @NotNull ComparisonPolicy policy) {
        if (fragment == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fragment", "com/intellij/diff/tools/simple/ThreesideDiffChangeBase", "calcType"));
        }
        if (documents == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "documents", "com/intellij/diff/tools/simple/ThreesideDiffChangeBase", "calcType"));
        }
        if (policy == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "policy", "com/intellij/diff/tools/simple/ThreesideDiffChangeBase", "calcType"));
        }
        boolean isLeftEmpty = ThreesideDiffChangeBase.isIntervalEmpty(fragment, ThreeSide.LEFT);
        boolean isBaseEmpty = ThreesideDiffChangeBase.isIntervalEmpty(fragment, ThreeSide.BASE);
        boolean isRightEmpty = ThreesideDiffChangeBase.isIntervalEmpty(fragment, ThreeSide.RIGHT);
        assert (!(isLeftEmpty && isBaseEmpty && isRightEmpty));
        if (isBaseEmpty) {
            if (isLeftEmpty) {
                ConflictType conflictType = new ConflictType(TextDiffType.INSERTED, false, true);
                if (conflictType == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/simple/ThreesideDiffChangeBase", "calcType"));
                }
                return conflictType;
            }
            if (isRightEmpty) {
                ConflictType conflictType = new ConflictType(TextDiffType.INSERTED, true, false);
                if (conflictType == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/simple/ThreesideDiffChangeBase", "calcType"));
                }
                return conflictType;
            }
            boolean equalModifications = ThreesideDiffChangeBase.compareContents(fragment, documents, policy, ThreeSide.LEFT, ThreeSide.RIGHT);
            ConflictType conflictType = new ConflictType(equalModifications ? TextDiffType.INSERTED : TextDiffType.CONFLICT);
            if (conflictType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/simple/ThreesideDiffChangeBase", "calcType"));
            }
            return conflictType;
        }
        if (isLeftEmpty && isRightEmpty) {
            ConflictType conflictType = new ConflictType(TextDiffType.DELETED);
            if (conflictType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/simple/ThreesideDiffChangeBase", "calcType"));
            }
            return conflictType;
        }
        boolean unchangedLeft = ThreesideDiffChangeBase.compareContents(fragment, documents, policy, ThreeSide.BASE, ThreeSide.LEFT);
        boolean unchangedRight = ThreesideDiffChangeBase.compareContents(fragment, documents, policy, ThreeSide.BASE, ThreeSide.RIGHT);
        assert (!unchangedLeft || !unchangedRight);
        if (unchangedLeft) {
            ConflictType conflictType = new ConflictType(isRightEmpty ? TextDiffType.DELETED : TextDiffType.MODIFIED, false, true);
            if (conflictType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/simple/ThreesideDiffChangeBase", "calcType"));
            }
            return conflictType;
        }
        if (unchangedRight) {
            ConflictType conflictType = new ConflictType(isLeftEmpty ? TextDiffType.DELETED : TextDiffType.MODIFIED, true, false);
            if (conflictType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/simple/ThreesideDiffChangeBase", "calcType"));
            }
            return conflictType;
        }
        boolean equalModifications = ThreesideDiffChangeBase.compareContents(fragment, documents, policy, ThreeSide.LEFT, ThreeSide.RIGHT);
        ConflictType conflictType = new ConflictType(equalModifications ? TextDiffType.MODIFIED : TextDiffType.CONFLICT);
        if (conflictType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/simple/ThreesideDiffChangeBase", "calcType"));
        }
        return conflictType;
    }

    private static boolean compareContents(@NotNull MergeLineFragment fragment, @NotNull List<? extends Document> documents, @NotNull ComparisonPolicy policy, @NotNull ThreeSide side1, @NotNull ThreeSide side2) {
        if (fragment == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fragment", "com/intellij/diff/tools/simple/ThreesideDiffChangeBase", "compareContents"));
        }
        if (documents == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "documents", "com/intellij/diff/tools/simple/ThreesideDiffChangeBase", "compareContents"));
        }
        if (policy == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "policy", "com/intellij/diff/tools/simple/ThreesideDiffChangeBase", "compareContents"));
        }
        if (side1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "side1", "com/intellij/diff/tools/simple/ThreesideDiffChangeBase", "compareContents"));
        }
        if (side2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "side2", "com/intellij/diff/tools/simple/ThreesideDiffChangeBase", "compareContents"));
        }
        int start1 = fragment.getStartLine(side1);
        int end1 = fragment.getEndLine(side1);
        int start2 = fragment.getStartLine(side2);
        int end2 = fragment.getEndLine(side2);
        if (end2 - start2 != end1 - start1) {
            return false;
        }
        Document document1 = (Document)side1.select(documents);
        Document document2 = (Document)side2.select(documents);
        for (int i = 0; i < end1 - start1; ++i) {
            int line1 = start1 + i;
            int line2 = start2 + i;
            CharSequence content1 = DiffUtil.getLinesContent(document1, line1, line1 + 1);
            CharSequence content2 = DiffUtil.getLinesContent(document2, line2, line2 + 1);
            if (ComparisonManager.getInstance().isEquals(content1, content2, policy)) continue;
            return false;
        }
        return true;
    }

    private static boolean isIntervalEmpty(@NotNull MergeLineFragment fragment, @NotNull ThreeSide side) {
        if (fragment == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fragment", "com/intellij/diff/tools/simple/ThreesideDiffChangeBase", "isIntervalEmpty"));
        }
        if (side == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "side", "com/intellij/diff/tools/simple/ThreesideDiffChangeBase", "isIntervalEmpty"));
        }
        return fragment.getStartLine(side) == fragment.getEndLine(side);
    }

    public static class ConflictType {
        @NotNull
        private final TextDiffType myType;
        private final boolean myLeftChange;
        private final boolean myRightChange;

        public ConflictType(@NotNull TextDiffType type) {
            if (type == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/diff/tools/simple/ThreesideDiffChangeBase$ConflictType", "<init>"));
            }
            this(type, true, true);
        }

        public ConflictType(@NotNull TextDiffType type, boolean leftChange, boolean rightChange) {
            if (type == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/diff/tools/simple/ThreesideDiffChangeBase$ConflictType", "<init>"));
            }
            this.myType = type;
            this.myLeftChange = leftChange;
            this.myRightChange = rightChange;
        }

        @NotNull
        public TextDiffType getDiffType() {
            TextDiffType textDiffType = this.myType;
            if (textDiffType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/simple/ThreesideDiffChangeBase$ConflictType", "getDiffType"));
            }
            return textDiffType;
        }

        public boolean isLeftChange() {
            return this.myLeftChange;
        }

        public boolean isRightChange() {
            return this.myRightChange;
        }

        public boolean isChange(@NotNull Side side) {
            if (side == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "side", "com/intellij/diff/tools/simple/ThreesideDiffChangeBase$ConflictType", "isChange"));
            }
            return side.isLeft() ? this.myLeftChange : this.myRightChange;
        }
    }
}

