/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.impl;

import com.intellij.diff.DiffRequestPanel;
import com.intellij.diff.impl.DiffRequestProcessor;
import com.intellij.diff.requests.DiffRequest;
import com.intellij.diff.requests.NoDiffRequest;
import com.intellij.diff.util.DiffUserDataKeys;
import com.intellij.diff.util.DiffUserDataKeysEx;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Window;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DiffRequestPanelImpl
implements DiffRequestPanel {
    @NotNull
    private final JPanel myPanel;
    @NotNull
    private final MyDiffRequestProcessor myProcessor;

    public DiffRequestPanelImpl(@Nullable Project project2, @Nullable Window window) {
        this.myProcessor = new MyDiffRequestProcessor(project2, window);
        this.myProcessor.putContextUserData(DiffUserDataKeys.DO_NOT_CHANGE_WINDOW_TITLE, true);
        this.myPanel = new JPanel(new BorderLayout()){

            @Override
            public void addNotify() {
                super.addNotify();
                DiffRequestPanelImpl.this.myProcessor.updateRequest();
            }
        };
        this.myPanel.add(this.myProcessor.getComponent());
    }

    public void setRequest(@Nullable DiffRequest request) {
        this.myProcessor.setRequest(request);
        UIUtil.invokeLaterIfNeeded((Runnable)new Runnable(){

            @Override
            public void run() {
                DiffRequestPanelImpl.this.myProcessor.updateRequest();
            }
        });
    }

    public <T> void putContextHints(@NotNull Key<T> key, @Nullable T value) {
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/diff/impl/DiffRequestPanelImpl", "putContextHints"));
        }
        this.myProcessor.putContextUserData(key, value);
    }

    @NotNull
    public JComponent getComponent() {
        JPanel jPanel = this.myPanel;
        if (jPanel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/impl/DiffRequestPanelImpl", "getComponent"));
        }
        return jPanel;
    }

    @Nullable
    public JComponent getPreferredFocusedComponent() {
        return this.myProcessor.getPreferredFocusedComponent();
    }

    public void dispose() {
        Disposer.dispose((Disposable)this.myProcessor);
    }

    private static class MyDiffRequestProcessor
    extends DiffRequestProcessor {
        @Nullable
        private final Window myWindow;
        @NotNull
        private DiffRequest myRequest = NoDiffRequest.INSTANCE;

        public MyDiffRequestProcessor(@Nullable Project project2, @Nullable Window window) {
            super(project2);
            this.myWindow = window;
        }

        public void setRequest(@Nullable DiffRequest request) {
            this.myRequest = request != null ? request : NoDiffRequest.INSTANCE;
        }

        @Override
        public void updateRequest(boolean force, @Nullable DiffUserDataKeysEx.ScrollToPolicy scrollToChangePolicy) {
            this.applyRequest(this.myRequest, force, scrollToChangePolicy);
        }

        @Override
        protected void setWindowTitle(@NotNull String title) {
            if (title == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "title", "com/intellij/diff/impl/DiffRequestPanelImpl$MyDiffRequestProcessor", "setWindowTitle"));
            }
            if (this.myWindow == null) {
                return;
            }
            if (this.myWindow instanceof JDialog) {
                ((JDialog)this.myWindow).setTitle(title);
            }
            if (this.myWindow instanceof JFrame) {
                ((JFrame)this.myWindow).setTitle(title);
            }
        }
    }
}

