/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff;

import com.intellij.diff.DiffContentFactory;
import com.intellij.diff.DiffRequestFactory;
import com.intellij.diff.InvalidDiffRequestException;
import com.intellij.diff.contents.DiffContent;
import com.intellij.diff.contents.DocumentContent;
import com.intellij.diff.contents.FileAwareDocumentContent;
import com.intellij.diff.contents.FileContent;
import com.intellij.diff.merge.MergeRequest;
import com.intellij.diff.merge.MergeResult;
import com.intellij.diff.merge.TextMergeRequest;
import com.intellij.diff.requests.BinaryMergeRequestImpl;
import com.intellij.diff.requests.ContentDiffRequest;
import com.intellij.diff.requests.SimpleDiffRequest;
import com.intellij.diff.requests.TextMergeRequestImpl;
import com.intellij.diff.util.DiffUtil;
import com.intellij.openapi.diff.DiffBundle;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Consumer;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.vcsUtil.VcsUtil;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DiffRequestFactoryImpl
extends DiffRequestFactory {
    private final DiffContentFactory myContentFactory = DiffContentFactory.getInstance();

    @NotNull
    public ContentDiffRequest createFromFiles(@Nullable Project project2, @NotNull VirtualFile file1, @NotNull VirtualFile file2) {
        if (file1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file1", "com/intellij/diff/DiffRequestFactoryImpl", "createFromFiles"));
        }
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file2", "com/intellij/diff/DiffRequestFactoryImpl", "createFromFiles"));
        }
        DiffContent content1 = this.myContentFactory.create(project2, file1);
        DiffContent content2 = this.myContentFactory.create(project2, file2);
        String title1 = this.getContentTitle(file1);
        String title2 = this.getContentTitle(file2);
        String title = this.getTitle(file1, file2);
        SimpleDiffRequest simpleDiffRequest = new SimpleDiffRequest(title, content1, content2, title1, title2);
        if (simpleDiffRequest == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/DiffRequestFactoryImpl", "createFromFiles"));
        }
        return simpleDiffRequest;
    }

    @NotNull
    public ContentDiffRequest createFromFiles(@Nullable Project project2, @NotNull VirtualFile leftFile, @NotNull VirtualFile baseFile, @NotNull VirtualFile rightFile) {
        if (leftFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "leftFile", "com/intellij/diff/DiffRequestFactoryImpl", "createFromFiles"));
        }
        if (baseFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "baseFile", "com/intellij/diff/DiffRequestFactoryImpl", "createFromFiles"));
        }
        if (rightFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rightFile", "com/intellij/diff/DiffRequestFactoryImpl", "createFromFiles"));
        }
        DiffContent content1 = this.myContentFactory.create(project2, leftFile);
        DiffContent content2 = this.myContentFactory.create(project2, baseFile);
        DiffContent content3 = this.myContentFactory.create(project2, rightFile);
        String title1 = this.getContentTitle(leftFile);
        String title2 = this.getContentTitle(baseFile);
        String title3 = this.getContentTitle(rightFile);
        SimpleDiffRequest simpleDiffRequest = new SimpleDiffRequest(null, content1, content2, content3, title1, title2, title3);
        if (simpleDiffRequest == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/DiffRequestFactoryImpl", "createFromFiles"));
        }
        return simpleDiffRequest;
    }

    @NotNull
    public ContentDiffRequest createClipboardVsValue(@NotNull String value) {
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/diff/DiffRequestFactoryImpl", "createClipboardVsValue"));
        }
        DiffContent content1 = this.myContentFactory.createClipboardContent();
        DocumentContent content2 = this.myContentFactory.create(value);
        String title1 = DiffBundle.message((String)"diff.content.clipboard.content.title", (Object[])new Object[0]);
        String title2 = DiffBundle.message((String)"diff.content.selected.value", (Object[])new Object[0]);
        String title = DiffBundle.message((String)"diff.clipboard.vs.value.dialog.title", (Object[])new Object[0]);
        SimpleDiffRequest simpleDiffRequest = new SimpleDiffRequest(title, content1, (DiffContent)content2, title1, title2);
        if (simpleDiffRequest == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/DiffRequestFactoryImpl", "createClipboardVsValue"));
        }
        return simpleDiffRequest;
    }

    @NotNull
    public String getContentTitle(@NotNull VirtualFile file2) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/diff/DiffRequestFactoryImpl", "getContentTitle"));
        }
        String string = DiffRequestFactoryImpl.getContentTitle(VcsUtil.getFilePath((VirtualFile)file2));
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/DiffRequestFactoryImpl", "getContentTitle"));
        }
        return string;
    }

    @NotNull
    public String getTitle(@NotNull VirtualFile file1, @NotNull VirtualFile file2) {
        if (file1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file1", "com/intellij/diff/DiffRequestFactoryImpl", "getTitle"));
        }
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file2", "com/intellij/diff/DiffRequestFactoryImpl", "getTitle"));
        }
        String string = DiffRequestFactoryImpl.getTitle(VcsUtil.getFilePath((VirtualFile)file1), VcsUtil.getFilePath((VirtualFile)file2), " vs ");
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/DiffRequestFactoryImpl", "getTitle"));
        }
        return string;
    }

    @NotNull
    public String getTitle(@NotNull VirtualFile file2) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/diff/DiffRequestFactoryImpl", "getTitle"));
        }
        String string = this.getTitle(file2, file2);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/DiffRequestFactoryImpl", "getTitle"));
        }
        return string;
    }

    @NotNull
    public static String getContentTitle(@NotNull FilePath path) {
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/diff/DiffRequestFactoryImpl", "getContentTitle"));
        }
        if (path.isDirectory()) {
            String string = path.getPresentableUrl();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/DiffRequestFactoryImpl", "getContentTitle"));
            }
            return string;
        }
        FilePath parent = path.getParentPath();
        String string = DiffRequestFactoryImpl.getContentTitle(path.getName(), path.getPresentableUrl(), parent != null ? parent.getPresentableUrl() : null);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/DiffRequestFactoryImpl", "getContentTitle"));
        }
        return string;
    }

    @NotNull
    public static String getTitle(@NotNull FilePath path1, @NotNull FilePath path2, @NotNull String separator) {
        if (path1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path1", "com/intellij/diff/DiffRequestFactoryImpl", "getTitle"));
        }
        if (path2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path2", "com/intellij/diff/DiffRequestFactoryImpl", "getTitle"));
        }
        if (separator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "separator", "com/intellij/diff/DiffRequestFactoryImpl", "getTitle"));
        }
        if ((path1.isDirectory() || path2.isDirectory()) && path1.getPath().equals(path2.getPath())) {
            String string = path1.getPresentableUrl();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/DiffRequestFactoryImpl", "getTitle"));
            }
            return string;
        }
        String name1 = path1.getName();
        String name2 = path2.getName();
        if (path1.isDirectory() ^ path2.isDirectory()) {
            if (path1.isDirectory()) {
                name1 = name1 + File.separatorChar;
            }
            if (path2.isDirectory()) {
                name2 = name2 + File.separatorChar;
            }
        }
        FilePath parent1 = path1.getParentPath();
        FilePath parent2 = path2.getParentPath();
        String string = DiffRequestFactoryImpl.getRequestTitle(name1, path1.getPresentableUrl(), parent1 != null ? parent1.getPresentableUrl() : null, name2, path2.getPresentableUrl(), parent2 != null ? parent2.getPresentableUrl() : null, separator);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/DiffRequestFactoryImpl", "getTitle"));
        }
        return string;
    }

    @NotNull
    private static String getContentTitle(@NotNull String name, @NotNull String path, @Nullable String parentPath) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/diff/DiffRequestFactoryImpl", "getContentTitle"));
        }
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/diff/DiffRequestFactoryImpl", "getContentTitle"));
        }
        if (parentPath != null) {
            String string = name + " (" + parentPath + ")";
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/DiffRequestFactoryImpl", "getContentTitle"));
            }
            return string;
        }
        String string = path;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/DiffRequestFactoryImpl", "getContentTitle"));
        }
        return string;
    }

    @NotNull
    private static String getRequestTitle(@NotNull String name1, @NotNull String path1, @Nullable String parentPath1, @NotNull String name2, @NotNull String path2, @Nullable String parentPath2, @NotNull String sep) {
        if (name1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name1", "com/intellij/diff/DiffRequestFactoryImpl", "getRequestTitle"));
        }
        if (path1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path1", "com/intellij/diff/DiffRequestFactoryImpl", "getRequestTitle"));
        }
        if (name2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name2", "com/intellij/diff/DiffRequestFactoryImpl", "getRequestTitle"));
        }
        if (path2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path2", "com/intellij/diff/DiffRequestFactoryImpl", "getRequestTitle"));
        }
        if (sep == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sep", "com/intellij/diff/DiffRequestFactoryImpl", "getRequestTitle"));
        }
        if (path1.equals(path2)) {
            String string = DiffRequestFactoryImpl.getContentTitle(name1, path1, parentPath1);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/DiffRequestFactoryImpl", "getRequestTitle"));
            }
            return string;
        }
        if (Comparing.equal((String)parentPath1, (String)parentPath2)) {
            if (parentPath1 != null) {
                String string = name1 + sep + name2 + " (" + parentPath1 + ")";
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/DiffRequestFactoryImpl", "getRequestTitle"));
                }
                return string;
            }
            String string = path1 + sep + path2;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/DiffRequestFactoryImpl", "getRequestTitle"));
            }
            return string;
        }
        if (name1.equals(name2)) {
            if (parentPath1 != null && parentPath2 != null) {
                String string = name1 + " (" + parentPath1 + sep + parentPath2 + ")";
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/DiffRequestFactoryImpl", "getRequestTitle"));
                }
                return string;
            }
            String string = path1 + sep + path2;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/DiffRequestFactoryImpl", "getRequestTitle"));
            }
            return string;
        }
        if (parentPath1 != null && parentPath2 != null) {
            String string = name1 + sep + name2 + " (" + parentPath1 + sep + parentPath2 + ")";
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/DiffRequestFactoryImpl", "getRequestTitle"));
            }
            return string;
        }
        String string = path1 + sep + path2;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/DiffRequestFactoryImpl", "getRequestTitle"));
        }
        return string;
    }

    @NotNull
    public MergeRequest createMergeRequest(@Nullable Project project2, @Nullable FileType fileType, @NotNull Document outputDocument, @NotNull List<String> textContents, @Nullable String title, @NotNull List<String> titles, @Nullable Consumer<MergeResult> applyCallback) throws InvalidDiffRequestException {
        if (outputDocument == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "outputDocument", "com/intellij/diff/DiffRequestFactoryImpl", "createMergeRequest"));
        }
        if (textContents == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "textContents", "com/intellij/diff/DiffRequestFactoryImpl", "createMergeRequest"));
        }
        if (titles == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "titles", "com/intellij/diff/DiffRequestFactoryImpl", "createMergeRequest"));
        }
        if (textContents.size() != 3) {
            throw new IllegalArgumentException();
        }
        if (titles.size() != 3) {
            throw new IllegalArgumentException();
        }
        if (!DiffUtil.canMakeWritable(outputDocument)) {
            throw new InvalidDiffRequestException("Output is read only");
        }
        DocumentContent outputContent = this.myContentFactory.create(project2, outputDocument, fileType);
        CharSequence originalContent = outputDocument.getImmutableCharSequence();
        ArrayList<DocumentContent> contents = new ArrayList<DocumentContent>(3);
        for (String text : textContents) {
            contents.add(this.myContentFactory.create(text, fileType));
        }
        TextMergeRequestImpl textMergeRequestImpl = new TextMergeRequestImpl(project2, outputContent, originalContent, contents, title, titles, applyCallback);
        if (textMergeRequestImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/DiffRequestFactoryImpl", "createMergeRequest"));
        }
        return textMergeRequestImpl;
    }

    @NotNull
    public MergeRequest createMergeRequest(@Nullable Project project2, @NotNull VirtualFile output, @NotNull List<byte[]> byteContents, @Nullable String title, @NotNull List<String> contentTitles, @Nullable Consumer<MergeResult> applyCallback) throws InvalidDiffRequestException {
        TextMergeRequest textMergeRequest;
        if (output == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "output", "com/intellij/diff/DiffRequestFactoryImpl", "createMergeRequest"));
        }
        if (byteContents == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "byteContents", "com/intellij/diff/DiffRequestFactoryImpl", "createMergeRequest"));
        }
        if (contentTitles == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "contentTitles", "com/intellij/diff/DiffRequestFactoryImpl", "createMergeRequest"));
        }
        if (byteContents.size() != 3) {
            throw new IllegalArgumentException();
        }
        if (contentTitles.size() != 3) {
            throw new IllegalArgumentException();
        }
        try {
            textMergeRequest = this.createTextMergeRequest(project2, output, byteContents, title, contentTitles, applyCallback);
        }
        catch (InvalidDiffRequestException e) {
            MergeRequest mergeRequest = this.createBinaryMergeRequest(project2, output, byteContents, title, contentTitles, applyCallback);
            if (mergeRequest == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/DiffRequestFactoryImpl", "createMergeRequest"));
            }
            return mergeRequest;
        }
        if (textMergeRequest == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/DiffRequestFactoryImpl", "createMergeRequest"));
        }
        return textMergeRequest;
    }

    @NotNull
    public TextMergeRequest createTextMergeRequest(@Nullable Project project2, @NotNull VirtualFile output, @NotNull List<byte[]> byteContents, @Nullable String title, @NotNull List<String> contentTitles, @Nullable Consumer<MergeResult> applyCallback) throws InvalidDiffRequestException {
        if (output == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "output", "com/intellij/diff/DiffRequestFactoryImpl", "createTextMergeRequest"));
        }
        if (byteContents == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "byteContents", "com/intellij/diff/DiffRequestFactoryImpl", "createTextMergeRequest"));
        }
        if (contentTitles == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "contentTitles", "com/intellij/diff/DiffRequestFactoryImpl", "createTextMergeRequest"));
        }
        if (byteContents.size() != 3) {
            throw new IllegalArgumentException();
        }
        if (contentTitles.size() != 3) {
            throw new IllegalArgumentException();
        }
        Document outputDocument = FileDocumentManager.getInstance().getDocument(output);
        if (outputDocument == null) {
            throw new InvalidDiffRequestException("Can't get output document: " + output.getPresentableUrl());
        }
        if (!DiffUtil.canMakeWritable(outputDocument)) {
            throw new InvalidDiffRequestException("Output is read only: " + output.getPresentableUrl());
        }
        DocumentContent outputContent = this.myContentFactory.create(project2, outputDocument);
        CharSequence originalContent = outputDocument.getImmutableCharSequence();
        ArrayList<DocumentContent> contents = new ArrayList<DocumentContent>(3);
        for (byte[] bytes : byteContents) {
            contents.add(FileAwareDocumentContent.create(project2, bytes, output));
        }
        TextMergeRequestImpl textMergeRequestImpl = new TextMergeRequestImpl(project2, outputContent, originalContent, contents, title, contentTitles, applyCallback);
        if (textMergeRequestImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/DiffRequestFactoryImpl", "createTextMergeRequest"));
        }
        return textMergeRequestImpl;
    }

    @NotNull
    public MergeRequest createBinaryMergeRequest(@Nullable Project project2, @NotNull VirtualFile output, @NotNull List<byte[]> byteContents, @Nullable String title, @NotNull List<String> contentTitles, @Nullable Consumer<MergeResult> applyCallback) throws InvalidDiffRequestException {
        BinaryMergeRequestImpl binaryMergeRequestImpl;
        block9: {
            if (output == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "output", "com/intellij/diff/DiffRequestFactoryImpl", "createBinaryMergeRequest"));
            }
            if (byteContents == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "byteContents", "com/intellij/diff/DiffRequestFactoryImpl", "createBinaryMergeRequest"));
            }
            if (contentTitles == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "contentTitles", "com/intellij/diff/DiffRequestFactoryImpl", "createBinaryMergeRequest"));
            }
            if (byteContents.size() != 3) {
                throw new IllegalArgumentException();
            }
            if (contentTitles.size() != 3) {
                throw new IllegalArgumentException();
            }
            try {
                FileContent outputContent = this.myContentFactory.createFile(project2, output);
                if (outputContent == null) {
                    throw new InvalidDiffRequestException("Can't create output content: " + output);
                }
                byte[] originalContent = output.contentsToByteArray();
                ArrayList<DiffContent> contents = new ArrayList<DiffContent>(3);
                for (byte[] bytes : byteContents) {
                    contents.add(this.myContentFactory.createFromBytes(project2, output, bytes));
                }
                binaryMergeRequestImpl = new BinaryMergeRequestImpl(project2, outputContent, originalContent, contents, byteContents, title, contentTitles, applyCallback);
                if (binaryMergeRequestImpl != null) break block9;
            }
            catch (IOException e) {
                throw new InvalidDiffRequestException("Can't read from file", (Throwable)e);
            }
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/DiffRequestFactoryImpl", "createBinaryMergeRequest"));
        }
        return binaryMergeRequestImpl;
    }

    @NotNull
    public MergeRequest createMergeRequestFromFiles(@Nullable Project project2, @NotNull VirtualFile output, @NotNull List<VirtualFile> fileContents, @Nullable Consumer<MergeResult> applyCallback) throws InvalidDiffRequestException {
        if (output == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "output", "com/intellij/diff/DiffRequestFactoryImpl", "createMergeRequestFromFiles"));
        }
        if (fileContents == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileContents", "com/intellij/diff/DiffRequestFactoryImpl", "createMergeRequestFromFiles"));
        }
        String title = "Merge " + output.getPresentableUrl();
        List titles = ContainerUtil.list((Object[])new String[]{"Your Version", "Base Version", "Their Version"});
        MergeRequest mergeRequest = this.createMergeRequestFromFiles(project2, output, fileContents, title, titles, applyCallback);
        if (mergeRequest == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/DiffRequestFactoryImpl", "createMergeRequestFromFiles"));
        }
        return mergeRequest;
    }

    @NotNull
    public MergeRequest createMergeRequestFromFiles(@Nullable Project project2, @NotNull VirtualFile output, @NotNull List<VirtualFile> fileContents, @Nullable String title, @NotNull List<String> contentTitles, @Nullable Consumer<MergeResult> applyCallback) throws InvalidDiffRequestException {
        TextMergeRequest textMergeRequest;
        if (output == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "output", "com/intellij/diff/DiffRequestFactoryImpl", "createMergeRequestFromFiles"));
        }
        if (fileContents == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileContents", "com/intellij/diff/DiffRequestFactoryImpl", "createMergeRequestFromFiles"));
        }
        if (contentTitles == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "contentTitles", "com/intellij/diff/DiffRequestFactoryImpl", "createMergeRequestFromFiles"));
        }
        if (fileContents.size() != 3) {
            throw new IllegalArgumentException();
        }
        if (contentTitles.size() != 3) {
            throw new IllegalArgumentException();
        }
        try {
            textMergeRequest = this.createTextMergeRequestFromFiles(project2, output, fileContents, title, contentTitles, applyCallback);
        }
        catch (InvalidDiffRequestException e) {
            MergeRequest mergeRequest = this.createBinaryMergeRequestFromFiles(project2, output, fileContents, title, contentTitles, applyCallback);
            if (mergeRequest == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/DiffRequestFactoryImpl", "createMergeRequestFromFiles"));
            }
            return mergeRequest;
        }
        if (textMergeRequest == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/DiffRequestFactoryImpl", "createMergeRequestFromFiles"));
        }
        return textMergeRequest;
    }

    @NotNull
    public TextMergeRequest createTextMergeRequestFromFiles(@Nullable Project project2, @NotNull VirtualFile output, @NotNull List<VirtualFile> fileContents, @Nullable String title, @NotNull List<String> contentTitles, @Nullable Consumer<MergeResult> applyCallback) throws InvalidDiffRequestException {
        if (output == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "output", "com/intellij/diff/DiffRequestFactoryImpl", "createTextMergeRequestFromFiles"));
        }
        if (fileContents == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileContents", "com/intellij/diff/DiffRequestFactoryImpl", "createTextMergeRequestFromFiles"));
        }
        if (contentTitles == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "contentTitles", "com/intellij/diff/DiffRequestFactoryImpl", "createTextMergeRequestFromFiles"));
        }
        if (fileContents.size() != 3) {
            throw new IllegalArgumentException();
        }
        if (contentTitles.size() != 3) {
            throw new IllegalArgumentException();
        }
        Document outputDocument = FileDocumentManager.getInstance().getDocument(output);
        if (outputDocument == null) {
            throw new InvalidDiffRequestException("Can't get output document: " + output.getPresentableUrl());
        }
        if (!DiffUtil.canMakeWritable(outputDocument)) {
            throw new InvalidDiffRequestException("Output is read only: " + output.getPresentableUrl());
        }
        DocumentContent outputContent = this.myContentFactory.create(project2, outputDocument);
        CharSequence originalContent = outputDocument.getImmutableCharSequence();
        ArrayList<DocumentContent> contents = new ArrayList<DocumentContent>(3);
        for (VirtualFile file2 : fileContents) {
            DocumentContent document = this.myContentFactory.createDocument(project2, file2);
            if (document == null) {
                throw new InvalidDiffRequestException("Can't get text content: " + file2.getPresentableUrl());
            }
            contents.add(document);
        }
        TextMergeRequestImpl textMergeRequestImpl = new TextMergeRequestImpl(project2, outputContent, originalContent, contents, title, contentTitles, applyCallback);
        if (textMergeRequestImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/DiffRequestFactoryImpl", "createTextMergeRequestFromFiles"));
        }
        return textMergeRequestImpl;
    }

    @NotNull
    public MergeRequest createBinaryMergeRequestFromFiles(@Nullable Project project2, @NotNull VirtualFile output, @NotNull List<VirtualFile> fileContents, @Nullable String title, @NotNull List<String> contentTitles, @Nullable Consumer<MergeResult> applyCallback) throws InvalidDiffRequestException {
        BinaryMergeRequestImpl binaryMergeRequestImpl;
        block10: {
            if (output == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "output", "com/intellij/diff/DiffRequestFactoryImpl", "createBinaryMergeRequestFromFiles"));
            }
            if (fileContents == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileContents", "com/intellij/diff/DiffRequestFactoryImpl", "createBinaryMergeRequestFromFiles"));
            }
            if (contentTitles == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "contentTitles", "com/intellij/diff/DiffRequestFactoryImpl", "createBinaryMergeRequestFromFiles"));
            }
            if (fileContents.size() != 3) {
                throw new IllegalArgumentException();
            }
            if (contentTitles.size() != 3) {
                throw new IllegalArgumentException();
            }
            try {
                FileContent outputContent = this.myContentFactory.createFile(project2, output);
                if (outputContent == null) {
                    throw new InvalidDiffRequestException("Can't create output content: " + output.getPresentableUrl());
                }
                byte[] originalContent = output.contentsToByteArray();
                ArrayList<DiffContent> contents = new ArrayList<DiffContent>(3);
                ArrayList<byte[]> byteContents = new ArrayList<byte[]>(3);
                for (VirtualFile file2 : fileContents) {
                    FileContent content = this.myContentFactory.createFile(project2, file2);
                    if (content == null) {
                        throw new InvalidDiffRequestException("Can't create content: " + file2.getPresentableUrl());
                    }
                    contents.add((DiffContent)content);
                    byteContents.add(file2.contentsToByteArray());
                }
                binaryMergeRequestImpl = new BinaryMergeRequestImpl(project2, outputContent, originalContent, contents, byteContents, title, contentTitles, applyCallback);
                if (binaryMergeRequestImpl != null) break block10;
            }
            catch (IOException e) {
                throw new InvalidDiffRequestException("Can't read from file", (Throwable)e);
            }
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/DiffRequestFactoryImpl", "createBinaryMergeRequestFromFiles"));
        }
        return binaryMergeRequestImpl;
    }
}

