/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diagnostic.logging;

import com.intellij.execution.CommonProgramRunConfigurationParameters;
import com.intellij.execution.configurations.RunConfigurationBase;
import com.intellij.execution.filters.Filter;
import com.intellij.execution.filters.HyperlinkInfo;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.process.ProcessOutputTypes;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.execution.ui.ExecutionConsole;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.PrintStream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OutputFileUtil {
    private static final String CONSOLE_OUTPUT_FILE_MESSAGE = "Console output is saving to: ";

    private OutputFileUtil() {
    }

    public static File getOutputFile(@NotNull RunConfigurationBase configuration) {
        if (configuration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configuration", "com/intellij/diagnostic/logging/OutputFileUtil", "getOutputFile"));
        }
        String outputFilePath = configuration.getOutputFilePath();
        if (outputFilePath != null) {
            String directory;
            String filePath = FileUtil.toSystemDependentName((String)outputFilePath);
            File file2 = new File(filePath);
            if (configuration instanceof CommonProgramRunConfigurationParameters && !FileUtil.isAbsolute((String)filePath) && (directory = ((CommonProgramRunConfigurationParameters)configuration).getWorkingDirectory()) != null) {
                file2 = new File(new File(directory), filePath);
            }
            return file2;
        }
        return null;
    }

    public static void attachDumpListener(final @NotNull RunConfigurationBase configuration, final @NotNull ProcessHandler startedProcess, @Nullable ExecutionConsole console) {
        if (configuration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configuration", "com/intellij/diagnostic/logging/OutputFileUtil", "attachDumpListener"));
        }
        if (startedProcess == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "startedProcess", "com/intellij/diagnostic/logging/OutputFileUtil", "attachDumpListener"));
        }
        if (!configuration.isSaveOutputToFile()) {
            return;
        }
        final File file2 = OutputFileUtil.getOutputFile(configuration);
        if (file2 != null) {
            startedProcess.addProcessListener((ProcessListener)new ProcessAdapter(){
                private PrintStream myOutput;

                public void onTextAvailable(ProcessEvent event, Key outputType) {
                    if (configuration.collectOutputFromProcessHandler() && this.myOutput != null && outputType != ProcessOutputTypes.SYSTEM) {
                        this.myOutput.print(event.getText());
                    }
                }

                public void startNotified(ProcessEvent event) {
                    try {
                        this.myOutput = new PrintStream(new FileOutputStream(file2));
                    }
                    catch (FileNotFoundException fileNotFoundException) {
                        // empty catch block
                    }
                    startedProcess.notifyTextAvailable(OutputFileUtil.CONSOLE_OUTPUT_FILE_MESSAGE + FileUtil.toSystemDependentName((String)file2.getAbsolutePath()) + "\n", ProcessOutputTypes.SYSTEM);
                }

                public void processTerminated(ProcessEvent event) {
                    startedProcess.removeProcessListener((ProcessListener)this);
                    if (this.myOutput != null) {
                        this.myOutput.close();
                    }
                }
            });
            if (console instanceof ConsoleView) {
                ((ConsoleView)console).addMessageFilter((Filter)new ShowOutputFileFilter());
            }
        }
    }

    private static class ShowOutputFileFilter
    implements Filter {
        private ShowOutputFileFilter() {
        }

        public Filter.Result applyFilter(String line, int entireLength) {
            if (line.startsWith(OutputFileUtil.CONSOLE_OUTPUT_FILE_MESSAGE)) {
                final String filePath = StringUtil.trimEnd((String)line.substring(OutputFileUtil.CONSOLE_OUTPUT_FILE_MESSAGE.length()), (String)"\n");
                return new Filter.Result(entireLength - filePath.length() - 1, entireLength, new HyperlinkInfo(){

                    public void navigate(final Project project2) {
                        final VirtualFile file2 = (VirtualFile)ApplicationManager.getApplication().runWriteAction((Computable)new Computable<VirtualFile>(){

                            @Nullable
                            public VirtualFile compute() {
                                return LocalFileSystem.getInstance().refreshAndFindFileByPath(FileUtil.toSystemIndependentName((String)filePath));
                            }
                        });
                        if (file2 != null) {
                            file2.refresh(false, false);
                            ApplicationManager.getApplication().runReadAction(new Runnable(){

                                @Override
                                public void run() {
                                    FileEditorManager.getInstance((Project)project2).openTextEditor(new OpenFileDescriptor(project2, file2), true);
                                }
                            });
                        }
                    }
                });
            }
            return null;
        }
    }
}

