/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diagnostic;

import com.intellij.diagnostic.DebugLogManagerKt;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.components.ApplicationComponent;
import com.intellij.openapi.util.text.StringUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.apache.log4j.Level;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 0}, bv={1, 0, 0}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\n\u0018\u00002\u00020\u0001:\u0001\u0015B\u0005\u00a2\u0006\u0002\u0010\u0002J \u0010\u0003\u001a\u00020\u00042\u0018\u0010\u0005\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u00070\u0006J2\u0010\u0003\u001a\u00020\u00042\u0018\u0010\u0005\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u00070\u00062\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\fH\u0002J4\u0010\r\u001a\u001c\u0012\u0018\u0012\u0016\u0012\f\u0012\n \u000e*\u0004\u0018\u00010\b0\b\u0012\u0004\u0012\u00020\t0\u00070\u00062\b\u0010\u000f\u001a\u0004\u0018\u00010\b2\u0006\u0010\n\u001a\u00020\tH\u0002J\u001a\u0010\u0010\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u00070\u0006H\u0002J\u0018\u0010\u0011\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u00070\u0006J\b\u0010\u0012\u001a\u00020\u0004H\u0016J \u0010\u0013\u001a\u00020\u00042\u0018\u0010\u0005\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u00070\u0006J,\u0010\u0014\u001a\u0004\u0018\u00010\b2\u0018\u0010\u0005\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u00070\u00062\u0006\u0010\n\u001a\u00020\tH\u0002\u00a8\u0006\u0016"}, d2={"Lcom/intellij/diagnostic/DebugLogManager;", "Lcom/intellij/openapi/components/ApplicationComponent$Adapter;", "()V", "applyCategories", "", "categories", "", "Lkotlin/Pair;", "", "Lcom/intellij/diagnostic/DebugLogManager$DebugLogLevel;", "level", "log4jLevel", "Lorg/apache/log4j/Level;", "fromString", "kotlin.jvm.PlatformType", "text", "getCurrentCategories", "getSavedCategories", "initComponent", "saveCategories", "toString", "DebugLogLevel", "platform-impl"})
public final class DebugLogManager
extends ApplicationComponent.Adapter {
    @NotNull
    public final List<Pair<String, DebugLogLevel>> getSavedCategories() {
        PropertiesComponent properties = PropertiesComponent.getInstance();
        return CollectionsKt.plus((Collection)this.fromString(properties.getValue(DebugLogManagerKt.access$getLOG_DEBUG_CATEGORIES$p()), DebugLogLevel.DEBUG), (Iterable)this.fromString(properties.getValue(DebugLogManagerKt.access$getLOG_TRACE_CATEGORIES$p()), DebugLogLevel.TRACE));
    }

    public void initComponent() {
        List<Pair<String, DebugLogLevel>> categories = this.getSavedCategories();
        if (categories.isEmpty()) {
            this.saveCategories(this.getCurrentCategories());
        } else {
            this.applyCategories(categories);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final List<Pair<String, DebugLogLevel>> fromString(String text, DebugLogLevel level) {
        List list;
        if (text != null) {
            void destination$iv$iv;
            void $receiver$iv$iv;
            Object[] $receiver$iv = StringUtil.splitByLines((String)text, (boolean)true);
            Object[] objectArray = $receiver$iv;
            Collection collection = new ArrayList($receiver$iv.length);
            for (int i = 0; i < ((void)$receiver$iv$iv).length; ++i) {
                void it;
                void item$iv$iv = $receiver$iv$iv[i];
                String string = (String)item$iv$iv;
                void var12_9 = destination$iv$iv;
                Pair pair = new Pair((Object)it, (Object)level);
                var12_9.add(pair);
            }
            list = CollectionsKt.toList((Iterable)((List)destination$iv$iv));
        } else {
            list = CollectionsKt.emptyList();
        }
        return list;
    }

    public final void applyCategories(@NotNull List<? extends Pair<String, ? extends DebugLogLevel>> categories) {
        Intrinsics.checkParameterIsNotNull(categories, (String)"categories");
        Level level = Level.DEBUG;
        Intrinsics.checkExpressionValueIsNotNull((Object)level, (String)"Level.DEBUG");
        this.applyCategories(categories, DebugLogLevel.DEBUG, level);
        Level level2 = Level.TRACE;
        Intrinsics.checkExpressionValueIsNotNull((Object)level2, (String)"Level.TRACE");
        this.applyCategories(categories, DebugLogLevel.TRACE, level2);
    }

    private final void applyCategories(List<? extends Pair<String, ? extends DebugLogLevel>> categories, DebugLogLevel level, Level log4jLevel) {
        Collection destination$iv$iv;
        Pair it;
        Iterable $receiver$iv$iv;
        Iterable $receiver$iv;
        Iterable iterable = categories;
        Iterator iterator = $receiver$iv;
        Collection collection = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv) {
            it = (Pair)element$iv$iv;
            if (!Intrinsics.areEqual((Object)((Object)((DebugLogLevel)((Object)it.getSecond()))), (Object)((Object)level))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $receiver$iv = (List)destination$iv$iv;
        $receiver$iv$iv = $receiver$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            it = (Pair)item$iv$iv;
            Collection collection2 = destination$iv$iv;
            String string = (String)it.getFirst();
            collection2.add(string);
        }
        List filtered = (List)destination$iv$iv;
        $receiver$iv = filtered;
        for (Object element$iv : $receiver$iv) {
            String it2 = (String)element$iv;
            Logger logger = LogManager.getLogger((String)it2);
            if (logger == null) continue;
            logger.setLevel(log4jLevel);
        }
        if (!filtered.isEmpty()) {
            DebugLogManagerKt.access$getLOG$p().info("Set " + level.name() + " for the following categories: " + CollectionsKt.joinToString$default((Iterable)filtered, null, null, null, (int)0, null, null, (int)63, null));
        }
    }

    public final void saveCategories(@NotNull List<? extends Pair<String, ? extends DebugLogLevel>> categories) {
        Intrinsics.checkParameterIsNotNull(categories, (String)"categories");
        PropertiesComponent.getInstance().setValue(DebugLogManagerKt.access$getLOG_DEBUG_CATEGORIES$p(), this.toString(categories, DebugLogLevel.DEBUG), (String)null);
        PropertiesComponent.getInstance().setValue(DebugLogManagerKt.access$getLOG_TRACE_CATEGORIES$p(), this.toString(categories, DebugLogLevel.TRACE), (String)null);
    }

    private final String toString(List<? extends Pair<String, ? extends DebugLogLevel>> categories, DebugLogLevel level) {
        Collection destination$iv$iv;
        Pair it;
        Iterable $receiver$iv$iv;
        Iterable $receiver$iv;
        Iterable iterable = categories;
        void var5_4 = $receiver$iv;
        Collection collection = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv) {
            it = (Pair)element$iv$iv;
            if (!Intrinsics.areEqual((Object)((Object)((DebugLogLevel)((Object)it.getSecond()))), (Object)((Object)level))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $receiver$iv = (List)destination$iv$iv;
        $receiver$iv$iv = $receiver$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            it = (Pair)item$iv$iv;
            Collection collection2 = destination$iv$iv;
            String string = (String)it.getFirst();
            collection2.add(string);
        }
        List filtered = (List)destination$iv$iv;
        $receiver$iv = filtered;
        return !$receiver$iv.isEmpty() ? CollectionsKt.joinToString$default((Iterable)filtered, (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null) : (String)null;
    }

    /*
     * WARNING - void declaration
     */
    private final List<Pair<String, DebugLogLevel>> getCurrentCategories() {
        void destination$iv$iv;
        void $receiver$iv$iv;
        Object $receiver$iv = LogManager.getCurrentLoggers();
        List list = Collections.list($receiver$iv);
        Intrinsics.checkExpressionValueIsNotNull((Object)list, (String)"Collections.list(this)");
        List currentLoggers = CollectionsKt.filterIsInstance((Iterable)list, Logger.class);
        $receiver$iv = currentLoggers;
        Object $i$f$toList = $receiver$iv;
        Collection collection = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            void it;
            Logger logger = (Logger)item$iv$iv;
            void var13_10 = destination$iv$iv;
            String category = it.getName();
            com.intellij.openapi.diagnostic.Logger logger2 = com.intellij.openapi.diagnostic.Logger.getInstance((String)category);
            Pair pair = logger2.isTraceEnabled() ? new Pair((Object)category, (Object)DebugLogLevel.TRACE) : (logger2.isDebugEnabled() ? new Pair((Object)category, (Object)DebugLogLevel.DEBUG) : (Pair)null);
            var13_10.add(pair);
        }
        return CollectionsKt.filterNotNull((Iterable)((List)destination$iv$iv));
    }

    @Metadata(mv={1, 1, 0}, bv={1, 0, 0}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0004\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004\u00a8\u0006\u0005"}, d2={"Lcom/intellij/diagnostic/DebugLogManager$DebugLogLevel;", "", "(Ljava/lang/String;I)V", "DEBUG", "TRACE", "platform-impl"})
    public static final class DebugLogLevel
    extends Enum<DebugLogLevel> {
        public static final /* enum */ DebugLogLevel DEBUG;
        public static final /* enum */ DebugLogLevel TRACE;
        private static final /* synthetic */ DebugLogLevel[] $VALUES;

        static {
            DebugLogLevel[] debugLogLevelArray = new DebugLogLevel[2];
            DebugLogLevel[] debugLogLevelArray2 = debugLogLevelArray;
            debugLogLevelArray[0] = DEBUG = new DebugLogLevel();
            debugLogLevelArray[1] = TRACE = new DebugLogLevel();
            $VALUES = debugLogLevelArray;
        }

        public static DebugLogLevel[] values() {
            return (DebugLogLevel[])$VALUES.clone();
        }

        public static DebugLogLevel valueOf(String string) {
            return Enum.valueOf(DebugLogLevel.class, string);
        }
    }
}

