/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.engine;

import com.intellij.debugger.DebuggerBundle;
import com.intellij.debugger.DebuggerInvocationUtil;
import com.intellij.debugger.DebuggerManagerEx;
import com.intellij.debugger.engine.DebugProcess;
import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.DebugProcessListener;
import com.intellij.debugger.engine.DebuggerManagerThreadImpl;
import com.intellij.debugger.engine.MethodFilter;
import com.intellij.debugger.engine.NamedMethodFilter;
import com.intellij.debugger.engine.RequestHint;
import com.intellij.debugger.engine.SuspendContextImpl;
import com.intellij.debugger.engine.SuspendManager;
import com.intellij.debugger.engine.SuspendManagerUtil;
import com.intellij.debugger.engine.events.DebuggerCommandImpl;
import com.intellij.debugger.engine.events.SuspendContextCommandImpl;
import com.intellij.debugger.engine.requests.LocatableEventRequestor;
import com.intellij.debugger.engine.requests.MethodReturnValueWatcher;
import com.intellij.debugger.impl.DebuggerSession;
import com.intellij.debugger.impl.PrioritizedTask;
import com.intellij.debugger.jdi.ThreadReferenceProxyImpl;
import com.intellij.debugger.jdi.VirtualMachineProxyImpl;
import com.intellij.debugger.requests.Requestor;
import com.intellij.debugger.ui.breakpoints.Breakpoint;
import com.intellij.debugger.ui.breakpoints.LineBreakpoint;
import com.intellij.execution.configurations.RemoteConnection;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Pair;
import com.intellij.ui.classFilter.ClassFilter;
import com.intellij.util.Consumer;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.breakpoints.XBreakpoint;
import com.intellij.xdebugger.impl.XDebugSessionImpl;
import com.sun.jdi.InternalException;
import com.sun.jdi.ThreadReference;
import com.sun.jdi.VMDisconnectedException;
import com.sun.jdi.VirtualMachine;
import com.sun.jdi.event.ClassPrepareEvent;
import com.sun.jdi.event.ClassUnloadEvent;
import com.sun.jdi.event.Event;
import com.sun.jdi.event.EventQueue;
import com.sun.jdi.event.EventSet;
import com.sun.jdi.event.LocatableEvent;
import com.sun.jdi.event.StepEvent;
import com.sun.jdi.event.ThreadDeathEvent;
import com.sun.jdi.event.ThreadStartEvent;
import com.sun.jdi.event.VMDeathEvent;
import com.sun.jdi.event.VMDisconnectEvent;
import com.sun.jdi.event.VMStartEvent;
import com.sun.jdi.request.EventRequestManager;
import com.sun.jdi.request.ThreadDeathRequest;
import com.sun.jdi.request.ThreadStartRequest;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.Nullable;

public class DebugProcessEvents
extends DebugProcessImpl {
    private static final Logger LOG = Logger.getInstance(DebugProcessEvents.class);
    private DebuggerEventThread myEventThread;

    public DebugProcessEvents(Project project2) {
        super(project2);
    }

    @Override
    protected void commitVM(VirtualMachine vm) {
        super.commitVM(vm);
        if (vm != null) {
            this.vmAttached();
            this.myEventThread = new DebuggerEventThread();
            ApplicationManager.getApplication().executeOnPooledThread((Runnable)this.myEventThread);
        }
    }

    private static void showStatusText(DebugProcessEvents debugProcess, Event event) {
        Requestor requestor = debugProcess.getRequestsManager().findRequestor(event.request());
        Breakpoint breakpoint = null;
        if (requestor instanceof Breakpoint) {
            breakpoint = (Breakpoint)requestor;
        }
        String text = debugProcess.getEventText((Pair<Breakpoint, Event>)Pair.create((Object)breakpoint, (Object)event));
        debugProcess.showStatusText(text);
    }

    public String getEventText(Pair<Breakpoint, Event> descriptor) {
        String text = "";
        Event event = (Event)descriptor.getSecond();
        Breakpoint breakpoint = (Breakpoint)descriptor.getFirst();
        if (event instanceof LocatableEvent) {
            if (breakpoint instanceof LineBreakpoint && !((LineBreakpoint)breakpoint).isVisible()) {
                text = DebuggerBundle.message((String)"status.stopped.at.cursor", (Object[])new Object[0]);
            } else {
                try {
                    text = breakpoint != null ? breakpoint.getEventMessage((LocatableEvent)event) : DebuggerBundle.message((String)"status.generic.breakpoint.reached", (Object[])new Object[0]);
                }
                catch (InternalException e) {
                    text = DebuggerBundle.message((String)"status.generic.breakpoint.reached", (Object[])new Object[0]);
                }
            }
        } else if (event instanceof VMStartEvent) {
            text = DebuggerBundle.message((String)"status.process.started", (Object[])new Object[0]);
        } else if (event instanceof VMDeathEvent) {
            text = DebuggerBundle.message((String)"status.process.terminated", (Object[])new Object[0]);
        } else if (event instanceof VMDisconnectEvent) {
            RemoteConnection connection = this.getConnection();
            String addressDisplayName = DebuggerBundle.getAddressDisplayName((RemoteConnection)connection);
            String transportName = DebuggerBundle.getTransportName((RemoteConnection)connection);
            text = DebuggerBundle.message((String)"status.disconnected", (Object[])new Object[]{addressDisplayName, transportName});
        }
        return text;
    }

    private static void preprocessEvent(SuspendContextImpl suspendContext, ThreadReference thread) {
        ThreadReferenceProxyImpl oldThread = suspendContext.getThread();
        suspendContext.setThread(thread);
        if (oldThread == null) {
            suspendContext.getDebugProcess().beforeSuspend(suspendContext);
        }
    }

    private void processVMStartEvent(SuspendContextImpl suspendContext, VMStartEvent event) {
        DebugProcessEvents.preprocessEvent(suspendContext, event.thread());
        if (LOG.isDebugEnabled()) {
            LOG.debug("enter: processVMStartEvent()");
        }
        DebugProcessEvents.showStatusText(this, event);
        this.getSuspendManager().voteResume(suspendContext);
    }

    private void vmAttached() {
        DebuggerManagerThreadImpl.assertIsManagerThread();
        LOG.assertTrue(!this.isAttached());
        if (this.myState.compareAndSet(0, 1)) {
            VirtualMachineProxyImpl machineProxy = this.getVirtualMachineProxy();
            EventRequestManager requestManager = machineProxy.eventRequestManager();
            if (machineProxy.canGetMethodReturnValues()) {
                this.myReturnValueWatcher = new MethodReturnValueWatcher(requestManager);
            }
            ThreadStartRequest threadStartRequest = requestManager.createThreadStartRequest();
            threadStartRequest.setSuspendPolicy(0);
            threadStartRequest.enable();
            ThreadDeathRequest threadDeathRequest = requestManager.createThreadDeathRequest();
            threadDeathRequest.setSuspendPolicy(0);
            threadDeathRequest.enable();
            ((DebugProcessListener)this.myDebugProcessDispatcher.getMulticaster()).processAttached((DebugProcess)this);
            ApplicationManager.getApplication().runReadAction(new Runnable(){

                @Override
                public void run() {
                    XDebugSession session = DebugProcessEvents.this.getSession().getXDebugSession();
                    if (session != null) {
                        session.initBreakpoints();
                    }
                }
            });
            String addressDisplayName = DebuggerBundle.getAddressDisplayName((RemoteConnection)this.getConnection());
            String transportName = DebuggerBundle.getTransportName((RemoteConnection)this.getConnection());
            this.showStatusText(DebuggerBundle.message((String)"status.connected", (Object[])new Object[]{addressDisplayName, transportName}));
            if (LOG.isDebugEnabled()) {
                LOG.debug("leave: processVMStartEvent()");
            }
        }
    }

    private void processVMDeathEvent(SuspendContextImpl suspendContext, Event event) {
        try {
            DebugProcessEvents.preprocessEvent(suspendContext, null);
            this.cancelRunToCursorBreakpoint();
        }
        finally {
            if (this.myEventThread != null) {
                this.myEventThread.stopListening();
                this.myEventThread = null;
            }
            this.closeProcess(false);
        }
        if (event != null) {
            DebugProcessEvents.showStatusText(this, event);
        }
    }

    private void processClassPrepareEvent(SuspendContextImpl suspendContext, ClassPrepareEvent event) {
        DebugProcessEvents.preprocessEvent(suspendContext, event.thread());
        if (LOG.isDebugEnabled()) {
            LOG.debug("Class prepared: " + event.referenceType().name());
        }
        suspendContext.getDebugProcess().getRequestsManager().processClassPrepared(event);
        this.getSuspendManager().voteResume(suspendContext);
    }

    private void processStepEvent(SuspendContextImpl suspendContext, StepEvent event) {
        ThreadReference thread = event.thread();
        DebugProcessEvents.preprocessEvent(suspendContext, thread);
        RequestHint hint = (RequestHint)event.request().getProperty("hint");
        this.deleteStepRequests(event.thread());
        boolean shouldResume = false;
        Project project2 = this.getProject();
        if (hint != null) {
            int nextStepDepth = hint.getNextStepDepth(suspendContext);
            if (nextStepDepth == -100) {
                this.getSession().resetIgnoreStepFiltersFlag();
                this.getSession().clearSteppingThrough();
                shouldResume = true;
            } else if (nextStepDepth != 0) {
                ThreadReferenceProxyImpl threadProxy = suspendContext.getThread();
                this.doStep(suspendContext, threadProxy, hint.getSize(), nextStepDepth, hint);
                shouldResume = true;
            }
            if (!shouldResume && hint.isRestoreBreakpoints()) {
                DebuggerManagerEx.getInstanceEx(project2).getBreakpointManager().enableBreakpoints(this);
            }
        }
        if (shouldResume) {
            this.getSuspendManager().voteResume(suspendContext);
        } else {
            this.showStatusText("");
            if (this.myReturnValueWatcher != null) {
                this.myReturnValueWatcher.disable();
            }
            this.getSuspendManager().voteSuspend(suspendContext);
            if (hint != null) {
                MethodFilter methodFilter = hint.getMethodFilter();
                if (methodFilter instanceof NamedMethodFilter && !hint.wasStepTargetMethodMatched()) {
                    String message = "Method <b>" + ((NamedMethodFilter)methodFilter).getMethodName() + "()</b> has not been called";
                    XDebugSessionImpl.NOTIFICATION_GROUP.createNotification(message, MessageType.INFO).notify(project2);
                }
                if (hint.wasStepTargetMethodMatched() && hint.isResetIgnoreFilters()) {
                    this.checkPositionNotFiltered(suspendContext.getThread(), (Consumer<List<ClassFilter>>)((Consumer)filters -> this.mySession.resetIgnoreStepFiltersFlag()));
                }
            }
        }
    }

    private void processLocatableEvent(final SuspendContextImpl suspendContext, final LocatableEvent event) {
        ThreadReference thread = event.thread();
        DebugProcessEvents.preprocessEvent(suspendContext, thread);
        this.getManagerThread().schedule(new SuspendContextCommandImpl(suspendContext){

            @Override
            public void contextAction() throws Exception {
                boolean requestHit;
                SuspendManager suspendManager = DebugProcessEvents.this.getSuspendManager();
                SuspendContextImpl evaluatingContext = SuspendManagerUtil.getEvaluatingContext(suspendManager, suspendContext.getThread());
                if (evaluatingContext != null && !DebuggerSession.enableBreakpointsDuringEvaluation()) {
                    suspendManager.voteResume(suspendContext);
                    return;
                }
                final LocatableEventRequestor requestor = (LocatableEventRequestor)DebugProcessEvents.this.getRequestsManager().findRequestor(event.request());
                boolean resumePreferred = requestor != null && "SuspendNone".equals(requestor.getSuspendPolicy());
                try {
                    requestHit = requestor != null && requestor.processLocatableEvent(this, event);
                }
                catch (LocatableEventRequestor.EventProcessingException ex) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug(ex.getMessage());
                    }
                    final boolean[] considerRequestHit = new boolean[]{true};
                    DebuggerInvocationUtil.invokeAndWait(DebugProcessEvents.this.getProject(), new Runnable(){

                        @Override
                        public void run() {
                            String displayName = requestor instanceof Breakpoint ? ((Breakpoint)requestor).getDisplayName() : requestor.getClass().getSimpleName();
                            String message = DebuggerBundle.message((String)"error.evaluating.breakpoint.condition.or.action", (Object[])new Object[]{displayName, ex.getMessage()});
                            considerRequestHit[0] = Messages.showYesNoDialog((Project)DebugProcessEvents.this.getProject(), (String)message, (String)ex.getTitle(), (Icon)Messages.getQuestionIcon()) == 0;
                        }
                    }, ModalityState.NON_MODAL);
                    requestHit = considerRequestHit[0];
                    boolean bl = resumePreferred = !requestHit;
                }
                if (requestHit && requestor instanceof Breakpoint) {
                    ApplicationManager.getApplication().runReadAction(new Runnable(){

                        @Override
                        public void run() {
                            XBreakpoint breakpoint;
                            XDebugSession session = DebugProcessEvents.this.getSession().getXDebugSession();
                            if (session != null && (breakpoint = ((Breakpoint)requestor).getXBreakpoint()) != null) {
                                ((XDebugSessionImpl)session).processDependencies(breakpoint);
                            }
                        }
                    });
                }
                if (!requestHit || resumePreferred) {
                    suspendManager.voteResume(suspendContext);
                } else {
                    if (DebugProcessEvents.this.myReturnValueWatcher != null) {
                        DebugProcessEvents.this.myReturnValueWatcher.disable();
                    }
                    suspendManager.voteSuspend(suspendContext);
                    DebugProcessEvents.showStatusText(DebugProcessEvents.this, event);
                }
            }
        });
    }

    @Nullable
    private static LocatableEvent getLocatableEvent(EventSet eventSet) {
        for (Event event : eventSet) {
            if (!(event instanceof LocatableEvent)) continue;
            return (LocatableEvent)event;
        }
        return null;
    }

    private void processDefaultEvent(SuspendContextImpl suspendContext) {
        DebugProcessEvents.preprocessEvent(suspendContext, null);
        this.getSuspendManager().voteResume(suspendContext);
    }

    private class DebuggerEventThread
    implements Runnable {
        private final VirtualMachineProxyImpl myVmProxy;
        private boolean myIsStopped = false;

        DebuggerEventThread() {
            this.myVmProxy = DebugProcessEvents.this.getVirtualMachineProxy();
        }

        public synchronized void stopListening() {
            this.myIsStopped = true;
        }

        private synchronized boolean isStopped() {
            return this.myIsStopped;
        }

        @Override
        public void run() {
            try {
                EventQueue eventQueue = this.myVmProxy.eventQueue();
                while (!this.isStopped()) {
                    try {
                        final EventSet eventSet = eventQueue.remove();
                        DebugProcessEvents.this.getManagerThread().invokeAndWait(new DebuggerCommandImpl(){

                            @Override
                            public PrioritizedTask.Priority getPriority() {
                                return PrioritizedTask.Priority.HIGH;
                            }

                            @Override
                            protected void action() throws Exception {
                                int processed2 = 0;
                                for (Object event : eventSet) {
                                    ThreadReference thread;
                                    if (DebugProcessEvents.this.myReturnValueWatcher != null && DebugProcessEvents.this.myReturnValueWatcher.isEnabled() && DebugProcessEvents.this.myReturnValueWatcher.processEvent((Event)event)) {
                                        ++processed2;
                                        continue;
                                    }
                                    if (event instanceof ThreadStartEvent) {
                                        ++processed2;
                                        thread = ((ThreadStartEvent)event).thread();
                                        DebugProcessEvents.this.getVirtualMachineProxy().threadStarted(thread);
                                        ((DebugProcessListener)DebugProcessEvents.this.myDebugProcessDispatcher.getMulticaster()).threadStarted((DebugProcess)DebugProcessEvents.this, thread);
                                        continue;
                                    }
                                    if (!(event instanceof ThreadDeathEvent)) continue;
                                    ++processed2;
                                    thread = ((ThreadDeathEvent)event).thread();
                                    DebugProcessEvents.this.getVirtualMachineProxy().threadStopped(thread);
                                    ((DebugProcessListener)DebugProcessEvents.this.myDebugProcessDispatcher.getMulticaster()).threadStopped((DebugProcess)DebugProcessEvents.this, thread);
                                }
                                if (processed2 == eventSet.size()) {
                                    eventSet.resume();
                                    return;
                                }
                                LocatableEvent locatableEvent = DebugProcessEvents.getLocatableEvent(eventSet);
                                if (eventSet.suspendPolicy() == 2) {
                                    for (SuspendContextImpl context : DebugProcessEvents.this.getSuspendManager().getEventContexts()) {
                                        if (context.getSuspendPolicy() != 2) continue;
                                        if (DebugProcessImpl.isResumeOnlyCurrentThread() && locatableEvent != null && !context.isEvaluating()) {
                                            DebugProcessEvents.this.getSuspendManager().resume(context);
                                            continue;
                                        }
                                        if (DebuggerSession.enableBreakpointsDuringEvaluation()) continue;
                                        eventSet.resume();
                                        return;
                                    }
                                }
                                SuspendContextImpl suspendContext = null;
                                if (DebugProcessImpl.isResumeOnlyCurrentThread() && locatableEvent != null) {
                                    for (SuspendContextImpl context : DebugProcessEvents.this.getSuspendManager().getEventContexts()) {
                                        ThreadReferenceProxyImpl threadProxy = DebugProcessEvents.this.getVirtualMachineProxy().getThreadReferenceProxy(locatableEvent.thread());
                                        if (context.getSuspendPolicy() != 2 || !context.isExplicitlyResumed(threadProxy)) continue;
                                        context.myResumedThreads.remove(threadProxy);
                                        suspendContext = context;
                                        suspendContext.myVotesToVote = eventSet.size();
                                        break;
                                    }
                                }
                                if (suspendContext == null) {
                                    suspendContext = DebugProcessEvents.this.getSuspendManager().pushSuspendContext(eventSet);
                                }
                                for (Event event : eventSet) {
                                    try {
                                        if (event instanceof VMStartEvent) {
                                            DebugProcessEvents.this.processVMStartEvent(suspendContext, (VMStartEvent)event);
                                            continue;
                                        }
                                        if (event instanceof VMDeathEvent || event instanceof VMDisconnectEvent) {
                                            DebugProcessEvents.this.processVMDeathEvent(suspendContext, event);
                                            continue;
                                        }
                                        if (event instanceof ClassPrepareEvent) {
                                            DebugProcessEvents.this.processClassPrepareEvent(suspendContext, (ClassPrepareEvent)event);
                                            continue;
                                        }
                                        if (event instanceof StepEvent) {
                                            DebugProcessEvents.this.processStepEvent(suspendContext, (StepEvent)event);
                                            continue;
                                        }
                                        if (event instanceof LocatableEvent) {
                                            DebugProcessEvents.this.processLocatableEvent(suspendContext, (LocatableEvent)event);
                                            continue;
                                        }
                                        if (!(event instanceof ClassUnloadEvent)) continue;
                                        DebugProcessEvents.this.processDefaultEvent(suspendContext);
                                    }
                                    catch (VMDisconnectedException e) {
                                        LOG.debug((Throwable)e);
                                    }
                                    catch (InternalException e) {
                                        LOG.info((Throwable)e);
                                    }
                                    catch (Throwable e) {
                                        LOG.error(e);
                                    }
                                }
                            }
                        });
                    }
                    catch (InternalException e) {
                        LOG.debug((Throwable)e);
                    }
                    catch (InterruptedException e) {
                        throw e;
                    }
                    catch (VMDisconnectedException e) {
                        throw e;
                    }
                    catch (ProcessCanceledException e) {
                        throw e;
                    }
                    catch (Throwable e) {
                        LOG.debug(e);
                    }
                }
            }
            catch (InterruptedException e) {
                this.invokeVMDeathEvent();
            }
            catch (VMDisconnectedException e) {
                this.invokeVMDeathEvent();
            }
            finally {
                Thread.interrupted();
            }
        }

        private void invokeVMDeathEvent() {
            DebugProcessEvents.this.getManagerThread().invokeAndWait(new DebuggerCommandImpl(){

                @Override
                protected void action() throws Exception {
                    SuspendContextImpl suspendContext = DebugProcessEvents.this.getSuspendManager().pushSuspendContext(0, 1);
                    DebugProcessEvents.this.processVMDeathEvent(suspendContext, null);
                }
            });
        }
    }
}

