/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.compiler.classFilesIndex.impl;

import com.intellij.compiler.classFilesIndex.impl.MethodIncompleteSignature;
import org.jetbrains.annotations.NotNull;

public class UsageIndexValue
implements Comparable<UsageIndexValue> {
    private final int myOccurrences;
    private final MethodIncompleteSignature myMethodIncompleteSignature;

    public UsageIndexValue(MethodIncompleteSignature signature, int occurrences) {
        this.myOccurrences = occurrences;
        this.myMethodIncompleteSignature = signature;
    }

    public int getOccurrences() {
        return this.myOccurrences;
    }

    public MethodIncompleteSignature getMethodIncompleteSignature() {
        return this.myMethodIncompleteSignature;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UsageIndexValue that = (UsageIndexValue)o;
        return this.myOccurrences == that.myOccurrences && this.myMethodIncompleteSignature.equals(that.myMethodIncompleteSignature);
    }

    public int hashCode() {
        int result = this.myOccurrences;
        result = 31 * result + this.myMethodIncompleteSignature.hashCode();
        return result;
    }

    @Override
    public int compareTo(@NotNull UsageIndexValue that) {
        if (that == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "that", "com/intellij/compiler/classFilesIndex/impl/UsageIndexValue", "compareTo"));
        }
        int sub = -this.myOccurrences + that.myOccurrences;
        if (sub != 0) {
            return sub;
        }
        sub = this.myMethodIncompleteSignature.getOwner().compareTo(that.myMethodIncompleteSignature.getOwner());
        if (sub != 0) {
            return sub;
        }
        sub = this.myMethodIncompleteSignature.getName().compareTo(that.myMethodIncompleteSignature.getName());
        if (sub != 0) {
            return sub;
        }
        sub = this.myMethodIncompleteSignature.getReturnType().compareTo(that.myMethodIncompleteSignature.getReturnType());
        if (sub != 0) {
            return sub;
        }
        if (this.myMethodIncompleteSignature.isStatic() && !that.myMethodIncompleteSignature.isStatic()) {
            return 1;
        }
        if (that.myMethodIncompleteSignature.isStatic() && !this.myMethodIncompleteSignature.isStatic()) {
            return -1;
        }
        return 0;
    }
}

