/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.compiler.classFilesIndex.chainsSearch;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class MethodsChain {
    private final List<PsiMethod[]> myRevertedPath;
    private final int myWeight;
    private final String myQualifierClassName;
    private final Set<String> myExcludedQNames;

    public MethodsChain(PsiMethod[] methods, int weight, String qualifierClassName) {
        this(Collections.singletonList(methods), weight, qualifierClassName, MethodsChain.chooseParametersQNames(methods));
    }

    private MethodsChain(List<PsiMethod[]> revertedPath, int weight, String qualifierClassName, Set<String> excludedQNames) {
        this.myRevertedPath = revertedPath;
        this.myWeight = weight;
        this.myQualifierClassName = qualifierClassName;
        this.myExcludedQNames = excludedQNames;
    }

    public int size() {
        return this.myRevertedPath.size();
    }

    public Set<String> getExcludedQNames() {
        return this.myExcludedQNames;
    }

    public String getQualifierClassName() {
        return this.myQualifierClassName;
    }

    public Iterator<PsiMethod[]> iterator() {
        return this.myRevertedPath.iterator();
    }

    @NotNull
    public PsiMethod[] getFirst() {
        PsiMethod[] psiMethodArray = this.myRevertedPath.get(0);
        if (psiMethodArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/compiler/classFilesIndex/chainsSearch/MethodsChain", "getFirst"));
        }
        return psiMethodArray;
    }

    public List<PsiMethod[]> getPath() {
        return ContainerUtil.reverse(this.myRevertedPath);
    }

    public int getChainWeight() {
        return this.myWeight;
    }

    public MethodsChain addEdge(PsiMethod[] psiMethods, String newQualifierClassName, int newWeight) {
        ArrayList<PsiMethod[]> newRevertedPath = new ArrayList<PsiMethod[]>(this.myRevertedPath.size() + 1);
        newRevertedPath.addAll(this.myRevertedPath);
        newRevertedPath.add(psiMethods);
        return new MethodsChain(newRevertedPath, newWeight, newQualifierClassName, MethodsChain.joinSets(this.myExcludedQNames, MethodsChain.chooseParametersQNames(psiMethods)));
    }

    public String toString() {
        return StringUtil.join(this.myRevertedPath, (String)"<-");
    }

    public static CompareResult compare(MethodsChain left, MethodsChain right, PsiManager psiManager) {
        if (left.size() == 0) {
            return CompareResult.RIGHT_CONTAINS_LEFT;
        }
        if (right.size() == 0) {
            return CompareResult.LEFT_CONTAINS_RIGHT;
        }
        Iterator<PsiMethod[]> leftIterator = left.myRevertedPath.iterator();
        Iterator<PsiMethod[]> rightIterator = right.myRevertedPath.iterator();
        while (leftIterator.hasNext() && rightIterator.hasNext()) {
            PsiMethod thisNext = leftIterator.next()[0];
            PsiMethod thatNext = rightIterator.next()[0];
            if (thisNext == null || thatNext == null) {
                throw new NullPointerException();
            }
            if (thisNext.isConstructor() == thatNext.isConstructor() && thisNext.getName().equals(thatNext.getName())) continue;
            return CompareResult.NOT_EQUAL;
        }
        if (leftIterator.hasNext() && !rightIterator.hasNext()) {
            return CompareResult.LEFT_CONTAINS_RIGHT;
        }
        if (!leftIterator.hasNext() && rightIterator.hasNext()) {
            return CompareResult.RIGHT_CONTAINS_LEFT;
        }
        return MethodsChain.hasBaseMethod(left.getPath().get(0), right.getPath().get(0), psiManager) ? CompareResult.EQUAL : CompareResult.NOT_EQUAL;
    }

    private static boolean hasBaseMethod(PsiMethod[] left, PsiMethod[] right, PsiManager psiManager) {
        for (PsiMethod rightMethod : right) {
            PsiMethod[] rightSupers = rightMethod.findDeepestSuperMethods();
            if (rightSupers.length == 0) continue;
            for (PsiMethod leftMethod : left) {
                PsiMethod[] leftSupers = leftMethod.findDeepestSuperMethods();
                if (leftSupers.length == 0 || !psiManager.areElementsEquivalent((PsiElement)leftSupers[0], (PsiElement)rightSupers[0])) continue;
                return true;
            }
        }
        return false;
    }

    private static Set<String> joinSets(Set<String> ... sets) {
        HashSet<String> result = new HashSet<String>();
        for (Set<String> set : sets) {
            for (String s : set) {
                result.add(s);
            }
        }
        return result;
    }

    private static Set<String> chooseParametersQNames(PsiMethod[] methods) {
        HashSet<String> qNames = new HashSet<String>();
        for (PsiParameter methodParameter : methods[0].getParameterList().getParameters()) {
            qNames.add(methodParameter.getType().getCanonicalText());
        }
        return qNames;
    }

    public static enum CompareResult {
        LEFT_CONTAINS_RIGHT,
        RIGHT_CONTAINS_LEFT,
        EQUAL,
        NOT_EQUAL;

    }
}

