/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.compiler.ant;

import com.intellij.compiler.ant.BuildProperties;
import com.intellij.compiler.ant.ChunkBuildExtension;
import com.intellij.compiler.ant.GenerationOptions;
import com.intellij.compiler.ant.PropertyFileGenerator;
import com.intellij.openapi.application.PathMacros;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ArrayUtil;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Set;

public class PropertyFileGeneratorImpl
extends PropertyFileGenerator {
    private final List<Couple<String>> myProperties = new ArrayList<Couple<String>>();

    public PropertyFileGeneratorImpl(Project project2, GenerationOptions genOptions) {
        PathMacros pathMacros = PathMacros.getInstance();
        Set macroNamesSet = pathMacros.getUserMacroNames();
        if (macroNamesSet.size() > 0) {
            Object[] macroNames = ArrayUtil.toStringArray((Collection)macroNamesSet);
            Arrays.sort(macroNames);
            for (Object macroName : macroNames) {
                this.addProperty(BuildProperties.getPathMacroProperty((String)macroName), pathMacros.getValue((String)macroName));
            }
        }
        if (genOptions.forceTargetJdk) {
            Sdk[] usedJdks = BuildProperties.getUsedJdks((Project)project2);
            for (Sdk jdk : usedJdks) {
                if (jdk.getHomeDirectory() == null) continue;
                File homeDir = BuildProperties.toCanonicalFile((File)VfsUtil.virtualToIoFile((VirtualFile)jdk.getHomeDirectory()));
                this.addProperty(BuildProperties.getJdkHomeProperty((String)jdk.getName()), homeDir.getPath().replace(File.separatorChar, '/'));
            }
        }
        if (genOptions.isIdeaHomeGenerated()) {
            this.addProperty("idea.home", PathManager.getHomePath());
        }
        if (genOptions.enableFormCompiler) {
            this.addProperty("javac2.instrumentation.includeJavaRuntime", genOptions.forceTargetJdk ? "false" : "true");
        }
        ChunkBuildExtension.generateAllProperties((PropertyFileGenerator)this, (Project)project2, (GenerationOptions)genOptions);
    }

    public void addProperty(String name, String value) {
        this.myProperties.add((Couple<String>)Couple.of((Object)name, (Object)value));
    }

    public void generate(PrintWriter out) throws IOException {
        boolean isFirst = true;
        for (Couple<String> pair : this.myProperties) {
            if (!isFirst) {
                PropertyFileGeneratorImpl.crlf((PrintWriter)out);
            } else {
                isFirst = false;
            }
            out.print(StringUtil.escapeProperty((String)((String)pair.getFirst()), (boolean)true));
            out.print("=");
            out.print(StringUtil.escapeProperty((String)((String)pair.getSecond()), (boolean)false));
        }
    }
}

