/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection;

import com.intellij.CommonBundle;
import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInsight.daemon.QuickFixBundle;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.psi.JavaDirectoryService;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiPackage;
import com.intellij.refactoring.PackageWrapper;
import com.intellij.refactoring.move.moveClassesOrPackages.MoveClassesOrPackagesProcessor;
import com.intellij.refactoring.move.moveClassesOrPackages.MoveClassesOrPackagesUtil;
import com.intellij.refactoring.move.moveClassesOrPackages.SingleSourceRootMoveDestination;
import com.intellij.refactoring.util.RefactoringMessageUtil;
import com.intellij.util.IncorrectOperationException;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

public class MoveToPackageFix
implements LocalQuickFix {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInspection.MoveToPackageFix");
    private final String myTargetPackage;

    public MoveToPackageFix(String targetPackage) {
        this.myTargetPackage = targetPackage;
    }

    @NotNull
    public String getName() {
        String string = QuickFixBundle.message("move.class.to.package.text", this.myTargetPackage);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/MoveToPackageFix", "getName"));
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        String string = QuickFixBundle.message("move.class.to.package.family", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/MoveToPackageFix", "getFamilyName"));
        }
        return string;
    }

    public boolean isAvailable(PsiFile myFile) {
        return myFile != null && myFile.isValid() && myFile.getManager().isInProject((PsiElement)myFile) && myFile instanceof PsiJavaFile && ((PsiJavaFile)myFile).getClasses().length != 0 && this.myTargetPackage != null;
    }

    public void applyFix(final @NotNull Project project2, @NotNull ProblemDescriptor descriptor) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInspection/MoveToPackageFix", "applyFix"));
        }
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/codeInspection/MoveToPackageFix", "applyFix"));
        }
        PsiElement element = descriptor.getPsiElement();
        if (element == null) {
            return;
        }
        final PsiFile myFile = element.getContainingFile();
        if (!FileModificationService.getInstance().prepareFileForWrite(myFile)) {
            return;
        }
        ApplicationManager.getApplication().invokeLater(new Runnable(){

            @Override
            public void run() {
                MoveToPackageFix.this.chooseDirectoryAndMove(project2, myFile);
            }
        });
    }

    private void chooseDirectoryAndMove(Project project2, PsiFile myFile) {
        try {
            String error;
            PsiDirectory directory = null;
            try {
                directory = MoveClassesOrPackagesUtil.chooseDestinationPackage(project2, this.myTargetPackage, myFile.getContainingDirectory());
                if (directory == null) {
                    return;
                }
                error = RefactoringMessageUtil.checkCanCreateFile(directory, myFile.getName());
            }
            catch (IncorrectOperationException e) {
                error = e.getLocalizedMessage();
            }
            if (error != null) {
                Messages.showMessageDialog((Project)project2, (String)error, (String)CommonBundle.getErrorTitle(), (Icon)Messages.getErrorIcon());
                return;
            }
            new MoveClassesOrPackagesProcessor(project2, (PsiElement[])((PsiJavaFile)myFile).getClasses(), new SingleSourceRootMoveDestination(PackageWrapper.create((PsiPackage)JavaDirectoryService.getInstance().getPackage(directory)), directory), false, false, null).run();
        }
        catch (IncorrectOperationException e) {
            LOG.error((Throwable)e);
        }
    }
}

