/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.template.emmet.generators;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ArrayUtil;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.Random;
import java.util.TreeSet;

public class LoremGenerator {
    static final String[] COMMON_P = "lorem ipsum dolor sit amet consectetur adipisicing elit".split(" ");
    private static final String[] WORDS = new String[]{"exercitationem", "perferendis", "perspiciatis", "laborum", "eveniet", "sunt", "iure", "nam", "nobis", "eum", "cum", "officiis", "excepturi", "odio", "consectetur", "quasi", "aut", "quisquam", "vel", "eligendi", "itaque", "non", "odit", "tempore", "quaerat", "dignissimos", "facilis", "neque", "nihil", "expedita", "vitae", "vero", "ipsum", "nisi", "animi", "cumque", "pariatur", "velit", "modi", "natus", "iusto", "eaque", "sequi", "illo", "sed", "ex", "et", "voluptatibus", "tempora", "veritatis", "ratione", "assumenda", "incidunt", "nostrum", "placeat", "aliquid", "fuga", "provident", "praesentium", "rem", "necessitatibus", "suscipit", "adipisci", "quidem", "possimus", "voluptas", "debitis", "sint", "accusantium", "unde", "sapiente", "voluptate", "qui", "aspernatur", "laudantium", "soluta", "amet", "quo", "aliquam", "saepe", "culpa", "libero", "ipsa", "dicta", "reiciendis", "nesciunt", "doloribus", "autem", "impedit", "minima", "maiores", "repudiandae", "ipsam", "obcaecati", "ullam", "enim", "totam", "delectus", "ducimus", "quis", "voluptates", "dolores", "molestiae", "harum", "dolorem", "quia", "voluptatem", "molestias", "magni", "distinctio", "omnis", "illum", "dolorum", "voluptatum", "ea", "quas", "quam", "corporis", "quae", "blanditiis", "atque", "deserunt", "laboriosam", "earum", "consequuntur", "hic", "cupiditate", "quibusdam", "accusamus", "ut", "rerum", "error", "minus", "eius", "ab", "ad", "nemo", "fugit", "officia", "at", "in", "id", "quos", "reprehenderit", "numquam", "iste", "fugiat", "sit", "inventore", "beatae", "repellendus", "magnam", "recusandae", "quod", "explicabo", "doloremque", "aperiam", "consequatur", "asperiores", "commodi", "optio", "dolor", "labore", "temporibus", "repellat", "veniam", "architecto", "est", "esse", "mollitia", "nulla", "a", "similique", "eos", "alias", "dolore", "tenetur", "deleniti", "porro", "facere", "maxime", "corrupti"};
    private final Random random = new Random();

    public String generate(int wordsCount, boolean startWithCommon) {
        String[] words;
        LinkedList<String> sentences = new LinkedList<String>();
        int totalWords = 0;
        if (startWithCommon) {
            words = Arrays.copyOfRange(COMMON_P, 0, Math.min(wordsCount, COMMON_P.length));
            if (words.length > 5) {
                words[4] = words[4] + ',';
            }
            totalWords += words.length;
            sentences.add(LoremGenerator.sentence(words, '.'));
        }
        while (totalWords < wordsCount) {
            words = this.sample(WORDS, Math.min(this.rand(3, 12) * this.rand(1, 5), wordsCount - totalWords));
            totalWords += words.length;
            this.insertCommas(words);
            sentences.add(this.sentence(words));
        }
        return StringUtil.join(sentences, (String)" ");
    }

    private void insertCommas(String[] words) {
        if (words.length <= 1) {
            return;
        }
        for (int totalCommas = (len = words.length) > 3 && len <= 6 ? this.rand(0, 1) : (len > 6 && len <= 12 ? this.rand(0, 2) : this.rand(1, 4)); totalCommas > 0; --totalCommas) {
            int i = this.rand(0, words.length - 1);
            String word = words[i];
            if (StringUtil.endsWithChar((CharSequence)word, (char)',')) continue;
            words[i] = word + ",";
        }
    }

    private String sentence(String[] words) {
        return LoremGenerator.sentence(words, this.choice("?!..."));
    }

    private static String sentence(String[] words, char endChar) {
        if (words.length > 0) {
            words[0] = StringUtil.capitalize((String)words[0]);
        }
        return StringUtil.join((String[])words, (String)" ") + endChar;
    }

    private int rand(int from, int to) {
        return this.random.nextInt(to - from) + from;
    }

    private String[] sample(String[] words, int wordsCount) {
        int len = words.length;
        int iterations = Math.min(len, wordsCount);
        TreeSet<String> result = new TreeSet<String>();
        while (result.size() < iterations) {
            int i = this.rand(0, len - 1);
            result.add(words[i]);
        }
        return ArrayUtil.toStringArray(result);
    }

    private char choice(String values) {
        return values.charAt(this.rand(0, values.length() - 1));
    }
}

