/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.template.emmet;

import com.intellij.application.options.emmet.EmmetOptions;
import com.intellij.codeInsight.CodeInsightActionHandler;
import com.intellij.codeInsight.actions.BaseCodeInsightAction;
import com.intellij.codeInsight.hint.HintManager;
import com.intellij.codeInsight.template.CustomLiveTemplate;
import com.intellij.codeInsight.template.emmet.ZenCodingTemplate;
import com.intellij.codeInsight.template.impl.WrapWithCustomTemplateAction;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.SelectionModel;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiFile;
import com.intellij.util.containers.ContainerUtil;
import org.jetbrains.annotations.NotNull;

public class SurroundWithEmmetAction
extends BaseCodeInsightAction {
    public SurroundWithEmmetAction() {
        this.setEnabledInModalContext(true);
    }

    protected boolean isValidForFile(@NotNull Project project2, @NotNull Editor editor, @NotNull PsiFile file2) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/template/emmet/SurroundWithEmmetAction", "isValidForFile"));
        }
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/codeInsight/template/emmet/SurroundWithEmmetAction", "isValidForFile"));
        }
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/codeInsight/template/emmet/SurroundWithEmmetAction", "isValidForFile"));
        }
        return EmmetOptions.getInstance().isEmmetEnabled() && new ZenCodingTemplate().isApplicable(file2, editor.getSelectionModel().getSelectionStart(), true);
    }

    @NotNull
    protected CodeInsightActionHandler getHandler() {
        SurroundWithEmmetHandler surroundWithEmmetHandler = new SurroundWithEmmetHandler();
        if (surroundWithEmmetHandler == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/template/emmet/SurroundWithEmmetAction", "getHandler"));
        }
        return surroundWithEmmetHandler;
    }

    private static class SurroundWithEmmetHandler
    implements CodeInsightActionHandler {
        private SurroundWithEmmetHandler() {
        }

        public void invoke(@NotNull Project project2, @NotNull Editor editor, @NotNull PsiFile file2) {
            ZenCodingTemplate emmetCustomTemplate;
            if (project2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/template/emmet/SurroundWithEmmetAction$SurroundWithEmmetHandler", "invoke"));
            }
            if (editor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/codeInsight/template/emmet/SurroundWithEmmetAction$SurroundWithEmmetHandler", "invoke"));
            }
            if (file2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/codeInsight/template/emmet/SurroundWithEmmetAction$SurroundWithEmmetHandler", "invoke"));
            }
            SelectionModel selectionModel = editor.getSelectionModel();
            if (!selectionModel.hasSelection()) {
                selectionModel.selectLineAtCaret();
            }
            if ((emmetCustomTemplate = (ZenCodingTemplate)CustomLiveTemplate.EP_NAME.findExtension(ZenCodingTemplate.class)) != null) {
                new WrapWithCustomTemplateAction(emmetCustomTemplate, editor, file2, ContainerUtil.newHashSet()).actionPerformed(null);
            } else if (!ApplicationManager.getApplication().isUnitTestMode()) {
                HintManager.getInstance().showErrorHint(editor, "Cannot invoke Surround with Emmet in the current context");
            }
        }

        public boolean startInWriteAction() {
            return true;
        }
    }
}

