/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.intention.impl;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInsight.intention.PsiElementBaseIntentionAction;
import com.intellij.codeInsight.intention.impl.SplitConditionUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiBlockStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiIfStatement;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiPolyadicExpression;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.util.RefactoringUtil;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;

public class SplitIfAction
extends PsiElementBaseIntentionAction {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInsight.intention.impl.SplitIfAction");

    public boolean isAvailable(@NotNull Project project2, Editor editor, @NotNull PsiElement element) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/intention/impl/SplitIfAction", "isAvailable"));
        }
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/codeInsight/intention/impl/SplitIfAction", "isAvailable"));
        }
        PsiPolyadicExpression expression = SplitConditionUtil.findCondition(element);
        if (expression == null) {
            return false;
        }
        if (!(expression.getParent() instanceof PsiIfStatement)) {
            return false;
        }
        PsiIfStatement ifStatement = (PsiIfStatement)expression.getParent();
        if (!PsiTreeUtil.isAncestor((PsiElement)ifStatement.getCondition(), (PsiElement)expression, (boolean)false)) {
            return false;
        }
        if (ifStatement.getThenBranch() == null) {
            return false;
        }
        this.setText(CodeInsightBundle.message((String)"intention.split.if.text", (Object[])new Object[0]));
        return true;
    }

    @NotNull
    public String getFamilyName() {
        String string = CodeInsightBundle.message((String)"intention.split.if.family", (Object[])new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/intention/impl/SplitIfAction", "getFamilyName"));
        }
        return string;
    }

    public void invoke(@NotNull Project project2, Editor editor, @NotNull PsiElement element) throws IncorrectOperationException {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/intention/impl/SplitIfAction", "invoke"));
        }
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/codeInsight/intention/impl/SplitIfAction", "invoke"));
        }
        try {
            if (!FileModificationService.getInstance().preparePsiElementForWrite(element)) {
                return;
            }
            PsiJavaToken token = (PsiJavaToken)element;
            LOG.assertTrue(token.getTokenType() == JavaTokenType.ANDAND || token.getTokenType() == JavaTokenType.OROR);
            PsiPolyadicExpression expression = (PsiPolyadicExpression)token.getParent();
            PsiIfStatement ifStatement = (PsiIfStatement)PsiTreeUtil.getParentOfType((PsiElement)expression, PsiIfStatement.class);
            LOG.assertTrue(PsiTreeUtil.isAncestor((PsiElement)ifStatement.getCondition(), (PsiElement)expression, (boolean)false));
            if (token.getTokenType() == JavaTokenType.ANDAND) {
                SplitIfAction.doAndSplit(ifStatement, expression, token, editor);
            } else if (token.getTokenType() == JavaTokenType.OROR) {
                SplitIfAction.doOrSplit(ifStatement, expression, token, editor);
            }
        }
        catch (IncorrectOperationException e) {
            LOG.error((Throwable)e);
        }
    }

    private static void doAndSplit(PsiIfStatement ifStatement, PsiPolyadicExpression expression, PsiJavaToken token, Editor editor) throws IncorrectOperationException {
        PsiExpression lOperand = SplitConditionUtil.getLOperands(expression, token);
        PsiExpression rOperand = SplitConditionUtil.getROperands(expression, token);
        PsiManager psiManager = ifStatement.getManager();
        PsiIfStatement subIf = (PsiIfStatement)ifStatement.copy();
        subIf.getCondition().replace((PsiElement)RefactoringUtil.unparenthesizeExpression(rOperand));
        ifStatement.getCondition().replace((PsiElement)RefactoringUtil.unparenthesizeExpression(lOperand));
        if (ifStatement.getThenBranch() instanceof PsiBlockStatement) {
            PsiBlockStatement blockStmt = (PsiBlockStatement)JavaPsiFacade.getInstance((Project)psiManager.getProject()).getElementFactory().createStatementFromText("{}", null);
            blockStmt = (PsiBlockStatement)CodeStyleManager.getInstance((Project)psiManager.getProject()).reformat((PsiElement)blockStmt);
            blockStmt = (PsiBlockStatement)ifStatement.getThenBranch().replace((PsiElement)blockStmt);
            blockStmt.getCodeBlock().add((PsiElement)subIf);
        } else {
            ifStatement.getThenBranch().replace((PsiElement)subIf);
        }
        int offset1 = ifStatement.getCondition().getTextOffset();
        editor.getCaretModel().moveToOffset(offset1);
        editor.getScrollingModel().scrollToCaret(ScrollType.RELATIVE);
        editor.getSelectionModel().removeSelection();
    }

    private static void doOrSplit(PsiIfStatement ifStatement, PsiPolyadicExpression expression, PsiJavaToken token, Editor editor) throws IncorrectOperationException {
        PsiExpression lOperand = SplitConditionUtil.getLOperands(expression, token);
        PsiExpression rOperand = SplitConditionUtil.getROperands(expression, token);
        PsiIfStatement secondIf = (PsiIfStatement)ifStatement.copy();
        PsiStatement elseBranch = ifStatement.getElseBranch();
        if (elseBranch != null) {
            elseBranch = (PsiStatement)elseBranch.copy();
        }
        ifStatement.getCondition().replace((PsiElement)RefactoringUtil.unparenthesizeExpression(lOperand));
        secondIf.getCondition().replace((PsiElement)RefactoringUtil.unparenthesizeExpression(rOperand));
        ifStatement.setElseBranch((PsiStatement)secondIf);
        if (elseBranch != null) {
            secondIf.setElseBranch(elseBranch);
        }
        int offset1 = ifStatement.getCondition().getTextOffset();
        editor.getCaretModel().moveToOffset(offset1);
        editor.getScrollingModel().scrollToCaret(ScrollType.RELATIVE);
        editor.getSelectionModel().removeSelection();
    }
}

