/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.intention.impl;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.daemon.impl.analysis.JavaHighlightUtil;
import com.intellij.codeInsight.intention.QuickFixFactory;
import com.intellij.codeInsight.intention.impl.BaseMoveInitializerToMethodAction;
import com.intellij.codeInspection.LocalQuickFixAndIntentionActionOnPsiElement;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class MoveInitializerToConstructorAction
extends BaseMoveInitializerToMethodAction {
    @NotNull
    public String getFamilyName() {
        String string = this.getText();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/intention/impl/MoveInitializerToConstructorAction", "getFamilyName"));
        }
        return string;
    }

    @NotNull
    public String getText() {
        String string = CodeInsightBundle.message((String)"intention.move.initializer.to.constructor", (Object[])new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/intention/impl/MoveInitializerToConstructorAction", "getText"));
        }
        return string;
    }

    @Override
    @NotNull
    protected Collection<String> getUnsuitableModifiers() {
        List<String> list = Arrays.asList("static");
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/intention/impl/MoveInitializerToConstructorAction", "getUnsuitableModifiers"));
        }
        return list;
    }

    @Override
    @NotNull
    protected Collection<PsiMethod> getOrCreateMethods(@NotNull Project project2, @NotNull Editor editor, PsiFile file2, @NotNull PsiClass aClass) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/intention/impl/MoveInitializerToConstructorAction", "getOrCreateMethods"));
        }
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/codeInsight/intention/impl/MoveInitializerToConstructorAction", "getOrCreateMethods"));
        }
        if (aClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/intellij/codeInsight/intention/impl/MoveInitializerToConstructorAction", "getOrCreateMethods"));
        }
        List<PsiMethod> constructors = Arrays.asList(aClass.getConstructors());
        if (constructors.isEmpty()) {
            Collection<PsiMethod> collection = MoveInitializerToConstructorAction.createConstructor(project2, editor, file2, aClass);
            if (collection == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/intention/impl/MoveInitializerToConstructorAction", "getOrCreateMethods"));
            }
            return collection;
        }
        Collection<PsiMethod> collection = MoveInitializerToConstructorAction.removeChainedConstructors(constructors);
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/intention/impl/MoveInitializerToConstructorAction", "getOrCreateMethods"));
        }
        return collection;
    }

    @NotNull
    private static Collection<PsiMethod> removeChainedConstructors(@NotNull Collection<PsiMethod> constructors) {
        if (constructors == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "constructors", "com/intellij/codeInsight/intention/impl/MoveInitializerToConstructorAction", "removeChainedConstructors"));
        }
        ArrayList<PsiMethod> result = new ArrayList<PsiMethod>(constructors);
        Iterator iterator = result.iterator();
        while (iterator.hasNext()) {
            PsiMethod constructor = (PsiMethod)iterator.next();
            if (JavaHighlightUtil.getChainedConstructors(constructor) == null) continue;
            iterator.remove();
        }
        ArrayList<PsiMethod> arrayList = result;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/intention/impl/MoveInitializerToConstructorAction", "removeChainedConstructors"));
        }
        return arrayList;
    }

    @NotNull
    private static Collection<PsiMethod> createConstructor(@NotNull Project project2, @NotNull Editor editor, PsiFile file2, @NotNull PsiClass aClass) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/intention/impl/MoveInitializerToConstructorAction", "createConstructor"));
        }
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/codeInsight/intention/impl/MoveInitializerToConstructorAction", "createConstructor"));
        }
        if (aClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/intellij/codeInsight/intention/impl/MoveInitializerToConstructorAction", "createConstructor"));
        }
        LocalQuickFixAndIntentionActionOnPsiElement addDefaultConstructorFix = QuickFixFactory.getInstance().createAddDefaultConstructorFix(aClass);
        int offset = editor.getCaretModel().getOffset();
        addDefaultConstructorFix.invoke(project2, editor, file2);
        editor.getCaretModel().moveToOffset(offset);
        List<PsiMethod> list = Arrays.asList(aClass.getConstructors());
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/intention/impl/MoveInitializerToConstructorAction", "createConstructor"));
        }
        return list;
    }
}

