/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.editorActions;

import com.intellij.codeInsight.editorActions.SelectWordUtil;
import com.intellij.ide.DataManager;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.FoldRegion;
import com.intellij.openapi.editor.actionSystem.EditorActionHandler;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiCompiledFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.util.Processor;
import java.awt.Component;
import org.jetbrains.annotations.Nullable;

public class UnSelectWordHandler
extends EditorActionHandler {
    private final EditorActionHandler myOriginalHandler;

    public UnSelectWordHandler(EditorActionHandler originalHandler) {
        super(true);
        this.myOriginalHandler = originalHandler;
    }

    public void doExecute(Editor editor, @Nullable Caret caret, DataContext dataContext) {
        Project project2 = (Project)CommonDataKeys.PROJECT.getData(DataManager.getInstance().getDataContext((Component)editor.getComponent()));
        if (project2 == null) {
            return;
        }
        Document document = editor.getDocument();
        PsiFile file2 = PsiDocumentManager.getInstance((Project)project2).getPsiFile(document);
        if (file2 == null) {
            if (this.myOriginalHandler != null) {
                this.myOriginalHandler.execute(editor, caret, dataContext);
            }
            return;
        }
        PsiDocumentManager.getInstance((Project)project2).commitAllDocuments();
        UnSelectWordHandler.doAction(editor, file2);
    }

    private static void doAction(final Editor editor, PsiFile file2) {
        PsiElement anotherElement;
        PsiElement element;
        if (file2 instanceof PsiCompiledFile && (file2 = ((PsiCompiledFile)file2).getDecompiledPsiFile()) == null) {
            return;
        }
        if (!editor.getSelectionModel().hasSelection()) {
            return;
        }
        CharSequence text = editor.getDocument().getCharsSequence();
        int cursorOffset = editor.getCaretModel().getOffset();
        if (cursorOffset > 0 && cursorOffset < text.length() && !Character.isJavaIdentifierPart(text.charAt(cursorOffset)) && Character.isJavaIdentifierPart(text.charAt(cursorOffset - 1))) {
            --cursorOffset;
        }
        if ((element = file2.findElementAt(cursorOffset)) instanceof PsiWhiteSpace && cursorOffset > 0 && !((anotherElement = file2.findElementAt(cursorOffset - 1)) instanceof PsiWhiteSpace)) {
            element = anotherElement;
        }
        if (element instanceof PsiWhiteSpace) {
            PsiElement nextSibling = element.getNextSibling();
            if (nextSibling == null) {
                if ((element = element.getParent()) == null || element instanceof PsiFile) {
                    return;
                }
                nextSibling = element.getNextSibling();
                if (nextSibling == null) {
                    return;
                }
            }
            element = nextSibling;
            cursorOffset = element.getTextRange().getStartOffset();
        }
        final TextRange selectionRange = new TextRange(editor.getSelectionModel().getSelectionStart(), editor.getSelectionModel().getSelectionEnd());
        final Ref maximumRange = new Ref();
        final int finalCursorOffset = cursorOffset;
        SelectWordUtil.processRanges(element, text, cursorOffset, editor, new Processor<TextRange>(){

            public boolean process(TextRange range) {
                if (!(!selectionRange.contains(range) || range.equals((Object)selectionRange) || !range.contains(finalCursorOffset) && finalCursorOffset != range.getEndOffset() || this.isOffsetCollapsed(range.getStartOffset()) || this.isOffsetCollapsed(range.getEndOffset()) || maximumRange.get() != null && !range.contains((TextRange)maximumRange.get()))) {
                    maximumRange.set((Object)range);
                }
                return false;
            }

            private boolean isOffsetCollapsed(int offset) {
                FoldRegion region = editor.getFoldingModel().getCollapsedRegionAtOffset(offset);
                return region != null && region.getStartOffset() != offset && region.getEndOffset() != offset;
            }
        });
        TextRange range = (TextRange)maximumRange.get();
        if (range == null) {
            editor.getSelectionModel().setSelection(cursorOffset, cursorOffset);
        } else {
            editor.getSelectionModel().setSelection(range.getStartOffset(), range.getEndOffset());
        }
    }
}

