/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl;

import com.intellij.ProjectTopics;
import com.intellij.codeEditor.JavaEditorFileSwapper;
import com.intellij.codeInsight.AttachSourcesProvider;
import com.intellij.ide.highlighter.JavaClassFileType;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.Result;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.fileChooser.FileChooser;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectBundle;
import com.intellij.openapi.roots.LibraryOrderEntry;
import com.intellij.openapi.roots.ModuleRootAdapter;
import com.intellij.openapi.roots.ModuleRootEvent;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.ui.configuration.LibrarySourceRootDetectorUtil;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListPopupStep;
import com.intellij.openapi.ui.popup.ListSeparator;
import com.intellij.openapi.ui.popup.PopupStep;
import com.intellij.openapi.ui.popup.util.BaseListPopupStep;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.impl.compiled.ClsParsingUtil;
import com.intellij.ui.EditorNotificationPanel;
import com.intellij.ui.EditorNotifications;
import com.intellij.ui.GuiUtils;
import com.intellij.util.PathUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.HashMap;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AttachSourcesNotificationProvider
extends EditorNotifications.Provider<EditorNotificationPanel> {
    private static final ExtensionPointName<AttachSourcesProvider> EXTENSION_POINT_NAME = new ExtensionPointName("com.intellij.attachSourcesProvider");
    private static final Key<EditorNotificationPanel> KEY = Key.create((String)"add sources to class");
    private final Project myProject;

    public AttachSourcesNotificationProvider(Project project2, final EditorNotifications notifications) {
        this.myProject = project2;
        this.myProject.getMessageBus().connect((Disposable)project2).subscribe(ProjectTopics.PROJECT_ROOTS, (Object)new ModuleRootAdapter(){

            public void rootsChanged(ModuleRootEvent event) {
                notifications.updateAllNotifications();
            }
        });
    }

    @NotNull
    public Key<EditorNotificationPanel> getKey() {
        Key<EditorNotificationPanel> key = KEY;
        if (key == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/AttachSourcesNotificationProvider", "getKey"));
        }
        return key;
    }

    public EditorNotificationPanel createNotificationPanel(final @NotNull VirtualFile file2, @NotNull FileEditor fileEditor) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/codeInsight/daemon/impl/AttachSourcesNotificationProvider", "createNotificationPanel"));
        }
        if (fileEditor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileEditor", "com/intellij/codeInsight/daemon/impl/AttachSourcesNotificationProvider", "createNotificationPanel"));
        }
        if (file2.getFileType() != JavaClassFileType.INSTANCE) {
            return null;
        }
        final EditorNotificationPanel panel = new EditorNotificationPanel();
        String text = ProjectBundle.message((String)"class.file.decompiled.text", (Object[])new Object[0]);
        String classInfo = AttachSourcesNotificationProvider.getClassFileInfo(file2);
        if (classInfo != null) {
            text = text + ", " + classInfo;
        }
        panel.setText(text);
        final VirtualFile sourceFile = JavaEditorFileSwapper.findSourceFile(this.myProject, file2);
        if (sourceFile == null) {
            final List<LibraryOrderEntry> libraries = this.findLibraryEntriesForFile(file2);
            if (libraries != null) {
                ArrayList<AttachSourcesProvider.AttachSourcesAction> actions = new ArrayList<AttachSourcesProvider.AttachSourcesAction>();
                PsiFile clsFile = PsiManager.getInstance((Project)this.myProject).findFile(file2);
                boolean hasNonLightAction = false;
                for (AttachSourcesProvider each : (AttachSourcesProvider[])Extensions.getExtensions(EXTENSION_POINT_NAME)) {
                    for (AttachSourcesProvider.AttachSourcesAction action : each.getActions(libraries, clsFile)) {
                        if (hasNonLightAction) {
                            if (action instanceof AttachSourcesProvider.LightAttachSourcesAction) {
                                continue;
                            }
                        } else if (!(action instanceof AttachSourcesProvider.LightAttachSourcesAction)) {
                            actions.clear();
                            hasNonLightAction = true;
                        }
                        actions.add(action);
                    }
                }
                Collections.sort(actions, new Comparator<AttachSourcesProvider.AttachSourcesAction>(){

                    @Override
                    public int compare(AttachSourcesProvider.AttachSourcesAction o1, AttachSourcesProvider.AttachSourcesAction o2) {
                        return o1.getName().compareToIgnoreCase(o2.getName());
                    }
                });
                Object defaultAction = AttachSourcesNotificationProvider.findSourceFileInSameJar(file2) != null ? new AttachJarAsSourcesAction(file2) : new ChooseAndAttachSourcesAction(this.myProject, (JComponent)panel);
                actions.add((AttachSourcesProvider.AttachSourcesAction)defaultAction);
                for (final AttachSourcesProvider.AttachSourcesAction action : actions) {
                    panel.createActionLabel(GuiUtils.getTextWithoutMnemonicEscaping((String)action.getName()), new Runnable(){

                        @Override
                        public void run() {
                            List entries = AttachSourcesNotificationProvider.this.findLibraryEntriesForFile(file2);
                            if (!Comparing.equal((Object)libraries, (Object)entries)) {
                                Messages.showErrorDialog((Project)AttachSourcesNotificationProvider.this.myProject, (String)("Can't find library for " + file2.getName()), (String)"Error");
                                return;
                            }
                            panel.setText(action.getBusyText());
                            action.perform(entries);
                        }
                    });
                }
            }
        } else {
            panel.createActionLabel(ProjectBundle.message((String)"class.file.open.source.action", (Object[])new Object[0]), new Runnable(){

                @Override
                public void run() {
                    OpenFileDescriptor descriptor = new OpenFileDescriptor(AttachSourcesNotificationProvider.this.myProject, sourceFile);
                    FileEditorManager.getInstance((Project)AttachSourcesNotificationProvider.this.myProject).openTextEditor(descriptor, true);
                }
            });
        }
        return panel;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    private static String getClassFileInfo(VirtualFile file2) {
        try {
            byte[] data = file2.contentsToByteArray(false);
            if (data.length <= 8) return null;
            try (DataInputStream stream = new DataInputStream(new ByteArrayInputStream(data));){
                if (stream.readInt() != -889275714) return null;
                int minor = stream.readUnsignedShort();
                int major = stream.readUnsignedShort();
                StringBuilder info = new StringBuilder().append("bytecode version: ").append(major).append('.').append(minor);
                LanguageLevel level = ClsParsingUtil.getLanguageLevelByVersion(major);
                if (level != null) {
                    info.append(" (").append(level == LanguageLevel.JDK_1_3 ? level.getName() + " or older" : level.getName()).append(')');
                }
                String string = info.toString();
                return string;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return null;
    }

    @Nullable
    private List<LibraryOrderEntry> findLibraryEntriesForFile(VirtualFile file2) {
        List entries = null;
        ProjectFileIndex index = ProjectFileIndex.SERVICE.getInstance((Project)this.myProject);
        for (OrderEntry entry : index.getOrderEntriesForFile(file2)) {
            if (!(entry instanceof LibraryOrderEntry)) continue;
            if (entries == null) {
                entries = ContainerUtil.newSmartList();
            }
            entries.add((LibraryOrderEntry)entry);
        }
        return entries;
    }

    @Nullable
    private static VirtualFile findSourceFileInSameJar(VirtualFile classFile) {
        String name = classFile.getName();
        int i = name.indexOf(36);
        if (i != -1) {
            name = name.substring(0, i);
        }
        if ((i = name.indexOf(46)) != -1) {
            name = name.substring(0, i);
        }
        return classFile.getParent().findChild(name + ".java");
    }

    private static class ChooseAndAttachSourcesAction
    implements AttachSourcesProvider.AttachSourcesAction {
        private final Project myProject;
        private final JComponent myParentComponent;

        public ChooseAndAttachSourcesAction(Project project2, JComponent parentComponent) {
            this.myProject = project2;
            this.myParentComponent = parentComponent;
        }

        public String getName() {
            return ProjectBundle.message((String)"module.libraries.choose.sources.button", (Object[])new Object[0]);
        }

        public String getBusyText() {
            return ProjectBundle.message((String)"library.attach.sources.action.busy.text", (Object[])new Object[0]);
        }

        public ActionCallback perform(List<LibraryOrderEntry> libraries) {
            FileChooserDescriptor descriptor = FileChooserDescriptorFactory.createMultipleJavaPathDescriptor();
            descriptor.setTitle(ProjectBundle.message((String)"library.attach.sources.action", (Object[])new Object[0]));
            descriptor.setDescription(ProjectBundle.message((String)"library.attach.sources.description", (Object[])new Object[0]));
            Library firstLibrary = libraries.get(0).getLibrary();
            VirtualFile[] roots = firstLibrary != null ? firstLibrary.getFiles(OrderRootType.CLASSES) : VirtualFile.EMPTY_ARRAY;
            VirtualFile[] candidates = FileChooser.chooseFiles((FileChooserDescriptor)descriptor, (Project)this.myProject, roots.length == 0 ? null : PathUtil.getLocalFile((VirtualFile)roots[0]));
            if (candidates.length == 0) {
                return ActionCallback.REJECTED;
            }
            final VirtualFile[] files = LibrarySourceRootDetectorUtil.scanAndSelectDetectedJavaSourceRoots(this.myParentComponent, candidates);
            if (files.length == 0) {
                return ActionCallback.REJECTED;
            }
            HashMap librariesToAppendSourcesTo = new HashMap();
            for (LibraryOrderEntry library : libraries) {
                librariesToAppendSourcesTo.put(library.getLibrary(), library);
            }
            if (librariesToAppendSourcesTo.size() == 1) {
                ChooseAndAttachSourcesAction.appendSources(firstLibrary, files);
            } else {
                librariesToAppendSourcesTo.put(null, null);
                String title = ProjectBundle.message((String)"library.choose.one.to.attach", (Object[])new Object[0]);
                ArrayList entries = ContainerUtil.newArrayList(librariesToAppendSourcesTo.values());
                JBPopupFactory.getInstance().createListPopup((ListPopupStep)new BaseListPopupStep<LibraryOrderEntry>(title, (List)entries, (Map)librariesToAppendSourcesTo){
                    final /* synthetic */ Map val$librariesToAppendSourcesTo;
                    {
                        this.val$librariesToAppendSourcesTo = map;
                        super(arg0, arg1);
                    }

                    public ListSeparator getSeparatorAbove(LibraryOrderEntry value) {
                        return value == null ? new ListSeparator() : null;
                    }

                    @NotNull
                    public String getTextFor(LibraryOrderEntry value) {
                        String string = value == null ? "All" : value.getPresentableName() + " (" + value.getOwnerModule().getName() + ")";
                        if (string == null) {
                            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/AttachSourcesNotificationProvider$ChooseAndAttachSourcesAction$1", "getTextFor"));
                        }
                        return string;
                    }

                    public PopupStep onChosen(LibraryOrderEntry libraryOrderEntry, boolean finalChoice) {
                        if (libraryOrderEntry != null) {
                            ChooseAndAttachSourcesAction.appendSources(libraryOrderEntry.getLibrary(), files);
                        } else {
                            for (Library libOrderEntry : this.val$librariesToAppendSourcesTo.keySet()) {
                                if (libOrderEntry == null) continue;
                                ChooseAndAttachSourcesAction.appendSources(libOrderEntry, files);
                            }
                        }
                        return FINAL_CHOICE;
                    }
                }).showCenteredInCurrentWindow(this.myProject);
            }
            return ActionCallback.DONE;
        }

        private static void appendSources(final Library library, final VirtualFile[] files) {
            ApplicationManager.getApplication().runWriteAction(new Runnable(){

                @Override
                public void run() {
                    Library.ModifiableModel model = library.getModifiableModel();
                    for (VirtualFile virtualFile : files) {
                        model.addRoot(virtualFile, OrderRootType.SOURCES);
                    }
                    model.commit();
                }
            });
        }
    }

    private static class AttachJarAsSourcesAction
    implements AttachSourcesProvider.AttachSourcesAction {
        private final VirtualFile myClassFile;

        public AttachJarAsSourcesAction(VirtualFile classFile) {
            this.myClassFile = classFile;
        }

        public String getName() {
            return ProjectBundle.message((String)"module.libraries.attach.sources.button", (Object[])new Object[0]);
        }

        public String getBusyText() {
            return ProjectBundle.message((String)"library.attach.sources.action.busy.text", (Object[])new Object[0]);
        }

        public ActionCallback perform(List<LibraryOrderEntry> orderEntriesContainingFile) {
            final ArrayList<Library.ModifiableModel> modelsToCommit = new ArrayList<Library.ModifiableModel>();
            for (LibraryOrderEntry orderEntry : orderEntriesContainingFile) {
                VirtualFile root;
                Library library = orderEntry.getLibrary();
                if (library == null || (root = this.findRoot(library)) == null) continue;
                Library.ModifiableModel model = library.getModifiableModel();
                model.addRoot(root, OrderRootType.SOURCES);
                modelsToCommit.add(model);
            }
            if (modelsToCommit.isEmpty()) {
                return ActionCallback.REJECTED;
            }
            new WriteAction(){

                protected void run(@NotNull Result result) {
                    if (result == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/codeInsight/daemon/impl/AttachSourcesNotificationProvider$AttachJarAsSourcesAction$1", "run"));
                    }
                    for (Library.ModifiableModel model : modelsToCommit) {
                        model.commit();
                    }
                }
            }.execute();
            return ActionCallback.DONE;
        }

        @Nullable
        private VirtualFile findRoot(Library library) {
            for (VirtualFile classesRoot : library.getFiles(OrderRootType.CLASSES)) {
                if (!VfsUtilCore.isAncestor((VirtualFile)classesRoot, (VirtualFile)this.myClassFile, (boolean)true)) continue;
                return classesRoot;
            }
            return null;
        }
    }
}

