/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight;

import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.codeStyle.Indent;
import com.intellij.util.codeInsight.CommentUtilCore;
import com.intellij.util.text.CharArrayUtil;

public class CommentUtil
extends CommentUtilCore {
    private CommentUtil() {
    }

    public static Indent getMinLineIndent(Project project2, Document document, int line1, int line2, FileType fileType) {
        CharSequence chars = document.getCharsSequence();
        CodeStyleManager codeStyleManager = CodeStyleManager.getInstance((Project)project2);
        Indent minIndent = null;
        for (int line = line1; line <= line2; ++line) {
            int lineStart = document.getLineStartOffset(line);
            int textStart = CharArrayUtil.shiftForward((CharSequence)chars, (int)lineStart, (String)" \t");
            if (textStart >= document.getTextLength()) {
                textStart = document.getTextLength();
            } else {
                char c = chars.charAt(textStart);
                if (c == '\n' || c == '\r') continue;
            }
            String space = chars.subSequence(lineStart, textStart).toString();
            Indent indent = codeStyleManager.getIndent(space, fileType);
            minIndent = minIndent != null ? indent.min(minIndent) : indent;
        }
        if (minIndent == null && line1 == line2 && line1 < document.getLineCount() - 1) {
            return CommentUtil.getMinLineIndent(project2, document, line1 + 1, line1 + 1, fileType);
        }
        return minIndent;
    }
}

