/*
 * Decompiled with CFR 0.152.
 */
import com.intellij.TestAll;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.testFramework.TestRunnerUtil;
import java.io.File;
import java.nio.charset.Charset;
import java.util.List;
import javax.swing.SwingUtilities;
import junit.framework.TestCase;

public class _FirstInSuiteTest
extends TestCase {
    public static long suiteStarted = 0L;
    public static boolean nothingIsCalled = false;

    public void testReportClassLoadingProblems() {
        List<Throwable> problems = TestAll.getLoadingClassProblems();
        if (problems.isEmpty()) {
            return;
        }
        StringBuilder builder = new StringBuilder("The following test classes were not loaded:\n");
        for (Throwable each : problems) {
            builder.append(each.toString()).append("\n");
            each.printStackTrace(System.out);
        }
        throw new AssertionError((Object)builder.toString());
    }

    public void testNothing() throws Exception {
        if (nothingIsCalled) {
            return;
        }
        nothingIsCalled = true;
        suiteStarted = System.nanoTime();
        SwingUtilities.invokeAndWait(new Runnable(){

            @Override
            public void run() {
                System.out.println("EDT is " + Thread.currentThread());
            }
        });
        TestRunnerUtil.replaceIdeEventQueueSafely();
        SwingUtilities.invokeAndWait(new Runnable(){

            @Override
            public void run() {
                System.out.println("EDT is " + Thread.currentThread());
            }
        });
        Class.forName("com.sun.jna.Native");
        String tempDirectory = FileUtilRt.getTempDirectory();
        String[] list = new File(tempDirectory).list();
        System.out.println("FileUtil.getTempDirectory() = " + tempDirectory + " (" + list.length + " files)");
    }

    public void testNothingPerformance() throws Exception {
        this.testNothing();
    }

    public void testFileEncoding() {
        _FirstInSuiteTest.assertEncoding("file.encoding");
        _FirstInSuiteTest.assertEncoding("sun.jnu.encoding");
    }

    private static void assertEncoding(String property) {
        String encoding = System.getProperty(property);
        System.out.println("** " + property + "=" + encoding);
        _FirstInSuiteTest.assertNotNull((Object)encoding);
        _FirstInSuiteTest.assertFalse((boolean)Charset.forName(encoding).aliases().contains("default"));
    }
}

