/*
 * Decompiled with CFR 0.152.
 */
package com.esotericsoftware.kryo.serializers;

import com.esotericsoftware.kryo.Generics;
import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.serializers.FieldSerializer;
import com.esotericsoftware.kryo.serializers.ObjectField;
import com.esotericsoftware.minlog.Log;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.HashMap;

final class FieldSerializerGenericsUtil {
    private Kryo kryo;
    private FieldSerializer serializer;

    public FieldSerializerGenericsUtil(FieldSerializer fieldSerializer) {
        this.serializer = fieldSerializer;
        this.kryo = fieldSerializer.getKryo();
    }

    Generics buildGenericsScope(Class clazz, Class[] classArray) {
        TypeVariable<Class<T>>[] typeVariableArray = null;
        for (Class<?> clazz2 = clazz; clazz2 != null && ((typeVariableArray = clazz2.getTypeParameters()) == null || typeVariableArray.length == 0); clazz2 = clazz2.getComponentType()) {
        }
        if (typeVariableArray != null && typeVariableArray.length > 0) {
            Log.trace((String)"kryo", (String)("Class " + clazz.getName() + " has generic type parameters"));
            int n = 0;
            HashMap<String, Class> hashMap = new HashMap<String, Class>();
            for (TypeVariable typeVariable : typeVariableArray) {
                String string = typeVariable.getName();
                Class<?> clazz3 = this.getTypeVarConcreteClass(classArray, n, string);
                if (clazz3 != null) {
                    hashMap.put(string, clazz3);
                }
                ++n;
            }
            Generics generics = new Generics(hashMap);
            return generics;
        }
        return null;
    }

    private Class<?> getTypeVarConcreteClass(Class[] classArray, int n, String string) {
        if (classArray != null && classArray.length > n) {
            return classArray[n];
        }
        Generics generics = this.kryo.getGenericsScope();
        if (generics != null) {
            return generics.getConcreteClass(string);
        }
        return null;
    }

    Class[] computeFieldGenerics(Type type, Field field, Class[] classArray) {
        Class[] classArray2 = null;
        if (type != null) {
            if (type instanceof TypeVariable && this.serializer.getGenericsScope() != null) {
                TypeVariable typeVariable = (TypeVariable)type;
                Class clazz = this.serializer.getGenericsScope().getConcreteClass(typeVariable.getName());
                if (clazz != null) {
                    classArray[0] = clazz;
                    classArray2 = new Class[]{classArray[0]};
                }
            } else if (type instanceof ParameterizedType) {
                ParameterizedType parameterizedType = (ParameterizedType)type;
                Type[] typeArray = parameterizedType.getActualTypeArguments();
                if (typeArray != null) {
                    classArray2 = new Class[typeArray.length];
                    for (int i = 0; i < typeArray.length; ++i) {
                        Type type2 = typeArray[i];
                        if (type2 instanceof Class) {
                            classArray2[i] = (Class)type2;
                            continue;
                        }
                        if (type2 instanceof ParameterizedType) {
                            classArray2[i] = (Class)((ParameterizedType)type2).getRawType();
                            continue;
                        }
                        if (type2 instanceof TypeVariable && this.serializer.getGenericsScope() != null) {
                            classArray2[i] = this.serializer.getGenericsScope().getConcreteClass(((TypeVariable)type2).getName());
                            continue;
                        }
                        if (type2 instanceof WildcardType) {
                            classArray2[i] = Object.class;
                            continue;
                        }
                        if (type2 instanceof GenericArrayType) {
                            Class clazz;
                            Generics generics;
                            Type type3 = ((GenericArrayType)type2).getGenericComponentType();
                            if (type3 instanceof Class) {
                                classArray2[i] = Array.newInstance((Class)type3, 0).getClass();
                                continue;
                            }
                            if (!(type3 instanceof TypeVariable) || (generics = this.serializer.getGenericsScope()) == null || (clazz = generics.getConcreteClass(((TypeVariable)type3).getName())) == null) continue;
                            classArray2[i] = Array.newInstance(clazz, 0).getClass();
                            continue;
                        }
                        classArray2[i] = null;
                    }
                }
            } else if (type instanceof GenericArrayType) {
                GenericArrayType genericArrayType = (GenericArrayType)type;
                Type type4 = genericArrayType.getGenericComponentType();
                Class[] classArray3 = new Class[]{classArray[0]};
                classArray2 = this.computeFieldGenerics(type4, field, classArray3);
            }
        }
        return classArray2;
    }

    FieldSerializer.CachedField newCachedFieldOfGenericType(Field field, int n, Class[] classArray, Type type) {
        Class[] classArray2 = FieldSerializerGenericsUtil.getGenerics(type, this.kryo);
        Generics generics = this.buildGenericsScope(classArray[0], classArray2);
        if (classArray[0] == Object.class && type instanceof TypeVariable && this.serializer.getGenericsScope() != null) {
            TypeVariable typeVariable = (TypeVariable)type;
            Class clazz = this.serializer.getGenericsScope().getConcreteClass(typeVariable.getName());
            if (clazz != null) {
                generics = new Generics();
                generics.add(typeVariable.getName(), clazz);
            }
        }
        Class[] classArray3 = this.computeFieldGenerics(type, field, classArray);
        FieldSerializer.CachedField cachedField = this.serializer.newMatchingCachedField(field, n, classArray[0], type, classArray3);
        if (classArray3 != null && cachedField instanceof ObjectField && classArray3[0] != null) {
            ((ObjectField)cachedField).generics = classArray3;
        }
        return cachedField;
    }

    public static Class[] getGenerics(Type type, Kryo kryo) {
        if (type instanceof GenericArrayType) {
            Type type2 = ((GenericArrayType)type).getGenericComponentType();
            if (type2 instanceof Class) {
                return new Class[]{(Class)type2};
            }
            return FieldSerializerGenericsUtil.getGenerics(type2, kryo);
        }
        if (!(type instanceof ParameterizedType)) {
            return null;
        }
        Type[] typeArray = ((ParameterizedType)type).getActualTypeArguments();
        Class[] classArray = new Class[typeArray.length];
        int n = 0;
        for (Type type3 : typeArray) {
            Object object;
            Object object2;
            classArray[var5_6] = Object.class;
            if (type3 instanceof Class) {
                classArray[var5_6] = (Class)type3;
            } else if (type3 instanceof ParameterizedType) {
                classArray[var5_6] = (Class)((ParameterizedType)type3).getRawType();
            } else if (type3 instanceof TypeVariable) {
                object2 = kryo.getGenericsScope();
                if (object2 == null || (object = ((Generics)object2).getConcreteClass(((TypeVariable)type3).getName())) == null) continue;
                classArray[var5_6] = object;
            } else {
                if (!(type3 instanceof GenericArrayType)) continue;
                object2 = ((GenericArrayType)type3).getGenericComponentType();
                if (object2 instanceof Class) {
                    classArray[var5_6] = Array.newInstance((Class)object2, 0).getClass();
                } else if (object2 instanceof TypeVariable) {
                    Class clazz;
                    object = kryo.getGenericsScope();
                    if (object != null && (clazz = object.getConcreteClass(((TypeVariable)object2).getName())) != null) {
                        classArray[var5_6] = Array.newInstance(clazz, 0).getClass();
                    }
                } else {
                    object = FieldSerializerGenericsUtil.getGenerics((Type)object2, kryo);
                    if (object != null) {
                        classArray[var5_6] = object[0];
                    }
                }
            }
            ++n;
        }
        if (n == 0) {
            return null;
        }
        return classArray;
    }
}

