/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.index.creator;

import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.apache.lucene.document.Document;
import org.codehaus.plexus.component.annotations.Component;
import org.sonatype.nexus.index.ArtifactContext;
import org.sonatype.nexus.index.ArtifactInfo;
import org.sonatype.nexus.index.IndexerField;
import org.sonatype.nexus.index.context.IndexCreator;
import org.sonatype.nexus.index.creator.AbstractIndexCreator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Component(role=IndexCreator.class, hint="maven-archetype")
public class MavenArchetypeArtifactInfoIndexCreator
extends AbstractIndexCreator {
    public static final String ID = "maven-archetype";
    private static final String MAVEN_ARCHETYPE_PACKAGING = "maven-archetype";
    private static final String[] ARCHETYPE_XML_LOCATIONS = new String[]{"META-INF/maven/archetype.xml", "META-INF/archetype.xml", "META-INF/maven/archetype-metadata.xml"};

    @Override
    public void populateArtifactInfo(ArtifactContext ac) {
        File artifact = ac.getArtifact();
        ArtifactInfo ai = ac.getArtifactInfo();
        if (artifact != null && !"maven-archetype".equals(ai.packaging) && artifact.getName().endsWith(".jar")) {
            this.checkMavenArchetype(ai, artifact);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkMavenArchetype(ArtifactInfo ai, File artifact) {
        ZipFile jf = null;
        try {
            jf = new ZipFile(artifact);
            for (String location : ARCHETYPE_XML_LOCATIONS) {
                if (!this.checkEntry(ai, jf, location)) continue;
                return;
            }
        }
        catch (Exception e) {
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().info("Failed to parse Maven artifact " + artifact.getAbsolutePath() + " due to exception:", (Throwable)e);
            } else {
                this.getLogger().info("Failed to parse Maven artifact " + artifact.getAbsolutePath() + " due to " + e.getMessage());
            }
        }
        finally {
            this.close(jf);
        }
    }

    private boolean checkEntry(ArtifactInfo ai, ZipFile jf, String entryName) {
        ZipEntry entry = jf.getEntry(entryName);
        if (entry != null) {
            ai.packaging = "maven-archetype";
            return true;
        }
        return false;
    }

    @Override
    public void updateDocument(ArtifactInfo ai, Document doc) {
    }

    @Override
    public boolean updateArtifactInfo(Document doc, ArtifactInfo ai) {
        return false;
    }

    private void close(ZipFile zf) {
        if (zf != null) {
            try {
                zf.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public String toString() {
        return "maven-archetype";
    }

    @Override
    public Collection<IndexerField> getIndexerFields() {
        return Collections.emptyList();
    }
}

