/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.swing.ui;

import com.android.tools.idea.editors.theme.ThemeEditorConstants;
import com.android.tools.swing.ui.ClickableLabel;
import com.android.tools.swing.util.GraphicsUtil;
import com.intellij.ui.Gray;
import com.intellij.ui.JBColor;
import com.intellij.ui.RoundedLineBorder;
import com.intellij.ui.components.JBTextField;
import com.intellij.util.ui.JBUI;
import icons.AndroidIcons;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.event.ActionListener;
import java.awt.geom.RoundRectangle2D;
import java.awt.image.BufferedImage;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.border.Border;
import javax.swing.event.DocumentListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SwatchComponent
extends Box {
    private static final int PADDING = JBUI.scale((int)3);
    private static final int TEXT_PADDING = JBUI.scale((int)8);
    private static final int ARC_SIZE = ThemeEditorConstants.ROUNDED_BORDER_ARC_SIZE;
    private static final Color DEFAULT_BORDER_COLOR = Gray._170;
    private static final Color WARNING_BORDER_COLOR = JBColor.ORANGE;
    public static final SwatchIcon WARNING_ICON = new SwatchIcon(){

        @Override
        public void paintSwatch(@NotNull Component c, @NotNull Graphics g, int x, int y, int w, int h) {
            if (c == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "c", "com/android/tools/swing/ui/SwatchComponent$1", "paintSwatch"));
            }
            if (g == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "g", "com/android/tools/swing/ui/SwatchComponent$1", "paintSwatch"));
            }
            Icon QUESTION_ICON = AndroidIcons.GreyQuestionMark;
            int horizontalMargin = (w + JBUI.scale((int)1) - QUESTION_ICON.getIconWidth()) / 2;
            int verticalMargin = (h + JBUI.scale((int)3) - QUESTION_ICON.getIconHeight()) / 2;
            QUESTION_ICON.paintIcon(c, g, x + horizontalMargin, y + verticalMargin);
        }
    };
    private final JBTextField myTextField;
    private final ClickableLabel mySwatchButton;
    private Color myBorderColor;

    public SwatchComponent() {
        super(2);
        this.setBorder(null);
        this.myBorderColor = DEFAULT_BORDER_COLOR;
        this.mySwatchButton = new ClickableLabel();
        this.myTextField = new JBTextField(){

            protected void paintComponent(Graphics graphics) {
                com.intellij.util.ui.GraphicsUtil.setupAAPainting((Graphics)graphics);
                Graphics2D g = (Graphics2D)graphics;
                Shape savedClip = g.getClip();
                RoundRectangle2D.Double clipRectangle = new RoundRectangle2D.Double(0.0, 0.0, this.getWidth(), this.getHeight(), ARC_SIZE, ARC_SIZE);
                g.clip(clipRectangle);
                super.paintComponent((Graphics)g);
                g.setClip(savedClip);
            }
        };
        final Insets insets = this.myTextField.getInsets();
        this.myTextField.setBorder((Border)new RoundedLineBorder(this.myBorderColor, ARC_SIZE, 1){

            public Insets getBorderInsets(Component c) {
                return insets;
            }
        });
        this.add(this.mySwatchButton);
        this.add(Box.createHorizontalStrut(PADDING));
        this.add((Component)this.myTextField);
    }

    public void setSwatchIcon(@NotNull SwatchIcon icon) {
        if (icon == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "icon", "com/android/tools/swing/ui/SwatchComponent", "setSwatchIcon"));
        }
        int iconSize = this.getMinimumSize().height;
        icon.setSize(iconSize);
        icon.setBackgroundColor(this.getBackground());
        this.mySwatchButton.setIcon(icon);
    }

    public void showStack(boolean show) {
        ((SwatchIcon)this.mySwatchButton.getIcon()).setIsStack(show);
    }

    public void setWarningBorder(boolean isWarning) {
        this.myBorderColor = isWarning ? WARNING_BORDER_COLOR : DEFAULT_BORDER_COLOR;
    }

    @Override
    public void setFont(Font font) {
        super.setFont(font);
        if (this.myTextField != null) {
            this.myTextField.setFont(font);
        }
    }

    @Override
    public Dimension getMinimumSize() {
        if (!this.isPreferredSizeSet()) {
            FontMetrics fm = this.getFontMetrics(this.getFont());
            return new Dimension(0, fm.getHeight() + 2 * TEXT_PADDING);
        }
        return super.getPreferredSize();
    }

    @Override
    public Dimension getPreferredSize() {
        if (!this.isPreferredSizeSet()) {
            return this.getMinimumSize();
        }
        return super.getPreferredSize();
    }

    public void setText(@NotNull String text) {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/android/tools/swing/ui/SwatchComponent", "setText"));
        }
        this.myTextField.setText(text);
    }

    @NotNull
    public String getText() {
        String string = this.myTextField.getText();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/swing/ui/SwatchComponent", "getText"));
        }
        return string;
    }

    public void addSwatchListener(@NotNull ActionListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/android/tools/swing/ui/SwatchComponent", "addSwatchListener"));
        }
        this.mySwatchButton.addActionListener(listener);
    }

    public void addTextListener(@NotNull ActionListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/android/tools/swing/ui/SwatchComponent", "addTextListener"));
        }
        this.myTextField.addActionListener(listener);
    }

    public void addTextDocumentListener(@NotNull DocumentListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/android/tools/swing/ui/SwatchComponent", "addTextDocumentListener"));
        }
        this.myTextField.getDocument().addDocumentListener(listener);
    }

    public boolean hasWarningIcon() {
        return WARNING_ICON.equals(this.mySwatchButton.getIcon());
    }

    public static abstract class SwatchIcon
    implements Icon {
        private static final int SPACING = JBUI.scale((int)3);
        private static final int TRIANGLE_SIZE = JBUI.scale((int)13);
        private int mySize;
        private boolean myIsStack;
        private Color myBackgroundColor;

        @Override
        public void paintIcon(Component c, Graphics graphics, int x, int y) {
            com.intellij.util.ui.GraphicsUtil.setupAAPainting((Graphics)graphics);
            Graphics2D g = (Graphics2D)graphics;
            if (this.myIsStack) {
                this.paintStack(c, g);
            } else {
                this.paintSingleIcon(c, g);
            }
        }

        protected abstract void paintSwatch(@NotNull Component var1, @NotNull Graphics var2, int var3, int var4, int var5, int var6);

        private void paintSingleIcon(@NotNull Component c, @NotNull Graphics2D g) {
            if (c == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "c", "com/android/tools/swing/ui/SwatchComponent$SwatchIcon", "paintSingleIcon"));
            }
            if (g == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "g", "com/android/tools/swing/ui/SwatchComponent$SwatchIcon", "paintSingleIcon"));
            }
            g.setColor(this.myBackgroundColor);
            g.fillRect(0, 0, this.mySize - 1, this.mySize - 1);
            Shape savedClip = g.getClip();
            RoundRectangle2D.Double clipRectangle = new RoundRectangle2D.Double(0.0, 0.0, this.mySize - 1, this.mySize - 1, ARC_SIZE, ARC_SIZE);
            g.clip(clipRectangle);
            this.paintSwatch(c, g, 0, 0, this.mySize - 1, this.mySize - 1);
            g.setColor((Color)JBColor.WHITE);
            g.fillPolygon(new int[]{this.mySize - TRIANGLE_SIZE, this.mySize - 1, this.mySize - 1}, new int[]{this.mySize - 1, this.mySize - 1, this.mySize - TRIANGLE_SIZE}, 3);
            g.setClip(savedClip);
            g.setColor(DEFAULT_BORDER_COLOR);
            g.drawRoundRect(0, 0, this.mySize - 1, this.mySize - 1, ARC_SIZE, ARC_SIZE);
            g.drawLine(this.mySize - 1 - TRIANGLE_SIZE, this.mySize - 1, this.mySize - 1, this.mySize - 1 - TRIANGLE_SIZE);
        }

        private void paintStack(@NotNull Component c, @NotNull Graphics2D g) {
            if (c == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "c", "com/android/tools/swing/ui/SwatchComponent$SwatchIcon", "paintStack"));
            }
            if (g == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "g", "com/android/tools/swing/ui/SwatchComponent$SwatchIcon", "paintStack"));
            }
            g.setColor(this.myBackgroundColor);
            g.fillRect(0, 0, this.mySize - 1, this.mySize - 1);
            Shape savedClip = g.getClip();
            int smallSize = this.mySize - 2 * SPACING - 1;
            g.setColor(DEFAULT_BORDER_COLOR);
            g.drawRoundRect(2 * SPACING, 0, smallSize, smallSize, ARC_SIZE, ARC_SIZE);
            g.drawRoundRect(SPACING, SPACING, smallSize, smallSize, ARC_SIZE, ARC_SIZE);
            g.setColor(this.myBackgroundColor);
            g.fillRoundRect(SPACING + 1, SPACING + 1, smallSize - 1, smallSize - 1, ARC_SIZE, ARC_SIZE);
            RoundRectangle2D.Double clipRectangle = new RoundRectangle2D.Double(0.0, 2 * SPACING, smallSize + 1, smallSize + 1, ARC_SIZE, ARC_SIZE);
            g.clip(clipRectangle);
            this.paintSwatch(c, g, 0, 2 * SPACING, smallSize, smallSize);
            g.setColor((Color)JBColor.WHITE);
            g.fillPolygon(new int[]{smallSize + 1 - TRIANGLE_SIZE + SPACING, smallSize, smallSize}, new int[]{this.mySize - 1, this.mySize - 1, this.mySize - TRIANGLE_SIZE + SPACING}, 3);
            g.setClip(savedClip);
            g.setColor(DEFAULT_BORDER_COLOR);
            g.drawRoundRect(0, 2 * SPACING, smallSize, smallSize, ARC_SIZE, ARC_SIZE);
            g.drawLine(smallSize - TRIANGLE_SIZE + SPACING, this.mySize - 1, smallSize, this.mySize - 1 - TRIANGLE_SIZE + SPACING);
        }

        @Override
        public int getIconWidth() {
            return this.mySize;
        }

        @Override
        public int getIconHeight() {
            return this.mySize;
        }

        public void setSize(int size) {
            this.mySize = size;
        }

        public void setIsStack(boolean isStack) {
            this.myIsStack = isStack;
        }

        public void setBackgroundColor(@Nullable Color backgroundColor) {
            this.myBackgroundColor = backgroundColor;
        }
    }

    public static class TextIcon
    extends SwatchIcon {
        private final Font myFont;
        private final String myText;

        public TextIcon(String text, @NotNull Font font) {
            if (font == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "font", "com/android/tools/swing/ui/SwatchComponent$TextIcon", "<init>"));
            }
            this.myText = text;
            this.myFont = font;
        }

        @Override
        protected void paintSwatch(@NotNull Component c, @NotNull Graphics graphics, int x, int y, int w, int h) {
            if (c == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "c", "com/android/tools/swing/ui/SwatchComponent$TextIcon", "paintSwatch"));
            }
            if (graphics == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "graphics", "com/android/tools/swing/ui/SwatchComponent$TextIcon", "paintSwatch"));
            }
            Graphics2D g = (Graphics2D)graphics;
            g.setColor((Color)JBColor.LIGHT_GRAY);
            g.fillRect(x, y, w, h);
            g.setColor((Color)JBColor.DARK_GRAY);
            g.setFont(this.myFont);
            GraphicsUtil.drawCenteredString(g, new Rectangle(x, y, w, h), this.myText);
        }
    }

    public static class SquareImageIcon
    extends SwatchIcon {
        private final ImageIcon myImageIcon;

        public SquareImageIcon(@NotNull BufferedImage image) {
            if (image == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "image", "com/android/tools/swing/ui/SwatchComponent$SquareImageIcon", "<init>"));
            }
            this.myImageIcon = new ImageIcon(image);
        }

        @Override
        public void paintSwatch(@NotNull Component c, @NotNull Graphics g, int x, int y, int w, int h) {
            if (c == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "c", "com/android/tools/swing/ui/SwatchComponent$SquareImageIcon", "paintSwatch"));
            }
            if (g == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "g", "com/android/tools/swing/ui/SwatchComponent$SquareImageIcon", "paintSwatch"));
            }
            Image image = this.myImageIcon.getImage();
            GraphicsUtil.paintCheckeredBackground(g, new Rectangle(x, y, w, h));
            g.drawImage(image, x, y, w, h, c);
        }
    }

    public static class ColorIcon
    extends SwatchIcon {
        private final Color myColor;

        public ColorIcon(@NotNull Color color) {
            if (color == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "color", "com/android/tools/swing/ui/SwatchComponent$ColorIcon", "<init>"));
            }
            this.myColor = color;
        }

        @Override
        public void paintSwatch(@NotNull Component c, @NotNull Graphics g, int x, int y, int w, int h) {
            if (c == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "c", "com/android/tools/swing/ui/SwatchComponent$ColorIcon", "paintSwatch"));
            }
            if (g == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "g", "com/android/tools/swing/ui/SwatchComponent$ColorIcon", "paintSwatch"));
            }
            if (this.myColor.getAlpha() != 255) {
                GraphicsUtil.paintCheckeredBackground(g, new Rectangle(x, y, w, h));
            }
            g.setColor(this.myColor);
            g.fillRect(x, y, w, h);
        }
    }
}

