/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.run;

import com.android.ddmlib.IDevice;
import com.android.sdklib.AndroidVersion;
import com.android.tools.idea.ddms.DevicePropertyUtil;
import com.android.tools.idea.gradle.invoker.GradleInvoker;
import com.android.tools.idea.gradle.run.MakeBeforeRunTaskProvider;
import com.android.tools.idea.gradle.util.AndroidGradleSettings;
import com.android.tools.idea.gradle.util.BuildMode;
import com.android.tools.idea.gradle.util.Projects;
import com.android.tools.idea.run.AndroidRunConfigurationBase;
import com.android.tools.idea.run.DeviceTarget;
import com.intellij.execution.configurations.ModuleRunProfile;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.compiler.CompileScope;
import com.intellij.openapi.compiler.CompilerManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GradleInvokerOptions {
    @NotNull
    public final List<String> tasks;
    @Nullable
    public final BuildMode buildMode;
    @NotNull
    public final List<String> commandLineArguments;
    private static final String PROPERTY_BUILD_API = "android.injected.build.api";

    private GradleInvokerOptions(@NotNull List<String> tasks, @Nullable BuildMode buildMode, @NotNull List<String> commandLineArguments) {
        if (tasks == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tasks", "com/android/tools/idea/gradle/run/GradleInvokerOptions", "<init>"));
        }
        if (commandLineArguments == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "commandLineArguments", "com/android/tools/idea/gradle/run/GradleInvokerOptions", "<init>"));
        }
        this.tasks = tasks;
        this.buildMode = buildMode;
        this.commandLineArguments = commandLineArguments;
    }

    public static GradleInvokerOptions create(@NotNull Project project, @Nullable DataContext context, @NotNull RunConfiguration configuration, @NotNull ExecutionEnvironment env, @Nullable String userGoal) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/run/GradleInvokerOptions", "create"));
        }
        if (configuration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configuration", "com/android/tools/idea/gradle/run/GradleInvokerOptions", "create"));
        }
        if (env == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "env", "com/android/tools/idea/gradle/run/GradleInvokerOptions", "create"));
        }
        Collection<IDevice> devices = GradleInvokerOptions.getTargetDevices(env);
        List<String> cmdLineArgs = GradleInvokerOptions.getGradleArgumentsToTarget(devices);
        if (!StringUtil.isEmpty((String)userGoal)) {
            return new GradleInvokerOptions(Collections.singletonList(userGoal), null, cmdLineArgs);
        }
        Module[] modules = GradleInvokerOptions.getModules(project, context, configuration);
        if (MakeBeforeRunTaskProvider.isUnitTestConfiguration(configuration)) {
            Module[] affectedModules = GradleInvokerOptions.getAffectedModules(project, modules);
            BuildMode buildMode = BuildMode.COMPILE_JAVA;
            List<String> tasks = GradleInvoker.findTasksToExecute(affectedModules, buildMode, GradleInvoker.TestCompileType.JAVA_TESTS);
            return new GradleInvokerOptions(tasks, buildMode, cmdLineArgs);
        }
        BuildMode buildMode = BuildMode.ASSEMBLE;
        GradleInvoker.TestCompileType testCompileType = GradleInvokerOptions.getTestCompileType(configuration);
        List<String> tasks = GradleInvoker.findTasksToExecute(modules, buildMode, testCompileType);
        return new GradleInvokerOptions(tasks, buildMode, cmdLineArgs);
    }

    @NotNull
    private static Module[] getModules(@NotNull Project project, @Nullable DataContext context, @Nullable RunConfiguration configuration) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/run/GradleInvokerOptions", "getModules"));
        }
        if (configuration instanceof ModuleRunProfile) {
            Module[] moduleArray = ((ModuleRunProfile)configuration).getModules();
            if (moduleArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/run/GradleInvokerOptions", "getModules"));
            }
            return moduleArray;
        }
        Module[] moduleArray = Projects.getModulesToBuildFromSelection(project, context);
        if (moduleArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/run/GradleInvokerOptions", "getModules"));
        }
        return moduleArray;
    }

    @NotNull
    private static Module[] getAffectedModules(@NotNull Project project, @NotNull Module[] modules) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/run/GradleInvokerOptions", "getAffectedModules"));
        }
        if (modules == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modules", "com/android/tools/idea/gradle/run/GradleInvokerOptions", "getAffectedModules"));
        }
        CompilerManager compilerManager = CompilerManager.getInstance((Project)project);
        CompileScope scope = compilerManager.createModulesCompileScope(modules, true, true);
        Module[] moduleArray = scope.getAffectedModules();
        if (moduleArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/run/GradleInvokerOptions", "getAffectedModules"));
        }
        return moduleArray;
    }

    @NotNull
    private static GradleInvoker.TestCompileType getTestCompileType(@Nullable RunConfiguration runConfiguration) {
        String id = runConfiguration != null ? runConfiguration.getType().getId() : null;
        GradleInvoker.TestCompileType testCompileType = GradleInvoker.getTestCompileType(id);
        if (testCompileType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/run/GradleInvokerOptions", "getTestCompileType"));
        }
        return testCompileType;
    }

    @NotNull
    private static List<String> getGradleArgumentsToTarget(Collection<IDevice> devices) {
        if (!devices.isEmpty()) {
            AndroidVersion min = null;
            for (IDevice device : devices) {
                AndroidVersion version = DevicePropertyUtil.getDeviceVersion(device);
                if (version == AndroidVersion.DEFAULT || min != null && version.getFeatureLevel() >= min.getFeatureLevel()) continue;
                min = version;
            }
            if (min != null) {
                String property = AndroidGradleSettings.createProjectProperty((String)PROPERTY_BUILD_API, (String)min.getApiString());
                List<String> list = Collections.singletonList(property);
                if (list == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/run/GradleInvokerOptions", "getGradleArgumentsToTarget"));
                }
                return list;
            }
        }
        List<String> list = Collections.emptyList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/run/GradleInvokerOptions", "getGradleArgumentsToTarget"));
        }
        return list;
    }

    @NotNull
    private static Collection<IDevice> getTargetDevices(@NotNull ExecutionEnvironment env) {
        if (env == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "env", "com/android/tools/idea/gradle/run/GradleInvokerOptions", "getTargetDevices"));
        }
        DeviceTarget deviceTarget = (DeviceTarget)env.getCopyableUserData(AndroidRunConfigurationBase.DEVICE_TARGET_KEY);
        if (deviceTarget == null) {
            List<IDevice> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/run/GradleInvokerOptions", "getTargetDevices"));
            }
            return list;
        }
        Collection<IDevice> readyDevices = deviceTarget.getDevicesIfReady();
        Collection<Object> collection = readyDevices == null ? Collections.emptyList() : readyDevices;
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/run/GradleInvokerOptions", "getTargetDevices"));
        }
        return collection;
    }
}

