/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.editors.gfxtrace.controllers;

import com.android.tools.idea.editors.gfxtrace.GfxTraceEditor;
import com.android.tools.idea.editors.gfxtrace.controllers.Controller;
import com.android.tools.idea.editors.gfxtrace.renderers.TreeRenderer;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.ui.components.JBLoadingPanel;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.ui.treeStructure.SimpleTree;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import javax.swing.JPanel;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeModel;
import org.jetbrains.annotations.NotNull;

public abstract class TreeController
extends Controller {
    public static final int TREE_ROW_HEIGHT = 19;
    @NotNull
    protected final JBLoadingPanel myLoadingPanel;
    @NotNull
    protected final JPanel myPanel;
    @NotNull
    protected final JBScrollPane myScrollPane;
    @NotNull
    protected final SimpleTree myTree;

    public TreeController(@NotNull GfxTraceEditor editor, @NotNull String emptyText) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/android/tools/idea/editors/gfxtrace/controllers/TreeController", "<init>"));
        }
        if (emptyText == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "emptyText", "com/android/tools/idea/editors/gfxtrace/controllers/TreeController", "<init>"));
        }
        super(editor);
        this.myPanel = new JPanel(new BorderLayout());
        this.myScrollPane = new JBScrollPane();
        this.myTree = new SimpleTree();
        this.myPanel.add((Component)this.myScrollPane, "Center");
        this.myTree.setRowHeight(19);
        this.myTree.setRootVisible(false);
        this.myTree.setLineStyleAngled();
        this.myTree.setCellRenderer(this.getRenderer());
        this.myTree.getEmptyText().setText(emptyText);
        this.myLoadingPanel = new JBLoadingPanel((LayoutManager)new BorderLayout(), (Disposable)editor.getProject());
        this.myLoadingPanel.add((Component)this.myTree);
        this.myScrollPane.setViewportView((Component)this.myLoadingPanel);
        this.myScrollPane.getHorizontalScrollBar().setUnitIncrement(19);
        this.myScrollPane.getVerticalScrollBar().setUnitIncrement(19);
    }

    @NotNull
    protected TreeCellRenderer getRenderer() {
        TreeRenderer treeRenderer = new TreeRenderer();
        if (treeRenderer == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/editors/gfxtrace/controllers/TreeController", "getRenderer"));
        }
        return treeRenderer;
    }

    @Override
    public void clear() {
        this.myTree.setModel(null);
    }

    public void setRoot(DefaultMutableTreeNode root) {
        assert (ApplicationManager.getApplication().isDispatchThread());
        this.myTree.setModel((TreeModel)new DefaultTreeModel(root));
        this.myLoadingPanel.stopLoading();
        this.myLoadingPanel.revalidate();
    }
}

