/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.avdmanager;

import com.android.resources.ScreenOrientation;
import com.android.sdklib.IAndroidTarget;
import com.android.sdklib.ISystemImage;
import com.android.sdklib.devices.Device;
import com.android.sdklib.devices.DeviceManager;
import com.android.sdklib.devices.Storage;
import com.android.sdklib.internal.avd.AvdInfo;
import com.android.tools.idea.avdmanager.AvdConfigurationPath;
import com.android.tools.idea.avdmanager.AvdManagerConnection;
import com.android.tools.idea.avdmanager.AvdScaleFactor;
import com.android.tools.idea.avdmanager.AvdWizardConstants;
import com.android.tools.idea.avdmanager.ConfigureAvdOptionsStep;
import com.android.tools.idea.avdmanager.DeviceManagerConnection;
import com.android.tools.idea.avdmanager.SystemImageDescription;
import com.android.tools.idea.ddms.screenshot.DeviceArtDescriptor;
import com.android.tools.idea.wizard.dynamic.DialogWrapperHost;
import com.android.tools.idea.wizard.dynamic.DynamicWizard;
import com.android.tools.idea.wizard.dynamic.ScopedStateStore;
import com.android.tools.idea.wizard.dynamic.SingleStepPath;
import com.google.common.base.Objects;
import com.google.common.base.Predicate;
import com.google.common.collect.Maps;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.io.FileUtil;
import java.io.File;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import javax.swing.Icon;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AvdEditWizard
extends DynamicWizard {
    @Nullable
    private final AvdInfo myAvdInfo;
    private final boolean myForceCreate;
    private final JComponent myParent;

    public AvdEditWizard(@NotNull JComponent parent, @Nullable Project project, @Nullable Module module, @Nullable AvdInfo avdInfo, boolean forceCreate) {
        if (parent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/android/tools/idea/avdmanager/AvdEditWizard", "<init>"));
        }
        super(project, module, "AvdEditWizard", new DialogWrapperHost(project, DialogWrapper.IdeModalityType.PROJECT));
        this.myAvdInfo = avdInfo;
        this.myForceCreate = forceCreate;
        this.myParent = parent;
        this.setTitle("Virtual Device Configuration");
    }

    @Override
    public void init() {
        if (this.myAvdInfo != null) {
            this.fillExistingInfo(this.myAvdInfo);
            if (this.myForceCreate) {
                String displayName = (String)this.myAvdInfo.getProperties().get(AvdWizardConstants.DISPLAY_NAME_KEY.name);
                this.getState().put(AvdWizardConstants.DISPLAY_NAME_KEY, String.format("Copy of %1$s", displayName));
            }
        } else {
            this.initDefaultInfo();
        }
        this.addPath(new AvdConfigurationPath(this.getDisposable()));
        ConfigureAvdOptionsStep configStep = new ConfigureAvdOptionsStep(this.getDisposable());
        this.addPath(new SingleStepPath(configStep));
        super.init();
        if (this.myForceCreate && this.myAvdInfo != null) {
            this.getState().put(AvdWizardConstants.IS_IN_EDIT_MODE_KEY, false);
        }
    }

    private void initDefaultInfo() {
        ScopedStateStore state = this.getState();
        state.put(AvdWizardConstants.SCALE_SELECTION_KEY, AvdWizardConstants.DEFAULT_SCALE);
        state.put(AvdWizardConstants.NETWORK_SPEED_KEY, "full");
        state.put(AvdWizardConstants.NETWORK_LATENCY_KEY, "none");
        state.put(AvdWizardConstants.FRONT_CAMERA_KEY, "none");
        state.put(AvdWizardConstants.BACK_CAMERA_KEY, "none");
        state.put(AvdWizardConstants.INTERNAL_STORAGE_KEY, AvdWizardConstants.DEFAULT_INTERNAL_STORAGE);
        state.put(AvdWizardConstants.IS_IN_EDIT_MODE_KEY, false);
        state.put(AvdWizardConstants.USE_HOST_GPU_KEY, true);
        state.put(AvdWizardConstants.DISPLAY_SD_SIZE_KEY, new Storage(100L, Storage.Unit.MiB));
        state.put(AvdWizardConstants.DISPLAY_USE_EXTERNAL_SD_KEY, false);
    }

    private void fillExistingInfo(@NotNull AvdInfo avdInfo) {
        File skinFile;
        String backupSkinPath;
        File skinFile2;
        String skinPath;
        ISystemImage selectedImage;
        if (avdInfo == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "avdInfo", "com/android/tools/idea/avdmanager/AvdEditWizard", "fillExistingInfo"));
        }
        ScopedStateStore state = this.getState();
        List<Device> devices = DeviceManagerConnection.getDefaultDeviceManagerConnection().getDevices();
        Device selectedDevice = null;
        String manufacturer = avdInfo.getDeviceManufacturer();
        String deviceId = (String)avdInfo.getProperties().get("hw.device.name");
        for (Device device : devices) {
            if (!manufacturer.equals(device.getManufacturer()) || !deviceId.equals(device.getId())) continue;
            selectedDevice = device;
            break;
        }
        state.put(AvdWizardConstants.DEVICE_DEFINITION_KEY, selectedDevice);
        IAndroidTarget target = avdInfo.getTarget();
        if (target != null && (selectedImage = target.getSystemImage(avdInfo.getTag(), avdInfo.getAbiType())) != null) {
            SystemImageDescription systemImageDescription = new SystemImageDescription(target, selectedImage);
            state.put(AvdWizardConstants.SYSTEM_IMAGE_KEY, systemImageDescription);
        }
        Map properties = avdInfo.getProperties();
        state.put(AvdWizardConstants.RAM_STORAGE_KEY, AvdEditWizard.getStorageFromIni((String)properties.get(AvdWizardConstants.RAM_STORAGE_KEY.name)));
        state.put(AvdWizardConstants.VM_HEAP_STORAGE_KEY, AvdEditWizard.getStorageFromIni((String)properties.get(AvdWizardConstants.VM_HEAP_STORAGE_KEY.name)));
        state.put(AvdWizardConstants.INTERNAL_STORAGE_KEY, AvdEditWizard.getStorageFromIni((String)properties.get(AvdWizardConstants.INTERNAL_STORAGE_KEY.name)));
        String sdCardLocation = null;
        if (properties.get(AvdWizardConstants.EXISTING_SD_LOCATION.name) != null) {
            sdCardLocation = (String)properties.get(AvdWizardConstants.EXISTING_SD_LOCATION.name);
        } else if (properties.get(AvdWizardConstants.SD_CARD_STORAGE_KEY.name) != null) {
            sdCardLocation = FileUtil.join((String[])new String[]{avdInfo.getDataFolderPath(), "sdcard.img"});
        }
        state.put(AvdWizardConstants.EXISTING_SD_LOCATION, sdCardLocation);
        String dataFolderPath = avdInfo.getDataFolderPath();
        File sdLocationFile = null;
        if (sdCardLocation != null) {
            sdLocationFile = new File(sdCardLocation);
        }
        if (sdLocationFile != null && Objects.equal((Object)sdLocationFile.getParent(), (Object)dataFolderPath)) {
            File sdFile = new File(sdCardLocation);
            Storage sdCardSize = new Storage(sdFile.length());
            this.myState.put(AvdWizardConstants.DISPLAY_USE_EXTERNAL_SD_KEY, false);
            this.myState.put(AvdWizardConstants.SD_CARD_STORAGE_KEY, sdCardSize);
            this.myState.put(AvdWizardConstants.DISPLAY_SD_SIZE_KEY, sdCardSize);
        } else {
            this.myState.put(AvdWizardConstants.DISPLAY_USE_EXTERNAL_SD_KEY, true);
            this.myState.put(AvdWizardConstants.DISPLAY_SD_LOCATION_KEY, sdCardLocation);
        }
        String scale = (String)properties.get(AvdWizardConstants.SCALE_SELECTION_KEY.name);
        if (scale != null) {
            state.put(AvdWizardConstants.SCALE_SELECTION_KEY, AvdScaleFactor.findByValue(scale));
        }
        state.put(AvdWizardConstants.USE_HOST_GPU_KEY, AvdEditWizard.fromIniString((String)properties.get(AvdWizardConstants.USE_HOST_GPU_KEY.name)));
        state.put(AvdWizardConstants.USE_SNAPSHOT_KEY, AvdEditWizard.fromIniString((String)properties.get(AvdWizardConstants.USE_SNAPSHOT_KEY.name)));
        state.put(AvdWizardConstants.FRONT_CAMERA_KEY, properties.get(AvdWizardConstants.FRONT_CAMERA_KEY.name));
        state.put(AvdWizardConstants.BACK_CAMERA_KEY, properties.get(AvdWizardConstants.BACK_CAMERA_KEY.name));
        state.put(AvdWizardConstants.NETWORK_LATENCY_KEY, properties.get(AvdWizardConstants.NETWORK_LATENCY_KEY.name));
        state.put(AvdWizardConstants.NETWORK_SPEED_KEY, properties.get(AvdWizardConstants.NETWORK_SPEED_KEY.name));
        state.put(AvdWizardConstants.HAS_HARDWARE_KEYBOARD_KEY, AvdEditWizard.fromIniString((String)properties.get(AvdWizardConstants.HAS_HARDWARE_KEYBOARD_KEY.name)));
        state.put(AvdWizardConstants.DISPLAY_NAME_KEY, AvdManagerConnection.getAvdDisplayName(avdInfo));
        String orientation = (String)properties.get("hw.initialOrientation");
        if (orientation != null) {
            state.put(AvdWizardConstants.DEFAULT_ORIENTATION_KEY, ScreenOrientation.getByShortDisplayName((String)orientation));
        }
        if ((skinPath = (String)properties.get(AvdWizardConstants.CUSTOM_SKIN_FILE_KEY.name)) != null && (skinFile2 = skinPath.equals(AvdWizardConstants.NO_SKIN.getPath()) ? AvdWizardConstants.NO_SKIN : new File(skinPath)).isDirectory()) {
            state.put(AvdWizardConstants.CUSTOM_SKIN_FILE_KEY, skinFile2);
        }
        if ((backupSkinPath = (String)properties.get(AvdWizardConstants.BACKUP_SKIN_FILE_KEY.name)) != null && ((skinFile = new File(backupSkinPath)).isDirectory() || FileUtil.filesEqual((File)skinFile, (File)AvdWizardConstants.NO_SKIN))) {
            state.put(AvdWizardConstants.BACKUP_SKIN_FILE_KEY, skinFile);
        }
        state.put(AvdWizardConstants.IS_IN_EDIT_MODE_KEY, true);
    }

    @Nullable
    private static Storage getStorageFromIni(String iniString) {
        if (iniString == null) {
            return null;
        }
        String numString = iniString.substring(0, iniString.length() - 1);
        char unitChar = iniString.charAt(iniString.length() - 1);
        Storage.Unit selectedUnit = null;
        for (Storage.Unit u : Storage.Unit.values()) {
            if (u.toString().charAt(0) != unitChar) continue;
            selectedUnit = u;
            break;
        }
        if (selectedUnit == null) {
            selectedUnit = Storage.Unit.MiB;
            numString = iniString;
        }
        try {
            long numLong = Long.parseLong(numString);
            return new Storage(numLong, selectedUnit);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    @Override
    public void performFinishingActions() {
        IAndroidTarget target;
        File backupSkinFile;
        boolean hasSdCard;
        boolean useExisting;
        Device device = this.myState.get(AvdWizardConstants.DEVICE_DEFINITION_KEY);
        assert (device != null);
        SystemImageDescription systemImageDescription = this.myState.get(AvdWizardConstants.SYSTEM_IMAGE_KEY);
        assert (systemImageDescription != null);
        ScreenOrientation orientation = this.myState.get(AvdWizardConstants.DEFAULT_ORIENTATION_KEY);
        if (orientation == null) {
            orientation = device.getDefaultState().getOrientation();
        }
        Map hardwareProperties = DeviceManager.getHardwareProperties((Device)device);
        Map userEditedProperties = this.myState.flatten();
        String sdCard = null;
        Boolean useExternalSdCard = this.myState.get(AvdWizardConstants.DISPLAY_USE_EXTERNAL_SD_KEY);
        boolean bl = useExisting = useExternalSdCard != null && useExternalSdCard != false;
        if (!useExisting && Objects.equal((Object)this.myState.get(AvdWizardConstants.SD_CARD_STORAGE_KEY), (Object)this.myState.get(AvdWizardConstants.DISPLAY_SD_SIZE_KEY))) {
            useExisting = true;
        }
        if (!useExisting) {
            userEditedProperties.remove(AvdWizardConstants.EXISTING_SD_LOCATION.name);
            Storage storage = this.myState.get(AvdWizardConstants.DISPLAY_SD_SIZE_KEY);
            this.myState.put(AvdWizardConstants.SD_CARD_STORAGE_KEY, storage);
            if (storage != null) {
                sdCard = AvdEditWizard.toIniString(storage, false);
            }
            hasSdCard = storage != null && storage.getSize() > 0L;
        } else {
            sdCard = this.myState.get(AvdWizardConstants.DISPLAY_SD_LOCATION_KEY);
            this.myState.put(AvdWizardConstants.EXISTING_SD_LOCATION, sdCard);
            userEditedProperties.remove(AvdWizardConstants.SD_CARD_STORAGE_KEY.name);
            assert (sdCard != null);
            hasSdCard = true;
            hardwareProperties.put("hw.sdCard", AvdEditWizard.toIniString(true));
        }
        hardwareProperties.put("hw.sdCard", AvdEditWizard.toIniString(hasSdCard));
        userEditedProperties = Maps.filterEntries(userEditedProperties, (Predicate)new Predicate<Map.Entry<String, Object>>(){

            public boolean apply(Map.Entry<String, Object> input) {
                return !input.getKey().startsWith("AvdManager.WizardOnly.") && input.getValue() != null;
            }
        });
        hardwareProperties.putAll(Maps.transformEntries((Map)userEditedProperties, (Maps.EntryTransformer)new Maps.EntryTransformer<String, Object, String>(){

            public String transformEntry(String key, Object value) {
                if (value instanceof Storage) {
                    if (key.equals(AvdWizardConstants.RAM_STORAGE_KEY.name) || key.equals(AvdWizardConstants.VM_HEAP_STORAGE_KEY.name)) {
                        return AvdEditWizard.toIniString((Storage)value, true);
                    }
                    return AvdEditWizard.toIniString((Storage)value, false);
                }
                if (value instanceof Boolean) {
                    return AvdEditWizard.toIniString((Boolean)value);
                }
                if (value instanceof AvdScaleFactor) {
                    return AvdEditWizard.toIniString((AvdScaleFactor)((Object)value));
                }
                if (value instanceof File) {
                    return AvdEditWizard.toIniString((File)value);
                }
                if (value instanceof Double) {
                    return AvdEditWizard.toIniString((Double)value);
                }
                return value.toString();
            }
        }));
        File skinFile = this.myState.get(AvdWizardConstants.CUSTOM_SKIN_FILE_KEY);
        if (skinFile == null) {
            skinFile = AvdEditWizard.resolveSkinPath(device.getDefaultHardware().getSkinFile(), systemImageDescription);
        }
        if ((backupSkinFile = this.myState.get(AvdWizardConstants.BACKUP_SKIN_FILE_KEY)) != null) {
            hardwareProperties.put("skin.path.backup", backupSkinFile.getPath());
        }
        if (!hardwareProperties.containsKey("skin.dynamic")) {
            hardwareProperties.put("skin.dynamic", AvdEditWizard.toIniString(true));
        }
        if (!hardwareProperties.containsKey("hw.keyboard")) {
            hardwareProperties.put("hw.keyboard", AvdEditWizard.toIniString(false));
        }
        boolean isCircular = device.isScreenRound();
        String tempAvdName = this.myState.get(AvdWizardConstants.AVD_ID_KEY);
        if (tempAvdName == null || tempAvdName.isEmpty()) {
            tempAvdName = AvdEditWizard.calculateAvdName(this.myAvdInfo, hardwareProperties, device, this.myForceCreate);
        }
        final String avdName = tempAvdName;
        if (this.myAvdInfo != null && !this.myForceCreate && (target = this.myAvdInfo.getTarget()) != null) {
            int oldApiLevel = target.getVersion().getFeatureLevel();
            int newApiLevel = systemImageDescription.getVersion().getFeatureLevel();
            final String oldApiName = target.getVersion().getApiString();
            final String newApiName = systemImageDescription.getVersion().getApiString();
            if (oldApiLevel > newApiLevel || oldApiLevel == newApiLevel && target.getVersion().isPreview() && !systemImageDescription.getVersion().isPreview()) {
                final AtomicReference shouldContinue = new AtomicReference();
                ApplicationManager.getApplication().invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        String message = String.format(Locale.getDefault(), "You are about to downgrade %1$s from API level %2$s to API level %3$s.\nThis requires a wipe of the userdata partition of the AVD.\nDo you wish to continue with the data wipe?", avdName, oldApiName, newApiName);
                        int result = Messages.showYesNoDialog((Project)null, (String)message, (String)"Confirm Data Wipe", (Icon)AllIcons.General.QuestionDialog);
                        shouldContinue.set(result == 0);
                    }
                }, ModalityState.any());
                if (((Boolean)shouldContinue.get()).booleanValue()) {
                    AvdManagerConnection.getDefaultAvdManagerConnection().wipeUserData(this.myAvdInfo);
                } else {
                    return;
                }
            }
        }
        AvdManagerConnection connection = AvdManagerConnection.getDefaultAvdManagerConnection();
        connection.createOrUpdateAvd(this.myForceCreate ? null : this.myAvdInfo, avdName, device, systemImageDescription, orientation, isCircular, sdCard, skinFile, hardwareProperties, false);
    }

    @Override
    @NotNull
    protected String getProgressTitle() {
        if ("Saving AVD..." == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/avdmanager/AvdEditWizard", "getProgressTitle"));
        }
        return "Saving AVD...";
    }

    @Override
    @Nullable
    public JComponent getProgressParentComponent() {
        return this.myParent;
    }

    @Nullable
    public static File resolveSkinPath(@Nullable File path, @Nullable SystemImageDescription image) {
        if (path == null || path.getPath().isEmpty()) {
            return path;
        }
        if (path.equals(AvdWizardConstants.NO_SKIN)) {
            return AvdWizardConstants.NO_SKIN;
        }
        if (!path.isAbsolute()) {
            File resourcePath;
            File resourceDir;
            if (image != null) {
                File[] skins;
                for (File skin : skins = image.getSkins()) {
                    if (!skin.getPath().endsWith(File.separator + path.getPath())) continue;
                    return skin;
                }
            }
            if ((resourceDir = DeviceArtDescriptor.getBundledDescriptorsFolder()) != null && (resourcePath = new File(resourceDir, path.getPath())).exists()) {
                return resourcePath;
            }
        }
        return path;
    }

    @NotNull
    private static String toIniString(@NotNull Double value) {
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/android/tools/idea/avdmanager/AvdEditWizard", "toIniString"));
        }
        String string = String.format(Locale.US, "%f", value);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/avdmanager/AvdEditWizard", "toIniString"));
        }
        return string;
    }

    @NotNull
    private static String toIniString(@NotNull File value) {
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/android/tools/idea/avdmanager/AvdEditWizard", "toIniString"));
        }
        String string = value.getPath();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/avdmanager/AvdEditWizard", "toIniString"));
        }
        return string;
    }

    @NotNull
    private static String toIniString(@NotNull AvdScaleFactor value) {
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/android/tools/idea/avdmanager/AvdEditWizard", "toIniString"));
        }
        String string = value.getValue();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/avdmanager/AvdEditWizard", "toIniString"));
        }
        return string;
    }

    @NotNull
    private static String calculateAvdName(@Nullable AvdInfo avdInfo, @NotNull Map<String, String> hardwareProperties, @NotNull Device device, boolean forceCreate) {
        if (hardwareProperties == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "hardwareProperties", "com/android/tools/idea/avdmanager/AvdEditWizard", "calculateAvdName"));
        }
        if (device == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "device", "com/android/tools/idea/avdmanager/AvdEditWizard", "calculateAvdName"));
        }
        if (avdInfo != null && !forceCreate) {
            String string = avdInfo.getName();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/avdmanager/AvdEditWizard", "calculateAvdName"));
            }
            return string;
        }
        String candidateBase = hardwareProperties.get("avd.ini.displayname");
        if (candidateBase == null || candidateBase.isEmpty()) {
            String deviceName = device.getDisplayName().replace(' ', '_');
            String manufacturer = device.getManufacturer().replace(' ', '_');
            candidateBase = String.format("AVD_for_%1$s_by_%2$s", deviceName, manufacturer);
        }
        String string = AvdEditWizard.cleanAvdName(AvdManagerConnection.getDefaultAvdManagerConnection(), candidateBase, true);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/avdmanager/AvdEditWizard", "calculateAvdName"));
        }
        return string;
    }

    public static String cleanAvdName(@NotNull AvdManagerConnection connection, @NotNull String candidateBase, boolean uniquify) {
        if (connection == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "connection", "com/android/tools/idea/avdmanager/AvdEditWizard", "cleanAvdName"));
        }
        if (candidateBase == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "candidateBase", "com/android/tools/idea/avdmanager/AvdEditWizard", "cleanAvdName"));
        }
        if ((candidateBase = candidateBase.replaceAll("[^0-9a-zA-Z_-]+", " ").trim().replaceAll("[ _]+", "_")).isEmpty()) {
            candidateBase = "myavd";
        }
        String candidate = candidateBase;
        if (uniquify) {
            int i = 1;
            while (connection.avdExists(candidate)) {
                candidate = String.format("%1$s_%2$d", candidateBase, i++);
            }
        }
        return candidate;
    }

    @NotNull
    public static String toIniString(@NotNull Storage storage, boolean convertToMb) {
        if (storage == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "storage", "com/android/tools/idea/avdmanager/AvdEditWizard", "toIniString"));
        }
        Storage.Unit unit = convertToMb ? Storage.Unit.MiB : storage.getAppropriateUnits();
        String unitString = convertToMb ? "" : unit.toString().substring(0, 1);
        String string = String.format("%1$d%2$s", storage.getSizeAsUnit(unit), unitString);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/avdmanager/AvdEditWizard", "toIniString"));
        }
        return string;
    }

    @NotNull
    private static String toIniString(@NotNull Boolean b) {
        if (b == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "b", "com/android/tools/idea/avdmanager/AvdEditWizard", "toIniString"));
        }
        String string = b != false ? "yes" : "no";
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/avdmanager/AvdEditWizard", "toIniString"));
        }
        return string;
    }

    private static boolean fromIniString(@Nullable String s) {
        return "yes".equals(s);
    }

    @Override
    protected String getWizardActionDescription() {
        return "Create/Edit an Android Virtual Device";
    }
}

