/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.types.expressions.unqualifiedSuper;

import com.intellij.psi.PsiElement;
import com.intellij.util.SmartList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.TuplesKt;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.descriptors.MemberDescriptor;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.descriptors.annotations.Annotated;
import org.jetbrains.kotlin.incremental.components.LookupLocation;
import org.jetbrains.kotlin.incremental.components.NoLookupLocation;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtDotQualifiedExpression;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtSimpleNameExpression;
import org.jetbrains.kotlin.psi.KtSuperExpression;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.TypeUtils;
import org.jetbrains.kotlin.utils.addToStdlib.AddToStdlibKt;

@Metadata(mv={1, 1, 0}, bv={1, 0, 0}, k=2, d1={"\u0000L\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0007\u001a&\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002\u001a&\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002\u001a\u0018\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\nH\u0002\u001a\u0010\u0010\u0013\u001a\u00020\u000f2\u0006\u0010\u0014\u001a\u00020\u0015H\u0002\u001a\u0018\u0010\u0016\u001a\u00020\u000f2\u0006\u0010\u0017\u001a\u00020\b2\u0006\u0010\u0018\u001a\u00020\u0006H\u0002\u001a\u001c\u0010\u0019\u001a\u00020\u000f2\u0006\u0010\u0014\u001a\u00020\u00152\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\b0\u0005\u001a,\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\b0\u00052\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\b0\u00052\u0006\u0010\u0012\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002\u001a?\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\b0\u00052\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\b0\u00052\u0006\u0010\u001d\u001a\u00020\u000f2\u0018\u0010\u001e\u001a\u0014\u0012\u0004\u0012\u00020\b\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\u00050\u001fH\u0082\b\u001a,\u0010 \u001a\b\u0012\u0004\u0012\u00020\b0\u00052\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\b0\u00052\u0006\u0010!\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002\u001a4\u0010\"\u001a\b\u0012\u0004\u0012\u00020\b0\u00052\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\b0\u00052\u0006\u0010\u0012\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010#\u001a\u00020\bH\u0002\u001a*\u0010$\u001a\b\u0012\u0004\u0012\u00020\b0\u00052\u0006\u0010\u0014\u001a\u00020\u00152\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\b0\u00052\u0006\u0010#\u001a\u00020\b\u001a\f\u0010%\u001a\u00020\u000f*\u00020\bH\u0002\"\u001a\u0010\u0000\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"ARITY_OF_METHODS_OF_ANY", "Ljava/util/HashMap;", "", "", "getFunctionMembers", "", "Lorg/jetbrains/kotlin/descriptors/MemberDescriptor;", "type", "Lorg/jetbrains/kotlin/types/KotlinType;", "name", "Lorg/jetbrains/kotlin/name/Name;", "location", "Lorg/jetbrains/kotlin/incremental/components/LookupLocation;", "getPropertyMembers", "isCallingMethodOfAny", "", "callExpression", "Lorg/jetbrains/kotlin/psi/KtCallExpression;", "calleeName", "isCallingMethodOfAnyWithSuper", "superExpression", "Lorg/jetbrains/kotlin/psi/KtSuperExpression;", "isConcreteMember", "supertype", "memberDescriptor", "isPossiblyAmbiguousUnqualifiedSuper", "supertypes", "resolveSupertypesByCalleeName", "resolveSupertypesByMembers", "allowArbitraryMembers", "getMembers", "Lkotlin/Function1;", "resolveSupertypesByPropertyName", "propertyName", "resolveSupertypesForMethodOfAny", "anyType", "resolveUnqualifiedSuperFromExpressionContext", "isInterface", "kotlin-compiler"})
public final class UnqualifiedSuperKt {
    private static final HashMap<String, Integer> ARITY_OF_METHODS_OF_ANY = MapsKt.hashMapOf(TuplesKt.to("hashCode", 0), TuplesKt.to("equals", 1), TuplesKt.to("toString", 0));

    @NotNull
    public static final Collection<KotlinType> resolveUnqualifiedSuperFromExpressionContext(@NotNull KtSuperExpression superExpression, @NotNull Collection<? extends KotlinType> supertypes2, @NotNull KotlinType anyType) {
        Intrinsics.checkParameterIsNotNull(superExpression, "superExpression");
        Intrinsics.checkParameterIsNotNull(supertypes2, "supertypes");
        Intrinsics.checkParameterIsNotNull(anyType, "anyType");
        PsiElement parentElement = superExpression.getParent();
        if (parentElement instanceof KtDotQualifiedExpression) {
            KtExpression selectorExpression = ((KtDotQualifiedExpression)parentElement).getSelectorExpression();
            KtExpression ktExpression = selectorExpression;
            if (ktExpression instanceof KtCallExpression) {
                KtExpression calleeExpression = ((KtCallExpression)selectorExpression).getCalleeExpression();
                if (calleeExpression instanceof KtSimpleNameExpression) {
                    Name calleeName = ((KtSimpleNameExpression)calleeExpression).getReferencedNameAsName();
                    NoLookupLocation location2 = NoLookupLocation.WHEN_TYPING;
                    if (UnqualifiedSuperKt.isCallingMethodOfAny((KtCallExpression)selectorExpression, calleeName)) {
                        return UnqualifiedSuperKt.resolveSupertypesForMethodOfAny(supertypes2, calleeName, location2, anyType);
                    }
                    return UnqualifiedSuperKt.resolveSupertypesByCalleeName(supertypes2, calleeName, location2);
                }
            } else if (ktExpression instanceof KtSimpleNameExpression) {
                return UnqualifiedSuperKt.resolveSupertypesByPropertyName(supertypes2, ((KtSimpleNameExpression)selectorExpression).getReferencedNameAsName(), NoLookupLocation.WHEN_TYPING);
            }
        }
        return CollectionsKt.emptyList();
    }

    /*
     * WARNING - void declaration
     */
    private static final boolean isCallingMethodOfAny(KtCallExpression callExpression, Name calleeName) {
        void $receiver$iv;
        Map map2 = ARITY_OF_METHODS_OF_ANY;
        String string = calleeName.asString();
        Intrinsics.checkExpressionValueIsNotNull(string, "calleeName.asString()");
        String key$iv = string;
        Object object = $receiver$iv.get(key$iv);
        if (object == null) {
            object = -1;
        }
        return ((Number)object).intValue() == callExpression.getValueArguments().size();
    }

    public static final boolean isPossiblyAmbiguousUnqualifiedSuper(@NotNull KtSuperExpression superExpression, @NotNull Collection<? extends KotlinType> supertypes2) {
        Intrinsics.checkParameterIsNotNull(superExpression, "superExpression");
        Intrinsics.checkParameterIsNotNull(supertypes2, "supertypes");
        return supertypes2.size() > 1 || supertypes2.size() == 1 && UnqualifiedSuperKt.isInterface((KotlinType)CollectionsKt.single((Iterable)supertypes2)) && UnqualifiedSuperKt.isCallingMethodOfAnyWithSuper(superExpression);
    }

    private static final boolean isCallingMethodOfAnyWithSuper(KtSuperExpression superExpression) {
        KtExpression calleeExpression;
        KtExpression selectorExpression;
        PsiElement parent2 = superExpression.getParent();
        if (parent2 instanceof KtDotQualifiedExpression && (selectorExpression = ((KtDotQualifiedExpression)parent2).getSelectorExpression()) instanceof KtCallExpression && (calleeExpression = ((KtCallExpression)selectorExpression).getCalleeExpression()) instanceof KtSimpleNameExpression) {
            Name calleeName = ((KtSimpleNameExpression)calleeExpression).getReferencedNameAsName();
            return UnqualifiedSuperKt.isCallingMethodOfAny((KtCallExpression)selectorExpression, calleeName);
        }
        return false;
    }

    private static final boolean isInterface(KotlinType $receiver) {
        ClassDescriptor classDescriptor = TypeUtils.getClassDescriptor($receiver);
        return Intrinsics.areEqual((Object)(classDescriptor != null ? classDescriptor.getKind() : null), (Object)ClassKind.INTERFACE);
    }

    /*
     * WARNING - void declaration
     */
    private static final Collection<KotlinType> resolveSupertypesForMethodOfAny(Collection<? extends KotlinType> supertypes2, Name calleeName, LookupLocation location2, KotlinType anyType) {
        void $receiver$iv;
        void allowArbitraryMembers$iv232;
        Collection typesWithConcreteOverride;
        boolean bl = false;
        SmartList<KotlinType> typesWithConcreteMembers$iv = new SmartList<KotlinType>();
        SmartList<KotlinType> typesWithArbitraryMembers$iv = new SmartList<KotlinType>();
        Iterator<? extends KotlinType> iterator2 = supertypes2.iterator();
        while (iterator2.hasNext()) {
            boolean bl2;
            KotlinType kotlinType;
            block2: {
                void $receiver$iv$iv;
                Iterable $receiver$iv$iv2;
                Collection<MemberDescriptor> members$iv;
                KotlinType it = kotlinType = iterator2.next();
                Collection<MemberDescriptor> collection = members$iv = UnqualifiedSuperKt.getFunctionMembers(it, calleeName, location2);
                if (!(!$receiver$iv$iv2.isEmpty())) continue;
                typesWithArbitraryMembers$iv.add(kotlinType);
                $receiver$iv$iv2 = members$iv;
                for (Object element$iv$iv : $receiver$iv$iv) {
                    MemberDescriptor it$iv = (MemberDescriptor)element$iv$iv;
                    if (!UnqualifiedSuperKt.isConcreteMember(kotlinType, it$iv)) continue;
                    bl2 = true;
                    break block2;
                }
                bl2 = false;
            }
            if (!bl2) continue;
            typesWithConcreteMembers$iv.add(kotlinType);
        }
        Collection collection = typesWithConcreteMembers$iv;
        Collection allowArbitraryMembers$iv232 = typesWithConcreteOverride = !collection.isEmpty() ? (Collection)typesWithConcreteMembers$iv : (Collection)(allowArbitraryMembers$iv232 != false ? (List)typesWithArbitraryMembers$iv : CollectionsKt.emptyList());
        return !$receiver$iv.isEmpty() ? typesWithConcreteOverride : (Collection)AddToStdlibKt.singletonList(anyType);
    }

    /*
     * WARNING - void declaration
     */
    private static final Collection<KotlinType> resolveSupertypesByCalleeName(Collection<? extends KotlinType> supertypes2, Name calleeName, LookupLocation location2) {
        boolean allowArbitraryMembers$iv = true;
        SmartList<KotlinType> typesWithConcreteMembers$iv = new SmartList<KotlinType>();
        SmartList<KotlinType> typesWithArbitraryMembers$iv = new SmartList<KotlinType>();
        Iterator<? extends KotlinType> iterator2 = supertypes2.iterator();
        while (iterator2.hasNext()) {
            boolean bl;
            KotlinType kotlinType;
            block2: {
                void $receiver$iv$iv;
                Iterable $receiver$iv$iv2;
                Collection members$iv;
                KotlinType it = kotlinType = iterator2.next();
                Collection collection = members$iv = (Collection)CollectionsKt.plus(UnqualifiedSuperKt.getFunctionMembers(it, calleeName, location2), (Iterable)UnqualifiedSuperKt.getPropertyMembers(it, calleeName, location2));
                if (!(!$receiver$iv$iv2.isEmpty())) continue;
                typesWithArbitraryMembers$iv.add(kotlinType);
                $receiver$iv$iv2 = members$iv;
                for (Object element$iv$iv : $receiver$iv$iv) {
                    MemberDescriptor it$iv = (MemberDescriptor)element$iv$iv;
                    if (!UnqualifiedSuperKt.isConcreteMember(kotlinType, it$iv)) continue;
                    bl = true;
                    break block2;
                }
                bl = false;
            }
            if (!bl) continue;
            typesWithConcreteMembers$iv.add(kotlinType);
        }
        Collection collection = typesWithConcreteMembers$iv;
        return !collection.isEmpty() ? (Collection)typesWithConcreteMembers$iv : (Collection)(allowArbitraryMembers$iv ? (List)typesWithArbitraryMembers$iv : CollectionsKt.emptyList());
    }

    /*
     * WARNING - void declaration
     */
    private static final Collection<KotlinType> resolveSupertypesByPropertyName(Collection<? extends KotlinType> supertypes2, Name propertyName, LookupLocation location2) {
        boolean allowArbitraryMembers$iv = true;
        SmartList<KotlinType> typesWithConcreteMembers$iv = new SmartList<KotlinType>();
        SmartList<KotlinType> typesWithArbitraryMembers$iv = new SmartList<KotlinType>();
        Iterator<? extends KotlinType> iterator2 = supertypes2.iterator();
        while (iterator2.hasNext()) {
            boolean bl;
            KotlinType kotlinType;
            block2: {
                void $receiver$iv$iv;
                Iterable $receiver$iv$iv2;
                Collection<MemberDescriptor> members$iv;
                KotlinType it = kotlinType = iterator2.next();
                Collection<MemberDescriptor> collection = members$iv = UnqualifiedSuperKt.getPropertyMembers(it, propertyName, location2);
                if (!(!$receiver$iv$iv2.isEmpty())) continue;
                typesWithArbitraryMembers$iv.add(kotlinType);
                $receiver$iv$iv2 = members$iv;
                for (Object element$iv$iv : $receiver$iv$iv) {
                    MemberDescriptor it$iv = (MemberDescriptor)element$iv$iv;
                    if (!UnqualifiedSuperKt.isConcreteMember(kotlinType, it$iv)) continue;
                    bl = true;
                    break block2;
                }
                bl = false;
            }
            if (!bl) continue;
            typesWithConcreteMembers$iv.add(kotlinType);
        }
        Collection collection = typesWithConcreteMembers$iv;
        return !collection.isEmpty() ? (Collection)typesWithConcreteMembers$iv : (Collection)(allowArbitraryMembers$iv ? (List)typesWithArbitraryMembers$iv : CollectionsKt.emptyList());
    }

    private static final Collection<MemberDescriptor> getFunctionMembers(KotlinType type2, Name name, LookupLocation location2) {
        return type2.getMemberScope().getContributedFunctions(name, location2);
    }

    /*
     * WARNING - void declaration
     */
    private static final Collection<MemberDescriptor> getPropertyMembers(KotlinType type2, Name name, LookupLocation location2) {
        void destination$iv;
        void $receiver$iv;
        Iterable iterable = type2.getMemberScope().getContributedVariables(name, location2);
        Collection collection = new SmartList();
        Iterator iterator2 = $receiver$iv.iterator();
        while (iterator2.hasNext()) {
            Object element$iv;
            Object t = element$iv = iterator2.next();
            if (!(t != null ? t instanceof MemberDescriptor : true)) continue;
            destination$iv.add(element$iv);
        }
        return destination$iv;
    }

    private static final boolean isConcreteMember(KotlinType supertype, MemberDescriptor memberDescriptor) {
        if (Intrinsics.areEqual((Object)memberDescriptor.getModality(), (Object)Modality.ABSTRACT)) {
            return false;
        }
        ClassDescriptor classDescriptorForSupertype = TypeUtils.getClassDescriptor(supertype);
        MemberDescriptor memberDescriptor2 = memberDescriptor;
        if (memberDescriptor2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.descriptors.CallableMemberDescriptor");
        }
        CallableMemberDescriptor.Kind memberKind = ((CallableMemberDescriptor)memberDescriptor2).getKind();
        ClassDescriptor classDescriptor = classDescriptorForSupertype;
        if (Intrinsics.areEqual((Object)(classDescriptor != null ? classDescriptor.getKind() : null), (Object)ClassKind.INTERFACE) && Intrinsics.areEqual((Object)memberKind, (Object)CallableMemberDescriptor.Kind.FAKE_OVERRIDE)) {
            Annotated annotated = ((CallableMemberDescriptor)memberDescriptor).getDispatchReceiverParameter();
            if (annotated == null || (annotated = annotated.getType()) == null) {
                return false;
            }
            Annotated dispatchReceiverType = annotated;
            ClassDescriptor classDescriptor2 = TypeUtils.getClassDescriptor((KotlinType)dispatchReceiverType);
            if (classDescriptor2 == null) {
                return false;
            }
            ClassDescriptor dispatchReceiverClass = classDescriptor2;
            return !KotlinBuiltIns.isAny(dispatchReceiverClass);
        }
        return true;
    }
}

