/*
 * Decompiled with CFR 0.152.
 */
package gnu.trove;

import gnu.trove.HashFunctions;
import gnu.trove.SerializationProcedure;
import gnu.trove.TByteFunction;
import gnu.trove.TByteProcedure;
import gnu.trove.TObjectByteIterator;
import gnu.trove.TObjectByteProcedure;
import gnu.trove.TObjectHash;
import gnu.trove.TObjectHashingStrategy;
import gnu.trove.TObjectProcedure;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TObjectByteHashMap<K>
extends TObjectHash<K> {
    protected transient byte[] _values;

    public TObjectByteHashMap() {
    }

    public TObjectByteHashMap(int initialCapacity) {
        super(initialCapacity);
    }

    public TObjectByteHashMap(int initialCapacity, float loadFactor) {
        super(initialCapacity, loadFactor);
    }

    public TObjectByteHashMap(TObjectHashingStrategy<K> strategy) {
        super(strategy);
    }

    public TObjectByteHashMap(int initialCapacity, TObjectHashingStrategy<K> strategy) {
        super(initialCapacity, strategy);
    }

    public TObjectByteHashMap(int initialCapacity, float loadFactor, TObjectHashingStrategy<K> strategy) {
        super(initialCapacity, loadFactor, strategy);
    }

    public TObjectByteIterator<K> iterator() {
        return new TObjectByteIterator(this);
    }

    @Override
    protected int setUp(int initialCapacity) {
        int capacity = super.setUp(initialCapacity);
        this._values = new byte[capacity];
        return capacity;
    }

    public byte put(K key, byte value) {
        byte previous = 0;
        int index = this.insertionIndex(key);
        boolean isNewMapping = true;
        if (index < 0) {
            index = -index - 1;
            previous = this._values[index];
            isNewMapping = false;
        }
        Object oldKey = this._set[index];
        this._set[index] = key;
        this._values[index] = value;
        if (isNewMapping) {
            this.postInsertHook(oldKey == null);
        }
        return previous;
    }

    @Override
    protected void rehash(int newCapacity) {
        int oldCapacity = this._set.length;
        Object[] oldKeys = this._set;
        byte[] oldVals = this._values;
        this._set = new Object[newCapacity];
        this._values = new byte[newCapacity];
        int i = oldCapacity;
        while (i-- > 0) {
            if (oldKeys[i] == null || oldKeys[i] == REMOVED) continue;
            Object o = oldKeys[i];
            int index = this.insertionIndex(o);
            if (index < 0) {
                this.throwObjectContractViolation(this._set[-index - 1], o);
            }
            this._set[index] = o;
            this._values[index] = oldVals[i];
        }
    }

    public byte get(K key) {
        int index = this.index(key);
        return index < 0 ? (byte)0 : this._values[index];
    }

    @Override
    public void clear() {
        super.clear();
        Object[] keys = this._set;
        byte[] values = this._values;
        int i = keys.length;
        while (i-- > 0) {
            keys[i] = null;
            values[i] = 0;
        }
    }

    public byte remove(K key) {
        byte prev = 0;
        int index = this.index(key);
        if (index >= 0) {
            prev = this._values[index];
            this.removeAt(index);
        }
        return prev;
    }

    public boolean equals(Object other) {
        if (!(other instanceof TObjectByteHashMap)) {
            return false;
        }
        TObjectByteHashMap that = (TObjectByteHashMap)other;
        if (that.size() != this.size()) {
            return false;
        }
        return this.forEachEntry(new EqProcedure(that));
    }

    public int hashCode() {
        HashProcedure p = new HashProcedure();
        this.forEachEntry(p);
        return p.getHashCode();
    }

    @Override
    protected void removeAt(int index) {
        this._values[index] = 0;
        super.removeAt(index);
    }

    public byte[] getValues() {
        byte[] vals = new byte[this.size()];
        byte[] v = this._values;
        Object[] keys = this._set;
        int i = v.length;
        int j = 0;
        while (i-- > 0) {
            if (keys[i] == null || keys[i] == REMOVED) continue;
            vals[j++] = v[i];
        }
        return vals;
    }

    public Object[] keys() {
        Object[] keys = new Object[this.size()];
        Object[] k = this._set;
        int i = k.length;
        int j = 0;
        while (i-- > 0) {
            if (k[i] == null || k[i] == REMOVED) continue;
            keys[j++] = k[i];
        }
        return keys;
    }

    public boolean containsValue(byte val) {
        Object[] keys = this._set;
        byte[] vals = this._values;
        int i = vals.length;
        while (i-- > 0) {
            if (keys[i] == null || keys[i] == REMOVED || val != vals[i]) continue;
            return true;
        }
        return false;
    }

    public boolean containsKey(K key) {
        return this.contains(key);
    }

    public boolean forEachKey(TObjectProcedure<K> procedure) {
        return this.forEach(procedure);
    }

    public boolean forEachValue(TByteProcedure procedure) {
        Object[] keys = this._set;
        byte[] values = this._values;
        int i = values.length;
        while (i-- > 0) {
            if (keys[i] == null || keys[i] == REMOVED || procedure.execute(values[i])) continue;
            return false;
        }
        return true;
    }

    public boolean forEachEntry(TObjectByteProcedure<K> procedure) {
        Object[] keys = this._set;
        byte[] values = this._values;
        int i = keys.length;
        while (i-- > 0) {
            if (keys[i] == null || keys[i] == REMOVED || procedure.execute(keys[i], values[i])) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean retainEntries(TObjectByteProcedure<K> procedure) {
        boolean modified = false;
        Object[] keys = this._set;
        byte[] values = this._values;
        this.stopCompactingOnRemove();
        try {
            int i = keys.length;
            while (i-- > 0) {
                if (keys[i] == null || keys[i] == REMOVED || procedure.execute(keys[i], values[i])) continue;
                this.removeAt(i);
                modified = true;
            }
        }
        finally {
            this.startCompactingOnRemove(modified);
        }
        return modified;
    }

    public void transformValues(TByteFunction function) {
        Object[] keys = this._set;
        byte[] values = this._values;
        int i = values.length;
        while (i-- > 0) {
            if (keys[i] == null || keys[i] == REMOVED) continue;
            values[i] = function.execute(values[i]);
        }
    }

    public boolean increment(K key) {
        return this.adjustValue(key, (byte)1);
    }

    public boolean adjustValue(K key, byte amount) {
        int index = this.index(key);
        if (index < 0) {
            return false;
        }
        int n = index;
        this._values[n] = (byte)(this._values[n] + amount);
        return true;
    }

    private void writeObject(ObjectOutputStream stream) throws IOException {
        stream.defaultWriteObject();
        stream.writeInt(this._size);
        SerializationProcedure writeProcedure = new SerializationProcedure(stream);
        if (!this.forEachEntry(writeProcedure)) {
            throw writeProcedure.exception;
        }
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        stream.defaultReadObject();
        int size = stream.readInt();
        this.setUp(size);
        while (size-- > 0) {
            Object key = stream.readObject();
            byte val = stream.readByte();
            this.put(key, val);
        }
    }

    public String toString() {
        final StringBuilder sb = new StringBuilder();
        this.forEachEntry(new TObjectByteProcedure<K>(){

            @Override
            public boolean execute(K key, byte value) {
                if (sb.length() != 0) {
                    sb.append(',').append(' ');
                }
                sb.append((Object)(key == this ? "(this Map)" : key));
                sb.append('=');
                sb.append(value);
                return true;
            }
        });
        sb.append('}');
        sb.insert(0, '{');
        return sb.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class HashProcedure
    implements TObjectByteProcedure<K> {
        private int h;

        HashProcedure() {
        }

        public int getHashCode() {
            return this.h;
        }

        @Override
        public boolean execute(K key, byte value) {
            this.h += TObjectByteHashMap.this._hashingStrategy.computeHashCode(key) ^ HashFunctions.hash(value);
            return true;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class EqProcedure<K>
    implements TObjectByteProcedure<K> {
        private final TObjectByteHashMap<K> _otherMap;

        EqProcedure(TObjectByteHashMap<K> otherMap) {
            this._otherMap = otherMap;
        }

        @Override
        public final boolean execute(K key, byte value) {
            int index = this._otherMap.index(key);
            return index >= 0 && EqProcedure.eq(value, this._otherMap.get(key));
        }

        private static boolean eq(byte v1, byte v2) {
            return v1 == v2;
        }
    }
}

