/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.model.internal.manage.schema.extract;

import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableList;
import java.io.File;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.List;
import org.gradle.model.internal.type.ModelType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ScalarTypes {
    public static final List<ModelType<?>> TYPES = ImmutableList.of(ModelType.of(String.class), ModelType.of(Boolean.class), ModelType.of(Character.class), ModelType.of(Byte.class), ModelType.of(Short.class), ModelType.of(Integer.class), ModelType.of(Float.class), ModelType.of(Long.class), ModelType.of(Double.class), ModelType.of(BigInteger.class), ModelType.of(BigDecimal.class), ModelType.of(File.class), (Object[])new ModelType[0]);
    public static final List<ModelType<?>> NON_FINAL_TYPES = ImmutableList.of(ModelType.of(BigInteger.class), ModelType.of(BigDecimal.class));

    public static boolean isScalarType(ModelType<?> modelType) {
        for (ModelType<?> type : TYPES) {
            if (!type.equals(modelType)) continue;
            return true;
        }
        for (ModelType<?> type : NON_FINAL_TYPES) {
            if (!type.isAssignableFrom(modelType)) continue;
            return true;
        }
        return false;
    }

    public static List<String> getSupported() {
        return ImmutableList.of((Object)("JDK value types: " + Joiner.on((String)", ").join(TYPES)), (Object)("Any subclass of " + Joiner.on((String)", ").join(NON_FINAL_TYPES)), (Object)"Enum types");
    }
}

