/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.editor.selection;

import com.intellij.codeInsight.editorActions.ExtendWordSelectionHandlerBase;
import com.intellij.codeInsight.editorActions.SelectWordUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.impl.source.tree.LeafPsiElement;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.plugins.groovy.GroovyLanguage;
import org.jetbrains.plugins.groovy.lang.lexer.GroovyTokenTypes;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrClassInitializer;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrVariableDeclaration;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrOpenBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrTypeDefinition;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrMethod;
import org.jetbrains.plugins.groovy.lang.psi.api.toplevel.imports.GrImportStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.toplevel.packaging.GrPackageDefinition;
import org.jetbrains.plugins.groovy.lang.psi.util.PsiUtil;

public class GroovyWordSelectionHandler
extends ExtendWordSelectionHandlerBase {
    private static final Logger LOG = Logger.getInstance(GroovyWordSelectionHandler.class);

    public boolean canSelect(PsiElement e) {
        return (e instanceof GroovyPsiElement || e.getLanguage() == GroovyLanguage.INSTANCE) && e.getNode().getElementType() != GroovyTokenTypes.mDOLLAR;
    }

    public List<TextRange> select(PsiElement e, CharSequence editorText, int cursorOffset, Editor editor) {
        List<TextRange> ranges;
        TextRange originalRange = e.getTextRange();
        LOG.assertTrue(originalRange.getEndOffset() <= editorText.length(), (Object)(((Object)((Object)this)).getClass() + "; " + e));
        if (GroovyWordSelectionHandler.isSeparateStatement(e)) {
            ranges = ExtendWordSelectionHandlerBase.expandToWholeLine((CharSequence)editorText, (TextRange)originalRange, (boolean)true);
            if (ranges.size() == 1 && ranges.contains(originalRange)) {
                ranges = ExtendWordSelectionHandlerBase.expandToWholeLine((CharSequence)editorText, (TextRange)originalRange, (boolean)false);
            }
        } else {
            ranges = new ArrayList();
            ranges.add(e.getTextRange());
        }
        SelectWordUtil.addWordSelection((boolean)editor.getSettings().isCamelWords(), (CharSequence)editorText, (int)cursorOffset, ranges);
        return ranges;
    }

    private static boolean isSeparateStatement(PsiElement e) {
        return e instanceof LeafPsiElement || e instanceof GrExpression && PsiUtil.isExpressionStatement(e) || e instanceof GrVariableDeclaration || e instanceof GrStatement && !(e instanceof GrExpression) || e instanceof GrMethod || e instanceof GrClassInitializer || e instanceof GrImportStatement || e instanceof GrPackageDefinition || e instanceof GrOpenBlock || e instanceof GrTypeDefinition && !((GrTypeDefinition)e).isAnonymous();
    }
}

