/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.annotator;

import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.daemon.impl.HighlightInfoType;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.psi.PsiElement;
import java.util.List;
import org.jetbrains.plugins.groovy.annotator.GrHighlightUtil;
import org.jetbrains.plugins.groovy.lang.psi.GrReferenceElement;
import org.jetbrains.plugins.groovy.lang.psi.GroovyRecursiveElementVisitor;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrVariable;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.params.GrParameter;
import org.jetbrains.plugins.groovy.lang.psi.api.types.GrCodeReferenceElement;
import org.jetbrains.plugins.groovy.lang.psi.util.PsiUtil;

class GrDeclarationHighlightingVisitor
extends GroovyRecursiveElementVisitor {
    private final List<HighlightInfo> myInfos;

    public GrDeclarationHighlightingVisitor(List<HighlightInfo> collector) {
        this.myInfos = collector;
    }

    @Override
    public void visitReferenceExpression(GrReferenceExpression referenceExpression) {
        super.visitReferenceExpression(referenceExpression);
        this.visit(referenceExpression);
    }

    @Override
    public void visitCodeReferenceElement(GrCodeReferenceElement refElement) {
        super.visitCodeReferenceElement(refElement);
        this.visit(refElement);
    }

    @Override
    public void visitVariable(GrVariable variable) {
        TextAttributesKey attribute;
        super.visitVariable(variable);
        if ((PsiUtil.isLocalVariable(variable) || variable instanceof GrParameter) && (attribute = GrHighlightUtil.getDeclarationHighlightingAttribute(variable, null)) != null) {
            PsiElement nameElement = variable.getNameIdentifierGroovy();
            this.addInfo(attribute, nameElement);
        }
    }

    private void visit(GrReferenceElement element) {
        ProgressManager.checkCanceled();
        PsiElement resolved = element.resolve();
        TextAttributesKey attribute = GrHighlightUtil.getDeclarationHighlightingAttribute(resolved, element);
        if (attribute != null) {
            PsiElement refNameElement = GrHighlightUtil.getElementToHighlight(element);
            this.addInfo(attribute, refNameElement);
        }
    }

    private void addInfo(TextAttributesKey attribute, PsiElement nameElement) {
        assert (this.myInfos != null);
        HighlightInfo info = HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.INFORMATION).range(nameElement).needsUpdateOnTyping(false).textAttributes(attribute).create();
        if (info != null) {
            this.myInfos.add(info);
        }
    }
}

