/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.uiDesigner.designSurface;

import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.wm.StatusBar;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.uiDesigner.FormEditingUtil;
import com.intellij.uiDesigner.UIDesignerBundle;
import com.intellij.uiDesigner.designSurface.ComponentDragObject;
import com.intellij.uiDesigner.designSurface.ComponentDropLocation;
import com.intellij.uiDesigner.designSurface.EventProcessor;
import com.intellij.uiDesigner.designSurface.GridInsertProcessor;
import com.intellij.uiDesigner.designSurface.GuiEditor;
import com.intellij.uiDesigner.designSurface.InsertComponentProcessor;
import com.intellij.uiDesigner.lw.IComponent;
import com.intellij.uiDesigner.radComponents.RadComponent;
import com.intellij.uiDesigner.radComponents.RadContainer;
import gnu.trove.TIntArrayList;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;

public class PasteProcessor
extends EventProcessor {
    private final GridInsertProcessor myGridInsertProcessor;
    private final PastedComponentList myPastedComponentList;
    private final GuiEditor myEditor;
    private final ArrayList<RadComponent> myComponentsToPaste;
    private ComponentDropLocation myLastLocation;
    private final int[] myDX;
    private final int[] myDY;
    private final int myMinRow;
    private final int myMinCol;

    public PasteProcessor(GuiEditor editor, ArrayList<RadComponent> componentsToPaste, TIntArrayList xs, TIntArrayList ys) {
        int i;
        this.myEditor = editor;
        this.myComponentsToPaste = componentsToPaste;
        this.myGridInsertProcessor = new GridInsertProcessor(editor);
        this.myPastedComponentList = new PastedComponentList();
        int minX = Integer.MAX_VALUE;
        int minY = Integer.MAX_VALUE;
        for (i = 0; i < xs.size(); ++i) {
            minX = Math.min(minX, xs.get(i));
        }
        for (i = 0; i < ys.size(); ++i) {
            minY = Math.min(minY, ys.get(i));
        }
        this.myDX = new int[xs.size()];
        this.myDY = new int[ys.size()];
        for (i = 0; i < xs.size(); ++i) {
            this.myDX[i] = xs.get(i) - minX;
        }
        for (i = 0; i < ys.size(); ++i) {
            this.myDY[i] = ys.get(i) - minY;
        }
        int myMinRow = Integer.MAX_VALUE;
        int myMinCol = Integer.MAX_VALUE;
        for (RadComponent component : this.myComponentsToPaste) {
            myMinRow = Math.min(myMinRow, component.getConstraints().getRow());
            myMinCol = Math.min(myMinCol, component.getConstraints().getColumn());
        }
        this.myMinRow = myMinRow;
        this.myMinCol = myMinCol;
        StatusBar.Info.set((String)UIDesignerBundle.message("paste.choose.destination.prompt", new Object[0]), (Project)this.myEditor.getProject());
    }

    @Override
    protected void processKeyEvent(KeyEvent e) {
        if (e.getID() == 401) {
            if (e.getKeyCode() == 10) {
                this.doPaste(this.myLastLocation);
                e.consume();
            } else if (e.getKeyCode() == 27) {
                this.endPaste();
                e.consume();
            } else {
                this.myLastLocation = PasteProcessor.moveDropLocation(this.myEditor, this.myLastLocation, this.myPastedComponentList, e);
            }
        }
    }

    @Override
    protected void processMouseEvent(MouseEvent e) {
        if (e.getID() == 503) {
            this.myLastLocation = this.myGridInsertProcessor.processDragEvent(e.getPoint(), this.myPastedComponentList);
            if (this.myLastLocation.canDrop(this.myPastedComponentList)) {
                this.setCursor(FormEditingUtil.getCopyDropCursor());
            } else {
                this.setCursor(FormEditingUtil.getMoveNoDropCursor());
            }
        } else if (e.getID() == 501) {
            this.processMousePressed(e);
        }
    }

    private void processMousePressed(MouseEvent e) {
        ComponentDropLocation location = GridInsertProcessor.getDropLocation(this.myEditor.getRootContainer(), e.getPoint());
        this.doPaste(location);
    }

    private void doPaste(final ComponentDropLocation location) {
        if (location.canDrop(this.myPastedComponentList) && this.myEditor.ensureEditable()) {
            final RadComponent[] componentsToPaste = this.myComponentsToPaste.toArray(new RadComponent[this.myComponentsToPaste.size()]);
            CommandProcessor.getInstance().executeCommand(this.myEditor.getProject(), new Runnable(){

                @Override
                public void run() {
                    location.processDrop(PasteProcessor.this.myEditor, componentsToPaste, null, PasteProcessor.this.myPastedComponentList);
                    for (RadComponent c : componentsToPaste) {
                        FormEditingUtil.iterate(c, new FormEditingUtil.ComponentVisitor(){

                            public boolean visit(IComponent component) {
                                if (component.getBinding() != null) {
                                    InsertComponentProcessor.createBindingField(PasteProcessor.this.myEditor, (RadComponent)component);
                                }
                                return true;
                            }
                        });
                    }
                    FormEditingUtil.selectComponents(PasteProcessor.this.myEditor, PasteProcessor.this.myComponentsToPaste);
                    PasteProcessor.this.myEditor.refreshAndSave(true);
                }
            }, UIDesignerBundle.message("command.paste", new Object[0]), null);
            this.endPaste();
        }
    }

    private void endPaste() {
        this.myEditor.getMainProcessor().stopCurrentProcessor();
        this.myEditor.getActiveDecorationLayer().removeFeedback();
        WindowManager.getInstance().getStatusBar(this.myEditor.getProject()).setInfo("");
    }

    @Override
    protected boolean cancelOperation() {
        WindowManager.getInstance().getStatusBar(this.myEditor.getProject()).setInfo("");
        return true;
    }

    @Override
    public boolean needMousePressed() {
        return true;
    }

    private class PastedComponentList
    implements ComponentDragObject {
        private PastedComponentList() {
        }

        @Override
        public int getComponentCount() {
            return PasteProcessor.this.myComponentsToPaste.size();
        }

        @Override
        public boolean isHGrow() {
            return false;
        }

        @Override
        public boolean isVGrow() {
            return false;
        }

        @Override
        public int getRelativeRow(int componentIndex) {
            return ((RadComponent)PasteProcessor.this.myComponentsToPaste.get(componentIndex)).getConstraints().getRow() - PasteProcessor.this.myMinRow;
        }

        @Override
        public int getRelativeCol(int componentIndex) {
            return ((RadComponent)PasteProcessor.this.myComponentsToPaste.get(componentIndex)).getConstraints().getColumn() - PasteProcessor.this.myMinCol;
        }

        @Override
        public int getRowSpan(int componentIndex) {
            return ((RadComponent)PasteProcessor.this.myComponentsToPaste.get(componentIndex)).getConstraints().getRowSpan();
        }

        @Override
        public int getColSpan(int componentIndex) {
            return ((RadComponent)PasteProcessor.this.myComponentsToPaste.get(componentIndex)).getConstraints().getColSpan();
        }

        @Override
        public Point getDelta(int componentIndex) {
            return new Point(PasteProcessor.this.myDX[componentIndex], PasteProcessor.this.myDY[componentIndex]);
        }

        @Override
        @NotNull
        public Dimension getInitialSize(RadContainer targetContainer) {
            if (PasteProcessor.this.myComponentsToPaste.size() == 1) {
                Dimension dimension = ((RadComponent)PasteProcessor.this.myComponentsToPaste.get(0)).getSize();
                if (dimension == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/uiDesigner/designSurface/PasteProcessor$PastedComponentList", "getInitialSize"));
                }
                return dimension;
            }
            Dimension dimension = new Dimension(-1, -1);
            if (dimension == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/uiDesigner/designSurface/PasteProcessor$PastedComponentList", "getInitialSize"));
            }
            return dimension;
        }
    }
}

