/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.devkit.inspections.quickfix;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.pom.Navigatable;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiReferenceList;
import com.intellij.psi.PsiType;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.devkit.DevKitBundle;
import org.jetbrains.idea.devkit.inspections.quickfix.BaseFix;
import org.jetbrains.idea.devkit.util.PsiUtil;

public class ImplementOrExtendFix
extends BaseFix {
    private final SmartPsiElementPointer<PsiClass> myCompClassPointer;

    private ImplementOrExtendFix(@NotNull PsiClass compClass, @NotNull PsiClass checkedClass, boolean onTheFly) {
        if (compClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "compClass", "org/jetbrains/idea/devkit/inspections/quickfix/ImplementOrExtendFix", "<init>"));
        }
        if (checkedClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "checkedClass", "org/jetbrains/idea/devkit/inspections/quickfix/ImplementOrExtendFix", "<init>"));
        }
        super(PsiUtil.createPointer(checkedClass), onTheFly);
        this.myCompClassPointer = PsiUtil.createPointer(compClass);
    }

    @NotNull
    public static LocalQuickFix[] createFix(PsiClass compClass, PsiClass checkedClass, boolean onTheFly) {
        LocalQuickFix[] localQuickFixArray;
        PsiReferenceList extendsList;
        ImplementOrExtendFix fix = null;
        if (compClass.isInterface() && compClass.getImplementsList() != null) {
            fix = new ImplementOrExtendFix(compClass, checkedClass, onTheFly);
        } else if (!compClass.isInterface() && (extendsList = checkedClass.getExtendsList()) != null) {
            if (extendsList.getReferenceElements().length == 0) {
                fix = new ImplementOrExtendFix(compClass, checkedClass, onTheFly);
            } else if (extendsList.getReferenceElements().length == 1) {
                PsiClassType javaLangObject = PsiType.getJavaLangObject((PsiManager)checkedClass.getManager(), (GlobalSearchScope)checkedClass.getResolveScope());
                if (extendsList.getReferencedTypes()[0].equals((Object)javaLangObject)) {
                    fix = new ImplementOrExtendFix(compClass, checkedClass, onTheFly);
                }
            }
        }
        if (fix != null) {
            LocalQuickFix[] localQuickFixArray2 = new LocalQuickFix[1];
            localQuickFixArray = localQuickFixArray2;
            localQuickFixArray2[0] = fix;
        } else {
            localQuickFixArray = LocalQuickFix.EMPTY_ARRAY;
        }
        if (localQuickFixArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/devkit/inspections/quickfix/ImplementOrExtendFix", "createFix"));
        }
        return localQuickFixArray;
    }

    @NotNull
    public String getName() {
        PsiClass clazz = (PsiClass)this.myCompClassPointer.getElement();
        if (clazz == null) {
            if ("Invalid" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/devkit/inspections/quickfix/ImplementOrExtendFix", "getName"));
            }
            return "Invalid";
        }
        String string = (clazz.isInterface() ? StringUtil.capitalize((String)DevKitBundle.message("keyword.implement", new Object[0])) : StringUtil.capitalize((String)DevKitBundle.message("keyword.extend", new Object[0]))) + " '" + clazz.getQualifiedName() + "'";
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/devkit/inspections/quickfix/ImplementOrExtendFix", "getName"));
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        String string = this.getName();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/devkit/inspections/quickfix/ImplementOrExtendFix", "getFamilyName"));
        }
        return string;
    }

    @Override
    protected void doFix(Project project, ProblemDescriptor descriptor, boolean external) throws IncorrectOperationException {
        PsiReferenceList list;
        PsiElement element = this.myPointer.getElement();
        PsiClass compClass = (PsiClass)this.myCompClassPointer.getElement();
        if (!(element instanceof PsiClass)) {
            return;
        }
        if (compClass == null) {
            return;
        }
        PsiClass clazz = (PsiClass)element;
        PsiElementFactory elementFactory = JavaPsiFacade.getInstance((Project)clazz.getProject()).getElementFactory();
        PsiClassType compType = elementFactory.createType(compClass);
        if (compClass.isInterface()) {
            list = clazz.getImplementsList();
            assert (list != null);
        } else {
            PsiReferenceList extendsList = clazz.getExtendsList();
            assert (extendsList != null);
            if (extendsList.getReferencedTypes().length > 0) {
                extendsList.getReferenceElements()[0].delete();
            }
            list = extendsList;
        }
        PsiElement e = list.add((PsiElement)elementFactory.createReferenceElementByType(compType));
        if (this.myOnTheFly && external && e instanceof Navigatable) {
            ((Navigatable)e).navigate(true);
        }
    }
}

